/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.MesMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringPaths;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringModelStatusCRUDService {
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private TransactionService transactionService;
    private final DKULogger logger = DKULogger.getLogger((String)"dku.services.unifiedMonitoringModelStatusCRUDService");

    @Nonnull
    protected File getModelStatusBaseDir() {
        String nodeType = DKUApp.getInstallNodeType();
        if ("design".equals(nodeType)) {
            return UnifiedMonitoringPaths.getDesignBaseDir();
        }
        if ("automation".equals(nodeType)) {
            return UnifiedMonitoringPaths.getAutomationBaseDir();
        }
        throw new IllegalArgumentException(String.format("Unsupported node type for UnifiedMonitoringModelStatusCRUDService: %s", nodeType));
    }

    @Nonnull
    public ModelStatus getModelStatus(String projectKey, String fullModelId, @Nullable List<String> mesToFilterOn) throws NotFoundException {
        File monitoredManagedApiEndpointsDir = UnifiedMonitoringPaths.getSavedModelVersionBaseDir(projectKey, fullModelId, this.getModelStatusBaseDir());
        if (!monitoredManagedApiEndpointsDir.exists() || !monitoredManagedApiEndpointsDir.isDirectory()) {
            throw new NotFoundException(String.format("No existing model status was found for project %s and Saved Model Version %s", projectKey, fullModelId));
        }
        this.logger.infoV("Retrieving the model status for Saved Model Version %s in project %s", new Object[]{fullModelId, projectKey});
        ArrayList<MesMonitoringStatus> mesMonitoringStatuses = new ArrayList<MesMonitoringStatus>();
        for (File mesMonitoringFile : Objects.requireNonNull(monitoredManagedApiEndpointsDir.listFiles())) {
            String mesId = FilenameUtils.removeExtension((String)mesMonitoringFile.getName());
            if (mesToFilterOn != null && !mesToFilterOn.contains(mesId) || !mesMonitoringFile.isFile()) continue;
            try {
                mesMonitoringStatuses.add(MesMonitoringStatus.readMonitoringStatus(mesMonitoringFile));
            }
            catch (Exception e) {
                this.logger.warn((Object)String.format("Error trying to read MES monitoring status %s, skipping", mesId), (Throwable)e);
            }
        }
        ModelStatus modelStatus = new ModelStatus(fullModelId, mesMonitoringStatuses);
        FullModelId fmi = FullModelId.parse(fullModelId);
        if (fmi != null) {
            modelStatus.savedModelId = fmi.getSavedModelID();
            try {
                NavigatorService.SavedModelFullInfo info = new NavigatorService.SavedModelFullInfo();
                try (Transaction t = this.transactionService.beginRead();){
                    info.model = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelStatus.savedModelId);
                }
                modelStatus.savedModelName = info.model == null ? fmi.getSavedModelID() + " / " + fmi.getUserMeta().name : info.model.name + " / " + fmi.getUserMeta().name;
            }
            catch (IOException e) {
                this.logger.infoV("Unable to retrieve %s display name: %s", new Object[]{fullModelId, e.getMessage()});
            }
        }
        return modelStatus;
    }

    public void saveModelStatus(String projectKey, ModelStatus modelStatus) throws IOException {
        for (MesMonitoringStatus mesMonitoringStatus : modelStatus.mesMonitoringStatuses) {
            this.saveMesMonitoringStatus(projectKey, modelStatus.smvSmartId, mesMonitoringStatus);
        }
    }

    public void deleteMesMonitorings(String mesId) throws IOException {
        this.getMesFiles(mesId).forEach(mesFile -> {
            try {
                DKUFileUtils.delete((File)mesFile);
            }
            catch (IOException e) {
                this.logger.warnV((Throwable)e, "Error trying to delete MES monitoring status %s, skipping it", new Object[]{mesId});
            }
        });
    }

    public void saveMesMonitoringStatus(String projectKey, String savedModelVersionId, MesMonitoringStatus mesMonitoringStatus) throws IOException {
        Preconditions.checkNotNull((Object)mesMonitoringStatus.id, (Object)"Mes id can not be null");
        File savedModelVersionBaseDir = UnifiedMonitoringPaths.getSavedModelVersionBaseDir(projectKey, savedModelVersionId, this.getModelStatusBaseDir());
        DKUFileUtils.mkdirs((File)savedModelVersionBaseDir);
        this.logger.infoV("Saving MES monitoring for project %s, Saved Model Version %s, MES %s to file", new Object[]{projectKey, savedModelVersionId, mesMonitoringStatus.id});
        JSON.prettyToFile((Object)mesMonitoringStatus, (File)new File(savedModelVersionBaseDir, mesMonitoringStatus.id + ".json"));
    }

    public void saveMesMonitoringStatus(File mesMonitoringFile, MesMonitoringStatus mesMonitoringStatus) throws IOException {
        FullModelId fullModelId = FullModelId.parse(mesMonitoringFile.getParentFile().getName());
        this.saveMesMonitoringStatus(fullModelId.getProjectKey(), fullModelId.toString(), mesMonitoringStatus);
    }

    public File getMesMonitoringFile(String projectKey, String fullModelId, String mesId) {
        return UnifiedMonitoringPaths.getMesMonitoring(projectKey, fullModelId, mesId, this.getModelStatusBaseDir());
    }

    public List<File> getMesFiles(String mesId) throws IOException {
        return DKUFileUtils.recursiveListFiles((File)this.getModelStatusBaseDir()).stream().filter(file -> FilenameUtils.removeExtension((String)file.getName()).equals(mesId)).collect(Collectors.toList());
    }
}

