/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class FactN
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length != 2) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects two numbers");
        }
        if (args[0] == null || !(args[0] instanceof Number)) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects the first parameter to be a number");
        }
        if (args[1] == null || !(args[1] instanceof Number)) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects the second parameter to be a number");
        }
        return FactN.factorial(((Number)args[0]).intValue(), ((Number)args[1]).intValue());
    }

    public static long factorial(long i, long step) {
        if (i < 0L) {
            throw new IllegalArgumentException("Can't compute the factorial of a negative number");
        }
        if (i <= 1L) {
            return 1L;
        }
        long result = i * FactN.factorial(i - step, step);
        if (result < 0L) {
            throw new ArithmeticException("Integer overflow computing factorial");
        }
        return result;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.FactN.DOCUMENTATION", "Returns the factorial of a number <code>i</code>, omitting every <code>d</code>th item from the multiplication.").withParams("number i, number d").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("7", "3").returns("28"));
    }
}

