/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.List;
import java.util.Properties;

public class Sum
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " requires at least one argument");
        }
        List<?> input = DKUFormulaUtils.asList(args);
        int length = input.size();
        double total = 0.0;
        for (int i = 0; i < length; ++i) {
            Object n = input.get(length - i - 1);
            Double value = DKUDoubles.tryParse((String)String.valueOf(n));
            if (value == null) continue;
            total += value.doubleValue();
        }
        return total;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Sum.DOCUMENTATION", "Sums the numbers of an array. Skips non-number elements from the array.").withParams("array a | value1, value2 ...").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("[1, 2, 3]").returns("6.0")).withExample(Example.with("1, 2, 3").returns("6.0")).withExample(Example.with("[[10, 11], 1, 2, \"string\", 3]").returns("6.0")).withExample(Example.with("[10, 11], 1, 2, \"string\", 3").returns("6.0")).withExample(Example.with("\"[1, 2, 3]\"").returns("6.0"));
    }
}

