/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.spark.HDFSDatasetRDD$;
import com.dataiku.dip.spark.NativeFormatWriter;
import com.dataiku.dip.spark.package$;
import java.io.Serializable;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class CsvWriter$
extends NativeFormatWriter {
    public static CsvWriter$ MODULE$;
    private final Logger logger;

    static {
        new CsvWriter$();
    }

    public Map<String, String> prepareSaveCsvDataset(DatasetHandler handler, org.apache.spark.sql.Dataset<Row> df) {
        Dataset dataset = handler.getDataset();
        if (handler instanceof HDFSableDatasetHandler) {
            HDFSableDatasetHandler hdfsable = (HDFSableDatasetHandler)handler;
            hdfsable.addExtraConf(df.sqlContext().sparkContext().hadoopConfiguration(), true);
            hdfsable.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        }
        CSVFormatConfig csvFormatConfig = (CSVFormatConfig)dataset.getFormatParamsAs(CSVFormatConfig.class);
        scala.collection.mutable.Map options = Map$.MODULE$.empty();
        Object object = "gz".equals(csvFormatConfig.compress) ? options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"codec"), (Object)"gzip")) : BoxedUnit.UNIT;
        Object object2 = csvFormatConfig.parseHeaderRow ? options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header"), (Object)"true")) : BoxedUnit.UNIT;
        options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"emptyValue"), (Object)""));
        options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sep"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getSeparatorChar()))));
        options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampNTZFormat"), (Object)"yyyy-MM-dd HH:mm:ss[.SSS]"));
        CSVFormatConfig.CSVStyle cSVStyle = csvFormatConfig.style;
        if (CSVFormatConfig.CSVStyle.EXCEL.equals(cSVStyle)) {
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getQuoteChar()))));
            scala.collection.mutable.Map cfr_ignored_0 = (scala.collection.mutable.Map)options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getQuoteChar()))));
        } else if (CSVFormatConfig.CSVStyle.UNIX.equals(cSVStyle)) {
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getQuoteChar()))));
            scala.collection.mutable.Map cfr_ignored_1 = (scala.collection.mutable.Map)options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getEscapeChar()))));
        } else if (CSVFormatConfig.CSVStyle.ESCAPE_ONLY_NO_QUOTE.equals(cSVStyle)) {
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getEscapeChar()))));
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoteMode"), (Object)"NONE"));
            scala.collection.mutable.Map cfr_ignored_2 = (scala.collection.mutable.Map)options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)"\u0000"));
        } else if (CSVFormatConfig.CSVStyle.NO_ESCAPE_NO_QUOTE.equals(cSVStyle)) {
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoteMode"), (Object)"NONE"));
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)""));
            scala.collection.mutable.Map cfr_ignored_3 = (scala.collection.mutable.Map)options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)"\u0000"));
        } else {
            throw new MatchError((Object)cSVStyle);
        }
        CSVFormatConfig.DateSerializationFormat dateSerializationFormat = csvFormatConfig.dateSerializationFormat;
        if (CSVFormatConfig.DateSerializationFormat.HIVE.equals(dateSerializationFormat)) {
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
            scala.collection.mutable.Map cfr_ignored_4 = (scala.collection.mutable.Map)options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd HH:mm:ss.S"));
        } else if (CSVFormatConfig.DateSerializationFormat.ISO.equals(dateSerializationFormat)) {
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
            scala.collection.mutable.Map cfr_ignored_5 = (scala.collection.mutable.Map)options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        } else if (CSVFormatConfig.DateSerializationFormat.ISO_STRICT.equals(dateSerializationFormat)) {
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
            scala.collection.mutable.Map cfr_ignored_6 = (scala.collection.mutable.Map)options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        } else if (CSVFormatConfig.DateSerializationFormat.ISO_FORCED_UTC.equals(dateSerializationFormat)) {
            options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
            scala.collection.mutable.Map cfr_ignored_7 = (scala.collection.mutable.Map)options.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        } else {
            throw new MatchError((Object)dateSerializationFormat);
        }
        return options.toMap(Predef$.MODULE$.$conforms());
    }

    public void saveCsvDataset(HDFSableDatasetHandler handler, org.apache.spark.sql.Dataset<Row> df, String partition, Enumeration.Value writeMode, String apiTicket) {
        Dataset dataset = handler.getDataset();
        Partition dssPartition = partition != null ? PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition) : null;
        SaveMode saveMode = HDFSDatasetRDD$.MODULE$.clearDataset(dataset, dssPartition, writeMode, apiTicket);
        String path = partition != null ? handler.getFullyQualifiedPartitionPath(dssPartition) : handler.getFullyQualifiedRootPath();
        Map<String, String> options = this.prepareSaveCsvDataset((DatasetHandler)handler, df);
        CSVFormatConfig csvFormatConfig = (CSVFormatConfig)dataset.getFormatParamsAs(CSVFormatConfig.class);
        org.apache.spark.sql.Dataset<Row> dssDataframe = this.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged(), csvFormatConfig);
        this.logger().info((Object)new StringBuilder(27).append("Saving dataframe as csv to ").append(path).toString());
        DataFrameWriter dswBuilder = dssDataframe.write().mode(saveMode);
        dswBuilder.options(options);
        dswBuilder.format("csv").save(path);
    }

    public org.apache.spark.sql.Dataset<Row> adaptDataFrame(org.apache.spark.sql.Dataset<Row> df, Schema dssSchema, boolean isManaged, CSVFormatConfig csvFormatConfig) {
        ObjectRef dssDataframe = ObjectRef.create(df);
        df.schema().foreach((Function1 & Serializable & scala.Serializable)field -> {
            CsvWriter$.$anonfun$adaptDataFrame$1(dssDataframe, df, dssSchema, csvFormatConfig, field);
            return BoxedUnit.UNIT;
        });
        return (org.apache.spark.sql.Dataset)dssDataframe.elem;
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ void $anonfun$adaptDataFrame$1(ObjectRef dssDataframe$1, org.apache.spark.sql.Dataset df$1, Schema dssSchema$1, CSVFormatConfig csvFormatConfig$1, StructField field) {
        DataType dataType;
        DataType dataType2 = field.dataType();
        TimestampType$ timestampType$ = TimestampType$.MODULE$;
        if (dataType2 == null ? timestampType$ != null : !dataType2.equals(timestampType$)) {
            DataType dataType3 = field.dataType();
            DataType dataType4 = package$.MODULE$.datetimeNoTzDataType();
            if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                return;
            }
        }
        if (BooleanType$.MODULE$.equals(dataType = field.dataType()) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType)))))))) {
            return;
        }
        if (dataType instanceof DecimalType) {
            MODULE$.logger().debug((Object)new StringBuilder(34).append("saving dataframe column ").append(field.name()).append(" as double").toString());
            dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), df$1.col(field.name()).cast((DataType)DoubleType$.MODULE$));
            return;
        }
        if (dataType instanceof DateType) {
            SchemaColumn dssCol = dssSchema$1.getColumn(field.name());
            if (dssCol != null) {
                Type type = dssCol.getType();
                Type type2 = Type.DATE;
                if (!(type != null ? !type.equals(type2) : type2 != null)) {
                    String tzId = TimeZone.getDefault().getID();
                    MODULE$.logger().debug((Object)new StringBuilder(57).append("saving dataframe column ").append(field.name()).append(" as datetime with tz switch from ").append(tzId).toString());
                    dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), functions$.MODULE$.from_utc_timestamp(df$1.col(field.name()).cast((DataType)TimestampType$.MODULE$), tzId));
                    return;
                }
            }
            if (dssCol != null) {
                Type type = dssCol.getType();
                Type type3 = Type.STRING;
                if (!(type != null ? !type.equals(type3) : type3 != null)) {
                    MODULE$.logger().debug((Object)new StringBuilder(34).append("saving dataframe column ").append(field.name()).append(" as string").toString());
                    dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), df$1.col(field.name()).cast((DataType)StringType$.MODULE$));
                    return;
                }
            }
            return;
        }
        if (dataType instanceof TimestampType) {
            CSVFormatConfig.DateSerializationFormat dateSerializationFormat = csvFormatConfig$1.dateSerializationFormat;
            CSVFormatConfig.DateSerializationFormat dateSerializationFormat2 = CSVFormatConfig.DateSerializationFormat.ISO_FORCED_UTC;
            if (!(dateSerializationFormat != null ? !dateSerializationFormat.equals(dateSerializationFormat2) : dateSerializationFormat2 != null)) {
                String tzId = TimeZone.getDefault().getID();
                MODULE$.logger().debug((Object)new StringBuilder(57).append("saving dataframe column ").append(field.name()).append(" as datetime with tz switch from ").append(tzId).toString());
                dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), functions$.MODULE$.to_utc_timestamp(df$1.col(field.name()), tzId));
                return;
            }
            return;
        }
        if (dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType)) {
            dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), com.dataiku.dip.spark.compat.package$.MODULE$.dku_to_json(df$1.col(field.name())));
            return;
        }
        MODULE$.logger().debug((Object)new StringBuilder(34).append("saving dataframe column ").append(field.name()).append(" as string").toString());
        dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), df$1.col(field.name()).cast((DataType)StringType$.MODULE$));
    }

    private CsvWriter$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.csv");
    }
}

