/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.hive.executor;

import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.ExecutionResults;
import com.dataiku.hproxy.sandbox.hive.executor.IResultFetcher;
import java.util.ArrayList;
import java.util.List;

public class ExplainPlanResultFetcher
implements IResultFetcher {
    private final List<String> lines;
    private int index;
    private final List<ColumnSchema> schema;

    public ExplainPlanResultFetcher(List<String> lines) {
        this.lines = lines;
        this.index = 0;
        this.schema = new ArrayList<ColumnSchema>();
        this.schema.add(new ColumnSchema().withName("plan").withType("string"));
    }

    @Override
    public int getCurrentRowIndex() {
        return this.index;
    }

    @Override
    public void skip(long n) {
        this.index = (int)((long)this.index + n);
    }

    @Override
    public ExecutionResults fetch(long n) {
        ExecutionResults res = new ExecutionResults();
        res.columns = this.schema;
        res.firstRowOffset = this.index;
        res.rows = new ArrayList();
        while (this.index < this.lines.size() && (long)res.rows.size() < n) {
            res.rows.add(new String[]{this.lines.get(this.index)});
            ++this.index;
        }
        return res;
    }

    @Override
    public void close() {
    }
}

