/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.admin;

import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.auth.ApiNodeAuthVerificationService;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.dataiku.lambda.monitoring.ActivityMonitoringService;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import com.dataiku.lambda.services.ServicesService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ServerSettingsAdminController
extends LambdaAPIControllerBase {
    @Autowired
    private ApiNodeAuthVerificationService authService;
    @Autowired
    private ServicesService servicesService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LambdaContext lambdaContext;
    @Autowired
    private ActivityMonitoringService activityMonitoringService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.admin.api");

    @AuditedCall(value={"msgType", "audit-settings-get"})
    @RequestMapping(value={"/admin/api/audit-settings"}, method={RequestMethod.GET})
    public void getAuditSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        ServerSettingsAdminController.writeJSON(resp, this.lambdaContext.getAuditConfig());
    }

    @AuditedCall(value={"msgType", "audit-settings-save"})
    @RequestMapping(value={"/admin/api/audit-settings"}, method={RequestMethod.POST})
    public void saveAuditSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        LambdaServerConfig.AuditLog al = (LambdaServerConfig.AuditLog)JSON.parse((InputStream)req.getInputStream(), LambdaServerConfig.AuditLog.class);
        this.lambdaContext.saveAuditConfig(al);
        this.auditTrailService.reconfigure(al.settings);
    }

    @AuditedCall(value={"msgType", "activity-monitoring-settings-save"})
    @RequestMapping(value={"/admin/api/activity-monitoring-settings"}, method={RequestMethod.POST})
    public void saveActivityMonitoringSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        ActivityMonitoringSettings settings = (ActivityMonitoringSettings)JSON.parse((InputStream)req.getInputStream(), ActivityMonitoringSettings.class);
        boolean activitySchedulingChanges = this.lambdaContext.saveActivityMonitoringConfig(settings);
        if (activitySchedulingChanges) {
            this.activityMonitoringService.cancelSchedule();
            this.activityMonitoringService.scheduleSendActivityIfNeeded(1);
        }
    }

    static class ProtoService {
        String serviceId;

        ProtoService() {
        }
    }
}

