/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.export;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.definitions.types.bool.StoredBooleanFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.category.StoredCategoryFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.date.StoredDateFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.file.StoredUploadedFileFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.number.StoredNumberFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.StoredReferenceFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.backreference.BackreferenceFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.text.StoredTextFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.time_series.StoredTimeSeriesFieldDefinition;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.services.artifacts.IArtifactsService;
import com.dataiku.gh.core.services.export.FieldAndListValuePrinterVisitor;
import com.dataiku.gh.core.services.uploaded_files.IUploadedFilesService;
import com.dataiku.gh.core.visitors.IFieldDefinitionVisitor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;

public class FieldDefinitionExportVisitor
implements IFieldDefinitionVisitor {
    Object fieldValue;
    UIArtifact uiArtifact;
    IArtifactsService artifactsService;
    IUploadedFilesService uploadedFilesService;
    AuthCtx authCtx;
    List<String> exportFieldValues = new ArrayList<String>();
    FieldType fieldType;

    public FieldDefinitionExportVisitor(Object fieldValue, UIArtifact uiArtifact, IArtifactsService artifactsService, IUploadedFilesService uploadedFilesService, AuthCtx authCtx) {
        this.fieldValue = fieldValue;
        this.uiArtifact = uiArtifact;
        this.artifactsService = artifactsService;
        this.uploadedFilesService = uploadedFilesService;
        this.authCtx = authCtx;
    }

    @Override
    public void visit(StoredBooleanFieldDefinition fieldDefinition, String fieldId) {
        this.fieldType = fieldDefinition.fieldType;
        new FieldAndListValuePrinterVisitor(this.exportFieldValues){

            @Override
            public void visit(Boolean booleanFieldValue) {
                this.exportFieldValues.add(booleanFieldValue.toString());
            }
        }.visit(this.fieldValue);
    }

    @Override
    public void visit(StoredCategoryFieldDefinition fieldDefinition, String fieldId) {
        this.fieldType = fieldDefinition.fieldType;
        new FieldAndListValuePrinterVisitor(this.exportFieldValues){

            @Override
            public void visit(String categoryFieldValue) {
                this.exportFieldValues.add(categoryFieldValue);
            }
        }.visit(this.fieldValue);
    }

    @Override
    public void visit(StoredDateFieldDefinition fieldDefinition, String fieldId) {
        this.fieldType = fieldDefinition.fieldType;
        new FieldAndListValuePrinterVisitor(this.exportFieldValues){

            @Override
            public void visit(String dateFieldValue) {
                this.exportFieldValues.add(dateFieldValue);
            }
        }.visit(this.fieldValue);
    }

    @Override
    public void visit(StoredNumberFieldDefinition fieldDefinition, String fieldId) {
        this.fieldType = fieldDefinition.fieldType;
        new FieldAndListValuePrinterVisitor(this.exportFieldValues){

            @Override
            public void visit(Double numberFieldValue) {
                this.exportFieldValues.add(numberFieldValue.toString());
            }
        }.visit(this.fieldValue);
    }

    @Override
    public void visit(StoredReferenceFieldDefinition fieldDefinition, String fieldId) {
        this.fieldType = fieldDefinition.fieldType;
        new FieldAndListValuePrinterVisitor(this.exportFieldValues){

            @Override
            public void visit(String referenceFieldValue) {
                StringBuilder builder = new StringBuilder();
                try {
                    builder.append(referenceFieldValue).append(": ").append(FieldDefinitionExportVisitor.this.artifactsService.getArtifact((AuthCtx)FieldDefinitionExportVisitor.this.authCtx, (String)referenceFieldValue).artifact.name);
                }
                catch (DKUSecurityException e) {
                    builder.append("Access denied (").append(referenceFieldValue).append(")");
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                this.exportFieldValues.add(builder.toString());
            }
        }.visit(this.fieldValue);
    }

    @Override
    public void visit(BackreferenceFieldDefinition fieldDefinition, String fieldId) {
        this.fieldType = fieldDefinition.fieldType;
        new FieldAndListValuePrinterVisitor(this.exportFieldValues){

            @Override
            public void visit(String backreferenceFieldValue) {
                StringBuilder builder = new StringBuilder();
                try {
                    builder.append(backreferenceFieldValue).append(": ").append(FieldDefinitionExportVisitor.this.artifactsService.getArtifact((AuthCtx)FieldDefinitionExportVisitor.this.authCtx, (String)backreferenceFieldValue).artifact.name);
                }
                catch (DKUSecurityException e) {
                    builder.append("Access denied (").append(backreferenceFieldValue).append(")");
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                this.exportFieldValues.add(builder.toString());
            }
        }.visit(this.fieldValue);
    }

    @Override
    public void visit(StoredTextFieldDefinition fieldDefinition, String fieldId) {
        this.fieldType = fieldDefinition.fieldType;
        new FieldAndListValuePrinterVisitor(this.exportFieldValues){

            @Override
            public void visit(String textFieldDefinition) {
                this.exportFieldValues.add(textFieldDefinition);
            }
        }.visit(this.fieldValue);
    }

    @Override
    public void visit(StoredUploadedFileFieldDefinition fieldDefinition, String fieldId) {
        this.fieldType = fieldDefinition.fieldType;
        new FieldAndListValuePrinterVisitor(this.exportFieldValues){

            @Override
            public void visit(String uploadedFileFieldValue) {
                StringBuilder builder = new StringBuilder();
                try {
                    builder.append(uploadedFileFieldValue).append(": ").append(FieldDefinitionExportVisitor.this.uploadedFilesService.getUploadedFileDesc((AuthCtx)FieldDefinitionExportVisitor.this.authCtx, (String)uploadedFileFieldValue).name);
                }
                catch (DKUSecurityException e) {
                    builder.append("Access denied (").append(uploadedFileFieldValue).append(")");
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                this.exportFieldValues.add(builder.toString());
            }
        }.visit(this.fieldValue);
    }

    @Override
    public void visit(StoredTimeSeriesFieldDefinition fieldDefinition, String fieldId) {
        this.fieldType = fieldDefinition.fieldType;
        new FieldAndListValuePrinterVisitor(this.exportFieldValues){

            @Override
            public void visit(String timeSeriesFieldValue) {
                this.exportFieldValues.add(timeSeriesFieldValue);
            }
        }.visit(this.fieldValue);
    }
}

