/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.jwk;

import java.net.URI;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.snowflake.ingest.internal.com.nimbusds.jose.Algorithm;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.KeyOperation;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.KeyType;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.KeyUse;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.JSONObjectUtils;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.X509CertChainUtils;

final class JWKMetadata {
    JWKMetadata() {
    }

    static KeyType parseKeyType(Map<String, Object> o) throws ParseException {
        try {
            return KeyType.parse(JSONObjectUtils.getString(o, "kty"));
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    static KeyUse parseKeyUse(Map<String, Object> o) throws ParseException {
        return KeyUse.parse(JSONObjectUtils.getString(o, "use"));
    }

    static Set<KeyOperation> parseKeyOperations(Map<String, Object> o) throws ParseException {
        return KeyOperation.parse(JSONObjectUtils.getStringList(o, "key_ops"));
    }

    static Algorithm parseAlgorithm(Map<String, Object> o) throws ParseException {
        return Algorithm.parse(JSONObjectUtils.getString(o, "alg"));
    }

    static String parseKeyID(Map<String, Object> o) throws ParseException {
        return JSONObjectUtils.getString(o, "kid");
    }

    static URI parseX509CertURL(Map<String, Object> o) throws ParseException {
        return JSONObjectUtils.getURI(o, "x5u");
    }

    static Base64URL parseX509CertThumbprint(Map<String, Object> o) throws ParseException {
        return JSONObjectUtils.getBase64URL(o, "x5t");
    }

    static Base64URL parseX509CertSHA256Thumbprint(Map<String, Object> o) throws ParseException {
        return JSONObjectUtils.getBase64URL(o, "x5t#S256");
    }

    static List<Base64> parseX509CertChain(Map<String, Object> o) throws ParseException {
        List<Base64> chain = X509CertChainUtils.toBase64List(JSONObjectUtils.getJSONArray(o, "x5c"));
        if (chain == null || !chain.isEmpty()) {
            return chain;
        }
        return null;
    }
}

