/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.interpreter.broker;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.toree.interpreter.broker.BrokerCode;
import org.apache.toree.interpreter.broker.BrokerException;
import org.apache.toree.interpreter.broker.BrokerPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001\u0002\u000f\u001e\u0001!B\u0001b\f\u0001\u0003\u0006\u0004%I\u0001\r\u0005\ti\u0001\u0011\t\u0011)A\u0005c!)Q\u0007\u0001C\u0001m!9!\b\u0001b\u0001\n\u0013Y\u0004B\u0002\"\u0001A\u0003%A\bC\u0004D\u0001\u0001\u0007I\u0011\u0002#\t\u000f!\u0003\u0001\u0019!C\u0005\u0013\"1q\n\u0001Q!\n\u0015Cq\u0001\u0016\u0001C\u0002\u0013EQ\u000b\u0003\u0004b\u0001\u0001\u0006IA\u0016\u0005\bE\u0002\u0011\r\u0011\"\u0005d\u0011\u001d\tI\u0001\u0001Q\u0001\n\u0011D\u0011\"a\u0003\u0001\u0005\u0004%\t\"!\u0004\t\u0011\u0005}\u0002\u0001)A\u0005\u0003\u001fAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002h!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAM\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003;\u0003A\u0011AAP\u0011\u0019\t\t\u000b\u0001C\u0001\t\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003O\u0003A\u0011AAX\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!a-\u0001\t\u0003\tY\fC\u0004\u0002@\u0002!\t!!1\t\u0013\u0005-\u0007!%A\u0005\u0002\u00055'a\u0003\"s_.,'o\u0015;bi\u0016T!AH\u0010\u0002\r\t\u0014xn[3s\u0015\t\u0001\u0013%A\u0006j]R,'\u000f\u001d:fi\u0016\u0014(B\u0001\u0012$\u0003\u0015!xN]3f\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\u001b5\f\u00070U;fk\u0016$7i\u001c3f+\u0005\t\u0004C\u0001\u00163\u0013\t\u00194FA\u0002J]R\fa\"\\1y#V,W/\u001a3D_\u0012,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003oe\u0002\"\u0001\u000f\u0001\u000e\u0003uAQaL\u0002A\u0002E\na\u0001\\8hO\u0016\u0014X#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}*\u0013!B:mMRR\u0017BA!?\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001C0jgJ+\u0017\rZ=\u0016\u0003\u0015\u0003\"A\u000b$\n\u0005\u001d[#a\u0002\"p_2,\u0017M\\\u0001\r?&\u001c(+Z1es~#S-\u001d\u000b\u0003\u00156\u0003\"AK&\n\u00051[#\u0001B+oSRDqAT\u0004\u0002\u0002\u0003\u0007Q)A\u0002yIE\n\u0011bX5t%\u0016\fG-\u001f\u0011)\u0005!\t\u0006C\u0001\u0016S\u0013\t\u00196F\u0001\u0005w_2\fG/\u001b7f\u0003%\u0019w\u000eZ3Rk\u0016,X-F\u0001W!\r9FLX\u0007\u00021*\u0011\u0011LW\u0001\u0005kRLGNC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&!B)vKV,\u0007C\u0001\u001d`\u0013\t\u0001WD\u0001\u0006Ce>\\WM]\"pI\u0016\f!bY8eKF+X-^3!\u0003)\u0001(o\\7jg\u0016l\u0015\r]\u000b\u0002IB)QM\u001b7\u0002\u00045\taM\u0003\u0002hQ\u00069Q.\u001e;bE2,'BA5,\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003W\u001a\u00141!T1q!\tiWP\u0004\u0002ow:\u0011qN\u001f\b\u0003aft!!\u001d=\u000f\u0005I<hBA:w\u001b\u0005!(BA;(\u0003\u0019a$o\\8u}%\ta%\u0003\u0002%K%\u0011!eI\u0005\u0003A\u0005J!AH\u0010\n\u0005ql\u0012a\u0003\"s_.,'\u000fV=qKNL!A`@\u0003\r\r{G-Z%e\u0013\r\t\t!\b\u0002\u0014\u0005J|7.\u001a:UsB,7\u000f\u0015:pm&$WM\u001d\t\u0004q\u0005\u0015\u0011bAA\u0004;\ti!I]8lKJ\u0004&o\\7jg\u0016\f1\u0002\u001d:p[&\u001cX-T1qA\u0005)r.\u001e;qkR\u0014Vm];miN#(/Z1n\u001b\u0006\u0004XCAA\b!\u0015)'\u000e\\A\t!\u0015Q\u00131CA\f\u0013\r\t)b\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005e\u0011\u0011\b\b\u0005\u00037\t\u0019D\u0004\u0003\u0002\u001e\u0005=b\u0002BA\u0010\u0003SqA!!\t\u0002&9\u00191/a\t\n\u00031J1!a\n,\u0003\u0015!xn\u001c7t\u0013\u0011\tY#!\f\u0002\u00079\u001c8MC\u0002\u0002(-J1\u0001IA\u0019\u0015\u0011\tY#!\f\n\t\u0005U\u0012qG\u0001\ba\u0006\u001c7.Y4f\u0015\r\u0001\u0013\u0011G\u0005\u0005\u0003w\tiD\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fWN\u0003\u0003\u00026\u0005]\u0012AF8viB,HOU3tk2$8\u000b\u001e:fC6l\u0015\r\u001d\u0011\u0002\u0011A,8\u000f[\"pI\u0016$b!!\u0012\u0002X\u0005\u0005\u0004CBA$\u0003\u001b\n\t&\u0004\u0002\u0002J)\u0019\u00111J\u0016\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002P\u0005%#A\u0002$viV\u0014X\rE\u0002n\u0003'J1!!\u0016\u0000\u0005-\u0019u\u000eZ3SKN,H\u000e^:\t\u000f\u0005es\u00021\u0001\u0002\\\u0005!1m\u001c3f!\ri\u0017QL\u0005\u0004\u0003?z(\u0001B\"pI\u0016D\u0011\"a\u0019\u0010!\u0003\u0005\r!!\u0005\u0002%=,H\u000f];u%\u0016\u001cX\u000f\u001c;TiJ,\u0017-\\\u0001\u0013aV\u001c\bnQ8eK\u0012\"WMZ1vYR$#'\u0006\u0002\u0002j)\"\u0011\u0011CA6W\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA<W\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0014\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AC:f]\u0012|U\u000f\u001e9viR)!*!!\u0002\u0016\"9\u00111Q\tA\u0002\u0005\u0015\u0015AB2pI\u0016LE\r\u0005\u0003\u0002\b\u0006=e\u0002BAE\u0003\u0017\u0003\"a]\u0016\n\u0007\u000555&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\u000b\u0019J\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b[\u0003bBAL#\u0001\u0007\u0011QQ\u0001\u0007_V$\b/\u001e;\u0002\u001fQ|G/\u00197Rk\u0016,X\rZ\"pI\u0016$\u0012!M\u0001\t]\u0016DHoQ8eKR\ta,A\u0004jgJ+\u0017\rZ=\u0002\u00135\f'o\u001b*fC\u0012LH#\u0001&\u0002\u00175\f'o[*vG\u000e,7o\u001d\u000b\u0006\u0015\u0006-\u0016Q\u0016\u0005\u0007\u0003\u00073\u0002\u0019\u00017\t\u000f\u0005]e\u00031\u0001\u0002RQ\u0019!*!-\t\r\u0005\ru\u00031\u0001m\u0003-i\u0017M]6GC&dWO]3\u0015\u000b)\u000b9,!/\t\r\u0005\r\u0005\u00041\u0001m\u0011\u001d\t9\n\u0007a\u0001\u0003#\"2ASA_\u0011\u0019\t\u0019)\u0007a\u0001Y\u0006)!/Z:fiR)!*a1\u0002H\"9\u0011Q\u0019\u000eA\u0002\u0005\u0015\u0015aB7fgN\fw-\u001a\u0005\t\u0003\u0013T\u0002\u0013!a\u0001\u000b\u0006\u0001R.\u0019:l\u00032d\u0017i\u001d$bS2,(/Z\u0001\u0010e\u0016\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u001a\u0016\u0004\u000b\u0006-\u0004")
public class BrokerState {
    private final int maxQueuedCode;
    private final Logger logger;
    private volatile boolean _isReady;
    private final Queue<BrokerCode> codeQueue;
    private final Map<String, BrokerPromise> promiseMap;
    private final Map<String, Option<OutputStream>> outputResultStreamMap;

    private int maxQueuedCode() {
        return this.maxQueuedCode;
    }

    private Logger logger() {
        return this.logger;
    }

    private boolean _isReady() {
        return this._isReady;
    }

    private void _isReady_$eq(boolean x$1) {
        this._isReady = x$1;
    }

    public Queue<BrokerCode> codeQueue() {
        return this.codeQueue;
    }

    public Map<String, BrokerPromise> promiseMap() {
        return this.promiseMap;
    }

    public Map<String, Option<OutputStream>> outputResultStreamMap() {
        return this.outputResultStreamMap;
    }

    public synchronized Future<String> pushCode(String code, Option<OutputStream> outputResultStream) {
        if (this.codeQueue().size() >= this.maxQueuedCode()) {
            throw new IllegalStateException(new StringBuilder(32).append("Code limit of ").append(this.maxQueuedCode()).append(" has been reached!").toString());
        }
        Promise codeExecutionPromise = Promise$.MODULE$.apply();
        String uniqueId = UUID.randomUUID().toString();
        BrokerCode brokerCode = new BrokerCode(uniqueId, code);
        BrokerPromise brokerPromise = new BrokerPromise(uniqueId, (Promise<String>)codeExecutionPromise);
        this.logger().debug(new StringBuilder(41).append("Queueing '").append(code).append("' with id '").append(uniqueId).append("' to run with broker").toString());
        this.codeQueue().add(brokerCode);
        this.promiseMap().put((Object)brokerPromise.codeId(), (Object)brokerPromise);
        this.outputResultStreamMap().put((Object)brokerPromise.codeId(), outputResultStream);
        return codeExecutionPromise.future();
    }

    public Option<OutputStream> pushCode$default$2() {
        return None$.MODULE$;
    }

    public void sendOutput(String codeId, String output) {
        Option option2 = (Option)this.outputResultStreamMap().get((Object)codeId).get();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            OutputStream outputStream = (OutputStream)some.value();
            outputStream.write(output.getBytes());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().debug(new StringBuilder(36).append("Output stream is invalid for codeId ").append(codeId).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public int totalQueuedCode() {
        return this.codeQueue().size();
    }

    /*
     * WARNING - void declaration
     */
    public BrokerCode nextCode() {
        void var1_1;
        block0: {
            BrokerCode brokerCode = this.codeQueue().poll();
            if (brokerCode == null) break block0;
            this.logger().trace(new StringBuilder(25).append("Sending ").append(brokerCode).append(" to Broker runner").toString());
        }
        return var1_1;
    }

    public boolean isReady() {
        return this._isReady();
    }

    public void markReady() {
        this._isReady_$eq(true);
    }

    public void markSuccess(String codeId, String output) {
        this.logger().debug(new StringBuilder(38).append("Received success for code with id '").append(codeId).append("': ").append(output).toString());
        this.promiseMap().remove((Object)codeId).foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.promise().success((Object)output));
    }

    public void markSuccess(String codeId) {
        this.markSuccess(codeId, "");
    }

    public void markFailure(String codeId, String output) {
        this.logger().debug(new StringBuilder(38).append("Received failure for code with id '").append(codeId).append("': ").append(output).toString());
        this.promiseMap().remove((Object)codeId).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.promise().failure((Throwable)new BrokerException(output)));
    }

    public void markFailure(String codeId) {
        this.markFailure(codeId, "");
    }

    public void reset(String message, boolean markAllAsFailure) {
        Queue<BrokerCode> queue = this.codeQueue();
        synchronized (queue) {
            Map<String, BrokerPromise> map2 = this.promiseMap();
            synchronized (map2) {
                this.codeQueue().clear();
                this.promiseMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    BrokerPromise codePromise = (BrokerPromise)tuple2._2();
                    Promise promise = markAllAsFailure ? codePromise.promise().failure((Throwable)new BrokerException(message)) : codePromise.promise().success((Object)message);
                    return promise;
                });
                this.promiseMap().clear();
            }
        }
    }

    public boolean reset$default$2() {
        return true;
    }

    public BrokerState(int maxQueuedCode) {
        this.maxQueuedCode = maxQueuedCode;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this._isReady = false;
        this.codeQueue = new ConcurrentLinkedQueue<BrokerCode>();
        this.promiseMap = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.outputResultStreamMap = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
    }
}

