/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.simplify.LineSegmentVisitor;
import com.vividsolutions.jts.simplify.TaggedLineSegment;
import com.vividsolutions.jts.simplify.TaggedLineString;
import java.util.ArrayList;
import java.util.List;

class LineSegmentIndex {
    private Quadtree index = new Quadtree();

    public void add(TaggedLineString line) {
        TaggedLineSegment[] segs = line.getSegments();
        int i = 0;
        while (i < segs.length) {
            TaggedLineSegment seg = segs[i];
            this.add(seg);
            ++i;
        }
    }

    public void add(LineSegment seg) {
        this.index.insert(new Envelope(seg.p0, seg.p1), seg);
    }

    public void remove(LineSegment seg) {
        this.index.remove(new Envelope(seg.p0, seg.p1), seg);
    }

    public List query(LineSegment querySeg) {
        Envelope env = new Envelope(querySeg.p0, querySeg.p1);
        LineSegmentVisitor visitor = new LineSegmentVisitor(querySeg);
        this.index.query(env, visitor);
        ArrayList itemsFound = visitor.getItems();
        return itemsFound;
    }
}

