/* globals require module */
const stylelint = require("stylelint");

const { report, ruleMessages, validateOptions } = stylelint.utils;
const ruleName = "dku/only-reference-imports";
const messages = ruleMessages(ruleName, {
    noRefImport: (filename) =>
        `[Dataiku] Unexpected @import ${filename} used without (reference). Make sure a real import is required, if so mark line as ignoring this rule.`,
});

function rule(actual) {
    return (root, result) => {
        const validOptions = validateOptions(result, ruleName, { actual });
        if (!validOptions) {
            return;
        }

        root.walkAtRules(/^import$/i, (atRule) => {
            if(atRule.options !== '(reference)') {
                report({
                    message: messages.noRefImport(atRule.filename),
                    node: atRule,
                    result,
                    ruleName
                });
                return;
            }
        });
    };
}

rule.primaryOptionArray = true;

module.exports = stylelint.createPlugin(ruleName, rule);
module.exports.ruleName = ruleName;
module.exports.messages = messages;
