from typing import Any, TYPE_CHECKING, Union

from dataiku.llm.python.types import DSSLLMEmbeddingsResponse, SimpleEmbeddingResponse

if TYPE_CHECKING:
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_prompt_command.process_single_prompt_command import ProcessSinglePromptCommand
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_embedding_command.process_single_embedding_command import ProcessSingleEmbeddingCommand
    from generated_sources.com.dataiku.dip.llm.online.llm_client.embedding_settings import EmbeddingSettings
else:
    EmbeddingSettings = Any
    ProcessSingleEmbeddingCommand = Any
    ProcessSinglePromptCommand = Any

EmbeddingResponse = Union[str, DSSLLMEmbeddingsResponse, SimpleEmbeddingResponse]