<#import "/common/boilerplate.ftl" as boilerplate>
<#import "/common/artifact_utils.ftl" as artifact_utils>
<#import "/common/user_utils.ftl" as user_utils>
<#import "/signoffs/components/signoff_feedback.ftl" as signoff_feedback>
<@boilerplate.subject>
    <@user_utils.display userWhoDidAction /> has requested your approval
    <#if artifact.name??>
        for "${signoff.title?truncate(80)}" on item "${artifact.name?truncate(80)}"
    <#else>
        on an item you don't have access to
    </#if>
</@boilerplate.subject>
<@boilerplate.mail>
    <p>Hello ${notificationRecipient.displayName?truncate(80)},</p>
    <#if artifact.name??> <#-- If has read permissions -->
        <p>
            <@user_utils.display userWhoDidAction /> has requested your approval for the sign-off "${signoff.title?truncate(80)}" on the item "${artifact.name?truncate(80)}".
        </p>
        <#include "/signoffs/components/signoff_link.ftl">
        <@signoff_feedback.display_all signoff.feedbackResponses />
        <#include "/signoffs/components/more_info.ftl">
    <#else> <#-- If no permissions -->
        <p><@user_utils.display userWhoDidAction /> has requested your approval for a sign-off on item <@artifact_utils.link artifact>${artifact.id}</@artifact_utils.link>.</p>
        <p>You do not have access to this item. Please contact an administrator to get access.</p>
    </#if>
</@boilerplate.mail>
