CREATE TABLE time_series_heads (
    time_series_head_id TEXT PRIMARY KEY GENERATED ALWAYS AS ((time_series_head_json ->> 'id')::TEXT) STORED,
    time_series_head_json JSONB NOT NULL
);

INSERT INTO time_series_heads (time_series_head_json)
SELECT ('{"id": "ts.' || ts_idx || '"}')::JSONB AS time_series_head_json
FROM GENERATE_SERIES(1, (SELECT CASE WHEN is_called IS FALSE THEN 0 ELSE last_value END FROM time_series_seq)) AS ts_idx;
-- we do case when is_called on sequence, because last_value is always 1 for both uncalled sequence and sequence called only once

CREATE TABLE time_series_heads_history (
    time_series_head_id TEXT GENERATED ALWAYS AS ((time_series_head_json ->> 'id')::TEXT) STORED NOT NULL,
    time_series_head_json JSONB NOT NULL
) INHERITS (_history_revisions);
CREATE INDEX time_series_heads_history_ts_id_index ON time_series_heads_history (time_series_head_id);

INSERT INTO time_series_heads_history (time_series_head_json, _revision_json)
SELECT
    ('{"id": "ts.' || ts_idx || '"}')::JSONB AS time_series_head_json,
    (revisions._revision_json || ('{"operation": "ADD", "entityType": "TIME_SERIES_HEAD"}')::JSONB)::JSONB AS _revision_json -- we share the same revision ID
FROM GENERATE_SERIES(1, (SELECT CASE WHEN is_called IS FALSE THEN 0 ELSE last_value END FROM time_series_seq)) AS ts_idx
-- inner join ensures that we only create the revision for the time series head if we find the coresponding revision for the time series itself
INNER JOIN LATERAL (
    SELECT _revision_json
    FROM time_series_history
    WHERE time_series_id = ('ts.' || ts_idx)::TEXT
    ORDER BY
        _revision_timestamp ASC,
        _revision_id ASC
    LIMIT 1
) AS revisions ON TRUE;

ALTER TABLE time_series ADD CONSTRAINT time_series__time_series_id_fkey FOREIGN KEY (time_series_id) REFERENCES time_series_heads(time_series_head_id) DEFERRABLE;

CREATE INDEX time_series_heads_owner_index ON time_series_heads ((time_series_head_json #>> '{owner}'));
CREATE INDEX uploaded_files_owner_index ON uploaded_files ((uploaded_file_json #>> '{owner}'));
