from dataiku.llm.python.custom.base_model import BaseModel
from dataiku.llm.python.processing import _NotImplementedError
from dataiku.llm.python.types import ImageGenerationQuery, PluginImageGenerationResponse
from dataiku.llm.tracing import SpanBuilder

class BaseImageGenerationModel(BaseModel):
    """The base interface for an image generation model"""

    def process(self, query: ImageGenerationQuery, trace: SpanBuilder) -> PluginImageGenerationResponse:
        raise _NotImplementedError

    async def aprocess(self, query: ImageGenerationQuery, trace: SpanBuilder) -> PluginImageGenerationResponse:
        raise _NotImplementedError