/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommand;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.core.services.admin.IMigrationService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.postgresql.util.PSQLException;

public class CheckDBVersionCommand
extends CLICommand {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.govern-check-db-version");
    public static final String COMMAND_NAME = "__check-db-version";

    @Override
    public String usageString() {
        return "__check-db-version EXPECTEDVERSION";
    }

    @Override
    public String description() {
        return "Check that the database is in the correct version";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        options.addOption("wait", true, "If needed, wait X seconds for the DB to be up");
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, COMMAND_NAME, true);
        if (cmdLine.getArgs().length < 2) {
            return this.usage(1, "Missing EXPECTEDVERSION argument");
        }
        long expectedVersion = Long.parseLong(cmdLine.getArgs()[1]);
        String waitStr = cmdLine.getOptionValue("wait", "0");
        int wait = 0;
        try {
            wait = Integer.parseInt(waitStr);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to parse wait parameter", (Throwable)e);
        }
        GHSpring.doCLISetupWithDB();
        IMigrationService migrationService = (IMigrationService)SpringUtils.getBean(IMigrationService.class);
        try {
            migrationService.checkCurrentSchemaVersion(expectedVersion);
        }
        catch (Exception e) {
            if (wait > 0 && ExceptionUtils.hasCauseOfClass((Throwable)e, PSQLException.class)) {
                logger.warn((Object)("Failed to get the version, DB may not be up yet, retry for " + wait + " seconds. Error: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                int interval = 10;
                for (int waited = 0; waited < wait; waited += interval) {
                    int waitThisRound = Math.min(interval, wait - waited);
                    try {
                        Thread.sleep((long)waitThisRound * 1000L);
                        migrationService.checkCurrentSchemaVersion(expectedVersion);
                        return 0;
                    }
                    catch (Exception e2) {
                        logger.warn((Object)("Waited " + waitThisRound + " seconds, but still failing. Error: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                        continue;
                    }
                }
            }
            throw e;
        }
        return 0;
    }
}

