/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.roles.Role;
import com.dataiku.gh.core.services.roles_and_permissions.roles.IAdminRolesService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AdminRolesController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAdminRolesService adminRolesService;

    @AuditedCall(value={"msgType", "admin-roles-list"})
    @RequestMapping(value={"/api/admin/roles/list"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        AdminRolesController.writeJSON((HttpServletResponse)resp, this.adminRolesService.listRoles(authCtx));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/roles/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ROLE_CREATE)
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam Role role, @RequestParam String newIdentifier) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            Role createdRole = this.adminRolesService.createRole(authCtx, role, newIdentifier);
            this.auditTrailService.generic("admin-role-create").with("roleId", createdRole.id).emit();
            AdminRolesController.writeJSON((HttpServletResponse)resp, (Object)createdRole);
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-role-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/roles/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.ROLE_SAVE)
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam Role role) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            Role savedRole = this.adminRolesService.saveRole(authCtx, role);
            this.auditTrailService.generic("admin-role-save").with("roleId", savedRole.id).emit();
            AdminRolesController.writeJSON((HttpServletResponse)resp, (Object)savedRole);
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-role-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-role-delete", "roleId", "${roleId}"})
    @RequestMapping(value={"/api/admin/roles/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.ROLE_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String roleId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.adminRolesService.deleteRole(authCtx, roleId);
        AdminRolesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

