/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.notifications.signoff;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.notifications.NotificationContext;
import com.dataiku.gh.core.models.notifications.TemplateContext;
import com.dataiku.gh.core.models.notifications.common.ArtifactTemplateContext;
import com.dataiku.gh.core.models.notifications.common.SignoffTemplateContext;
import com.dataiku.gh.core.models.notifications.common.UserTemplateContext;
import com.dataiku.gh.core.models.notifications.signoff.SignoffGroupData;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.google.common.collect.Lists;
import freemarker.template.SimpleHash;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SignoffNotificationContext
extends NotificationContext {
    protected final EnrichedArtifact enrichedArtifact;
    protected final UserTemplateContext userWhoDidActionTemplateContext;
    protected final ArtifactTemplateContext artifactTemplateContext;
    protected final SignoffTemplateContext signoffTemplateContext;

    SignoffNotificationContext(EnrichedArtifact enrichedArtifact, Signoff signoff, SignoffGroupData groupData, String userWhoDidActionLogin) {
        this.enrichedArtifact = enrichedArtifact;
        this.artifactTemplateContext = new ArtifactTemplateContext(enrichedArtifact);
        this.signoffTemplateContext = new SignoffTemplateContext(enrichedArtifact, signoff, groupData);
        this.userWhoDidActionTemplateContext = new UserTemplateContext(userWhoDidActionLogin);
    }

    @Override
    protected String getEmailTemplateFolder() {
        return "signoffs/";
    }

    @Override
    public List<TemplateContext> getChildren() {
        ArrayList list = Lists.newArrayList((Object[])new TemplateContext[]{this.userWhoDidActionTemplateContext, this.artifactTemplateContext, this.signoffTemplateContext});
        list.addAll(super.getChildren());
        return list;
    }

    @Override
    public List<ArtifactTemplateContext> getArtifactContextsToEnrichWithBreadcrumb() {
        return Collections.singletonList(this.artifactTemplateContext);
    }

    @Override
    public SimpleHash buildTemplateModel() {
        SimpleHash model = super.buildTemplateModel();
        model.put("userWhoDidAction", (Object)this.userWhoDidActionTemplateContext.buildTemplateModel());
        model.put("artifact", (Object)this.artifactTemplateContext.buildTemplateModel());
        model.put("signoff", (Object)this.signoffTemplateContext.buildTemplateModel());
        return model;
    }

    @Override
    public boolean userShouldReceiveNotification() {
        return this.artifactTemplateContext.userCanSeeContext();
    }
}

