/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.actions;

import com.dataiku.gh.core.models.actions.InstanceAction;
import com.dataiku.gh.core.services.actions.IInstanceActionsDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.instance_actions.IInstanceActionDAO;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class InstanceActionsDataService
implements IInstanceActionsDataService {
    @Autowired
    private IInstanceActionDAO instanceActionDAO;

    @Override
    @GHMandatoryTransaction
    @Nullable
    public InstanceAction getInstanceActionOrNull(String instanceActionId) throws IOException {
        return (InstanceAction)this.instanceActionDAO.getOrNull(instanceActionId);
    }

    @Override
    @GHMandatoryTransaction
    public List<InstanceAction> getInstanceActions() throws IOException {
        return this.instanceActionDAO.list();
    }

    @Override
    @GHMandatoryTransaction
    public List<String> getInstanceActionsIds() throws IOException {
        return this.instanceActionDAO.listIds();
    }

    @Override
    @GHMandatoryTransaction
    public InstanceAction createInstanceAction(InstanceAction instanceAction) throws IOException {
        this.instanceActionDAO.lock(instanceAction.id);
        if (this.instanceActionDAO.exists(instanceAction.id)) {
            throw new ValidationException("Action with id `" + instanceAction.id + "` already exists");
        }
        this.instanceActionDAO.create(instanceAction);
        return (InstanceAction)this.instanceActionDAO.getMandatory(instanceAction.id);
    }

    @Override
    @GHMandatoryTransaction
    public InstanceAction saveInstanceAction(InstanceAction instanceAction) throws IOException {
        this.instanceActionDAO.lock(instanceAction.id);
        if (!this.instanceActionDAO.exists(instanceAction.id)) {
            throw new ValidationException("Action with id `" + instanceAction.id + "` does not exist");
        }
        this.instanceActionDAO.save(instanceAction);
        return (InstanceAction)this.instanceActionDAO.getMandatory(instanceAction.id);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteInstanceAction(String instanceActionId) throws IOException {
        this.instanceActionDAO.lock(instanceActionId);
        this.instanceActionDAO.delete(instanceActionId);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteInstanceActionIfExists(String instanceActionId) throws IOException {
        this.instanceActionDAO.lock(instanceActionId);
        if (this.instanceActionDAO.exists(instanceActionId)) {
            this.instanceActionDAO.delete(instanceActionId);
        }
    }
}

