/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV13300AndBeyond;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV14300
extends Migration {
    private Long actionId;

    private Long getMigrationActionId(IDBMigrationDAO dbMigrationDAO, long migrationTS) throws IOException {
        if (this.actionId == null) {
            this.actionId = MigrationEntitiesUtilsBetweenV13300AndBeyond.createMigrationAction(dbMigrationDAO.getJdbcTemplate(), migrationTS);
        }
        return this.actionId;
    }

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        long migrationTS = this.getMigrationTimestamp();
        long actionId = this.getMigrationActionId(dbMigrationDAO, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"global_api_key", "blueprint_version_default.json"}), "bp.system.global_api_key", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"group", "blueprint_version_default.json"}), "bp.system.group", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_project", "blueprint_version_default.json"}), "bp.system.govern_project", "bv.system.default", actionId, migrationTS);
        this.migrateBlueprintVersions(dbMigrationDAO);
    }

    private void migrateBlueprintVersions(IDBMigrationDAO dbMigrationDAO) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.migrateObjectsStructure(dbMigrationDAO.getJdbcTemplate(), "blueprint_versions", "blueprint_version_blueprint_id=? AND blueprint_version_version_id=?", "blueprint_version_json", null, null, bpv -> Arrays.asList(MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(null), MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(null)), MigrationV14300::migrateBlueprintVersion);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.migrateObjectsStructureHistoryAtTimestamp(dbMigrationDAO.getJdbcTemplate(), "blueprint_versions_history", "blueprint_version_json", null, this::migrateBlueprintVersionHistory);
    }

    public static JsonObject migrateBlueprintVersion(JsonObject blueprintVersion) {
        JsonObject views = MigrationJsonUtils.getObjectSubpath((JsonElement)blueprintVersion, "uiDefinition", "views").orElse(null);
        if (views == null) {
            return blueprintVersion;
        }
        JsonObject newViews = new JsonObject();
        views.entrySet().forEach(entry -> {
            if (entry.getValue() != null && ((JsonElement)entry.getValue()).isJsonObject()) {
                newViews.add((String)entry.getKey(), (JsonElement)MigrationV14300.migrateView(((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        });
        blueprintVersion.getAsJsonObject("uiDefinition").add("views", (JsonElement)newViews);
        return blueprintVersion;
    }

    private JsonObject migrateBlueprintVersionHistory(MigrationEntitiesUtilsBetweenV13300AndBeyond.JSONObjectAtTimestamp blueprintVersionAtTimestamp) {
        JsonObject blueprintVersion = blueprintVersionAtTimestamp.jsonObject;
        return MigrationV14300.migrateBlueprintVersion(blueprintVersion);
    }

    private static JsonObject migrateView(JsonObject view) {
        JsonObject viewComponent = MigrationJsonUtils.getObjectSubpath((JsonElement)view, "viewComponent").orElse(null);
        if (viewComponent == null) {
            return view;
        }
        MigrationV14300.migrateViewComponent(viewComponent);
        return view;
    }

    private static void migrateViewComponent(JsonObject viewComponent) {
        if (MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "type").orElse("").equals("container")) {
            JsonArray viewComponents = MigrationJsonUtils.getArraySubpath((JsonElement)viewComponent, "layout", "viewComponents").orElse(null);
            if (viewComponents == null) {
                return;
            }
            for (JsonElement component : viewComponents) {
                if (!component.isJsonObject()) continue;
                MigrationV14300.migrateViewComponent(component.getAsJsonObject());
            }
        }
        if (MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "type").orElse("").equals("action")) {
            viewComponent.addProperty("type", "plugin-action");
        }
    }
}

