/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts;

import com.dataiku.gh.core.models.history.artifact.ArtifactAndHistoryActionEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public class ArtifactAndHistoryActionGroupingByActionId {
    private final Spliterator<ArtifactAndHistoryActionEntry> inputSpliterator;
    private final int maxEntriesPerAction;
    @Nullable
    private final Predicate<ArtifactAndHistoryActionEntry> prefilterPredicate;

    private ArtifactAndHistoryActionGroupingByActionId(Stream<ArtifactAndHistoryActionEntry> inputStream, int maxEntriesPerAction, @Nullable Predicate<ArtifactAndHistoryActionEntry> prefilterPredicate) {
        this.inputSpliterator = inputStream.spliterator();
        this.maxEntriesPerAction = Math.max(maxEntriesPerAction, 1);
        this.prefilterPredicate = prefilterPredicate;
    }

    public static Stream<ArtifactPartialHistoryActionGroupedByAction> groupedByActionIdAndCappedToMaxEntriesPerAction(Stream<ArtifactAndHistoryActionEntry> inputStream, int maxEntriesPerAction) {
        return new ArtifactAndHistoryActionGroupingByActionId(inputStream, maxEntriesPerAction, null).stream();
    }

    public static Stream<ArtifactPartialHistoryActionGroupedByAction> groupedByActionIdAndCappedToMaxEntriesPerAction(Stream<ArtifactAndHistoryActionEntry> inputStream, int maxEntriesPerAction, Predicate<ArtifactAndHistoryActionEntry> prefilterPredicate) {
        return new ArtifactAndHistoryActionGroupingByActionId(inputStream, maxEntriesPerAction, prefilterPredicate).stream();
    }

    private Stream<ArtifactPartialHistoryActionGroupedByAction> stream() {
        return StreamSupport.stream(new Spliterator<ArtifactPartialHistoryActionGroupedByAction>(){
            ArtifactPartialHistoryActionGroupedByAction entryToEmit;
            ArtifactPartialHistoryActionGroupedByAction current;
            int currentEstimatedNbEntriesPerAction = 0;
            long lastEmittedActionId = -1L;

            @Override
            public boolean tryAdvance(Consumer<? super ArtifactPartialHistoryActionGroupedByAction> groupedByActionConsumer) {
                boolean inputSpliteratorHasValue;
                while ((inputSpliteratorHasValue = ArtifactAndHistoryActionGroupingByActionId.this.inputSpliterator.tryAdvance((? super T actionEntry) -> {
                    if (this.lastEmittedActionId == actionEntry.actionId) {
                        return;
                    }
                    if (ArtifactAndHistoryActionGroupingByActionId.this.prefilterPredicate != null && !ArtifactAndHistoryActionGroupingByActionId.this.prefilterPredicate.test((ArtifactAndHistoryActionEntry)actionEntry)) {
                        return;
                    }
                    if (this.current == null || this.current.actionId != actionEntry.actionId) {
                        this.entryToEmit = this.current;
                        this.current = new ArtifactPartialHistoryActionGroupedByAction(actionEntry.actionId);
                        this.currentEstimatedNbEntriesPerAction = 0;
                    }
                    if (this.currentEstimatedNbEntriesPerAction < ArtifactAndHistoryActionGroupingByActionId.this.maxEntriesPerAction) {
                        this.current.actionEntries.add((ArtifactAndHistoryActionEntry)actionEntry);
                        if (!actionEntry.isForeignRevisionsOnly) {
                            ++this.currentEstimatedNbEntriesPerAction;
                        }
                    }
                    if (this.currentEstimatedNbEntriesPerAction >= ArtifactAndHistoryActionGroupingByActionId.this.maxEntriesPerAction) {
                        this.entryToEmit = this.current;
                        this.current = null;
                    }
                })) && this.entryToEmit == null) {
                }
                if (this.entryToEmit != null) {
                    groupedByActionConsumer.accept(this.entryToEmit);
                    this.lastEmittedActionId = this.entryToEmit.actionId;
                    this.entryToEmit = null;
                } else if (!inputSpliteratorHasValue && this.current != null) {
                    groupedByActionConsumer.accept(this.current);
                    this.lastEmittedActionId = this.current.actionId;
                    this.current = null;
                    this.currentEstimatedNbEntriesPerAction = 0;
                }
                return inputSpliteratorHasValue;
            }

            @Override
            public Spliterator<ArtifactPartialHistoryActionGroupedByAction> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Integer.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 17;
            }
        }, false);
    }

    public static class ArtifactPartialHistoryActionGroupedByAction {
        public final long actionId;
        public final List<ArtifactAndHistoryActionEntry> actionEntries = new ArrayList<ArtifactAndHistoryActionEntry>();

        public ArtifactPartialHistoryActionGroupedByAction(long actionId) {
            this.actionId = actionId;
        }

        public ArtifactPartialHistoryActionGroupedByAction(long actionId, ArtifactAndHistoryActionEntry ... actionEntries) {
            this.actionId = actionId;
            this.actionEntries.addAll(Arrays.asList(actionEntries));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactPartialHistoryActionGroupedByAction that = (ArtifactPartialHistoryActionGroupedByAction)o;
            return this.actionId == that.actionId && Objects.equals(this.actionEntries, that.actionEntries);
        }

        public int hashCode() {
            return Objects.hash(this.actionId, this.actionEntries);
        }
    }
}

