/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.dss.sync;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.dss.AbstractDSSDeployerArtifactsContainer;
import com.dataiku.gh.core.models.dss.AbstractDSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSDeployerArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSProjectIdentifierWithId;
import com.dataiku.gh.core.models.dss.DSSSolvedDiffArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSSolvedDiffDeployerArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSSolvedDiffProjectArtifactsContainer;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.services.dss.sync.IDSSArtifactsDiffSolverService;
import com.dataiku.gh.core.services.system.ISystemProvidedBlueprintVersionsCacheService;
import com.dataiku.gh.core.utils.FunctionUtils;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSArtifactsDiffSolverService
implements IDSSArtifactsDiffSolverService {
    @Autowired
    private ISystemProvidedBlueprintVersionsCacheService systemProvidedCacheService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.dss-artifacts-diff-solver");

    @Override
    public DiffResult<DSSSolvedDiffProjectArtifactsContainer> diffOldAndNewProjectItemsArtifacts(DSSProjectArtifactsContainer existingArtifacts, DSSProjectArtifactsContainer newArtifacts) throws IOException {
        try {
            ProjectDiffWorkingContainer workingContainer = new ProjectDiffWorkingContainer();
            workingContainer.project = Pair.of((Object)((DSSArtifactContainer.DSSProjectArtifactContainer)existingArtifacts.getDSSProject()), (Object)((DSSArtifactContainer.DSSProjectArtifactContainer)newArtifacts.getDSSProject()));
            this.addArtifactsToReconciliationMap(ArtifactStatus.EXISTING, existingArtifacts.getDSSBundles(), workingContainer.bundles);
            this.addArtifactsToReconciliationMap(ArtifactStatus.NEW, newArtifacts.getDSSBundles(), workingContainer.bundles);
            this.addArtifactsToReconciliationMap(ArtifactStatus.EXISTING, existingArtifacts.getDSSDatasets(), workingContainer.datasets);
            this.addArtifactsToReconciliationMap(ArtifactStatus.NEW, newArtifacts.getDSSDatasets(), workingContainer.datasets);
            this.addArtifactsToReconciliationMap(ArtifactStatus.EXISTING, existingArtifacts.getDSSSavedModels(), workingContainer.savedModel);
            this.addArtifactsToReconciliationMap(ArtifactStatus.NEW, newArtifacts.getDSSSavedModels(), workingContainer.savedModel);
            this.addArtifactsToReconciliationMap(ArtifactStatus.EXISTING, existingArtifacts.getDSSRetrievableKnowledges(), workingContainer.retrievableKnowledges);
            this.addArtifactsToReconciliationMap(ArtifactStatus.NEW, newArtifacts.getDSSRetrievableKnowledges(), workingContainer.retrievableKnowledges);
            this.addArtifactsToReconciliationMap(ArtifactStatus.EXISTING, existingArtifacts.getDSSSavedModelVersions(), workingContainer.savedModelVersion);
            this.addArtifactsToReconciliationMap(ArtifactStatus.NEW, newArtifacts.getDSSSavedModelVersions(), workingContainer.savedModelVersion);
            DiffResult<DSSSolvedDiffProjectArtifactsContainer> result = DiffResult.buildForProject();
            this.dispatchPairToCreateUpdateOrDelete_UncheckedIOException(workingContainer.project, a -> ((DSSSolvedDiffProjectArtifactsContainer)result.artifactsToCreate).setProject(a), a -> ((DSSSolvedDiffProjectArtifactsContainer)result.artifactsToUpdate).setProject(a), FunctionUtils::noopConsumer, a -> ((DSSSolvedDiffProjectArtifactsContainer)result.artifactsUpToDate).setProject(a));
            this.addArtifactsToDiffResult_UncheckedIOException(workingContainer.bundles, result, AbstractDSSProjectArtifactsContainer::getDSSBundles);
            this.addArtifactsToDiffResult_UncheckedIOException(workingContainer.datasets, result, AbstractDSSProjectArtifactsContainer::getDSSDatasets);
            this.addArtifactsToDiffResult_UncheckedIOException(workingContainer.savedModel, result, AbstractDSSProjectArtifactsContainer::getDSSSavedModels);
            this.addArtifactsToDiffResult_UncheckedIOException(workingContainer.retrievableKnowledges, result, AbstractDSSProjectArtifactsContainer::getDSSRetrievableKnowledges);
            this.addArtifactsToDiffResult_UncheckedIOException(workingContainer.savedModelVersion, result, AbstractDSSProjectArtifactsContainer::getDSSSavedModelVersions);
            return result;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    @Override
    public DiffResult<DSSSolvedDiffDeployerArtifactsContainer> diffOldAndNewDeployerArtifacts(DSSDeployerArtifactsContainer existingArtifacts, DSSDeployerArtifactsContainer newArtifacts) throws IOException {
        try {
            DeployerDiffWorkingContainer workingContainer = new DeployerDiffWorkingContainer();
            this.addArtifactsToReconciliationMap(ArtifactStatus.EXISTING, existingArtifacts.getAPIInfras(), workingContainer.apiInfras);
            this.addArtifactsToReconciliationMap(ArtifactStatus.NEW, newArtifacts.getAPIInfras(), workingContainer.apiInfras);
            this.addArtifactsToReconciliationMap(ArtifactStatus.EXISTING, existingArtifacts.getProjectInfras(), workingContainer.projectInfras);
            this.addArtifactsToReconciliationMap(ArtifactStatus.NEW, newArtifacts.getProjectInfras(), workingContainer.projectInfras);
            this.addArtifactsToReconciliationMap(ArtifactStatus.EXISTING, existingArtifacts.getAPIDeployments(), workingContainer.apiDeployments);
            this.addArtifactsToReconciliationMap(ArtifactStatus.NEW, newArtifacts.getAPIDeployments(), workingContainer.apiDeployments);
            this.addArtifactsToReconciliationMap(ArtifactStatus.EXISTING, existingArtifacts.getProjectDeployments(), workingContainer.projectDeployments);
            this.addArtifactsToReconciliationMap(ArtifactStatus.NEW, newArtifacts.getProjectDeployments(), workingContainer.projectDeployments);
            DiffResult<DSSSolvedDiffDeployerArtifactsContainer> result = DiffResult.buildForDeployer();
            this.addArtifactsToDeployerDiffResult_UncheckedIOException(workingContainer.apiInfras, result, AbstractDSSDeployerArtifactsContainer::getAPIInfras);
            this.addArtifactsToDeployerDiffResult_UncheckedIOException(workingContainer.projectInfras, result, AbstractDSSDeployerArtifactsContainer::getProjectInfras);
            this.addArtifactsToDeployerDiffResult_UncheckedIOException(workingContainer.apiDeployments, result, AbstractDSSDeployerArtifactsContainer::getAPIDeployments);
            this.addArtifactsToDeployerDiffResult_UncheckedIOException(workingContainer.projectDeployments, result, AbstractDSSDeployerArtifactsContainer::getProjectDeployments);
            return result;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    private <T extends DSSArtifactContainer<T>> void addArtifactsToReconciliationMap(ArtifactStatus artifactStatus, Map<String, T> artifactContainers, Map<String, MutablePair<T, T>> mapOfOldAndNew) {
        artifactContainers.values().forEach(artifactContainer -> {
            String id = artifactContainer.getIdentifier();
            mapOfOldAndNew.compute(id, (key, value) -> {
                MutablePair p = (MutablePair)ObjectUtils.defaultIfNull((Object)value, (Object)new MutablePair());
                if (artifactStatus == ArtifactStatus.EXISTING) {
                    p.setLeft(artifactContainer);
                } else {
                    p.setRight(artifactContainer);
                }
                return p;
            });
        });
    }

    private <T extends DSSArtifactContainer<T>> void addArtifactsToDiffResult_UncheckedIOException(Map<String, MutablePair<T, T>> mapOfOldAndNew, DiffResult<DSSSolvedDiffProjectArtifactsContainer> result, Function<DSSSolvedDiffProjectArtifactsContainer, Map<String, DSSSolvedDiffArtifactContainer<T>>> getTargetMap) {
        mapOfOldAndNew.forEach((id, pair) -> this.dispatchPairToCreateUpdateOrDelete_UncheckedIOException((Pair)pair, a -> ((Map)getTargetMap.apply((DSSSolvedDiffProjectArtifactsContainer)result.artifactsToCreate)).put(a.getIdentifier(), a), a -> ((Map)getTargetMap.apply((DSSSolvedDiffProjectArtifactsContainer)result.artifactsToUpdate)).put(a.getIdentifier(), a), a -> ((Map)getTargetMap.apply((DSSSolvedDiffProjectArtifactsContainer)result.artifactsToDelete)).put(a.getIdentifier(), a), a -> ((Map)getTargetMap.apply((DSSSolvedDiffProjectArtifactsContainer)result.artifactsUpToDate)).put(a.getIdentifier(), a)));
    }

    private <T extends DSSArtifactContainer<T>> void addArtifactsToDeployerDiffResult_UncheckedIOException(Map<String, MutablePair<T, T>> mapOfOldAndNew, DiffResult<DSSSolvedDiffDeployerArtifactsContainer> result, Function<DSSSolvedDiffDeployerArtifactsContainer, Map<String, DSSSolvedDiffArtifactContainer<T>>> getTargetMap) {
        mapOfOldAndNew.forEach((id, pair) -> this.dispatchPairToCreateUpdateOrDelete_UncheckedIOException((Pair)pair, a -> ((Map)getTargetMap.apply((DSSSolvedDiffDeployerArtifactsContainer)result.artifactsToCreate)).put(a.getIdentifier(), a), a -> ((Map)getTargetMap.apply((DSSSolvedDiffDeployerArtifactsContainer)result.artifactsToUpdate)).put(a.getIdentifier(), a), a -> ((Map)getTargetMap.apply((DSSSolvedDiffDeployerArtifactsContainer)result.artifactsToDelete)).put(a.getIdentifier(), a), a -> ((Map)getTargetMap.apply((DSSSolvedDiffDeployerArtifactsContainer)result.artifactsUpToDate)).put(a.getIdentifier(), a)));
    }

    private <T extends DSSArtifactContainer<T>> void dispatchPairToCreateUpdateOrDelete_UncheckedIOException(Pair<T, T> oldNew, Consumer<DSSSolvedDiffArtifactContainer<T>> addToCreate, Consumer<DSSSolvedDiffArtifactContainer<T>> addToUpdate, Consumer<DSSSolvedDiffArtifactContainer<T>> addToDelete, Consumer<DSSSolvedDiffArtifactContainer<T>> addToUpToDate) {
        boolean wasExistingAndArchived;
        DSSArtifactContainer oldArtifactContainer = (DSSArtifactContainer)oldNew.getLeft();
        DSSArtifactContainer newArtifactContainer = (DSSArtifactContainer)oldNew.getRight();
        boolean bl = wasExistingAndArchived = oldArtifactContainer != null && oldArtifactContainer.artifact.status.archived;
        if (newArtifactContainer == null) {
            addToDelete.accept(DSSSolvedDiffArtifactContainer.build(oldArtifactContainer, wasExistingAndArchived));
        } else if (oldArtifactContainer == null) {
            addToCreate.accept(DSSSolvedDiffArtifactContainer.build(newArtifactContainer, wasExistingAndArchived));
        } else {
            Artifact artifactToSave = (Artifact)JSON.deepCopy((Object)oldArtifactContainer.artifact);
            boolean modified = this.fillNewInternalFieldValues_UncheckedIOException(artifactToSave, newArtifactContainer);
            Object toSaveArtifactContainer = newArtifactContainer.cloneWith(artifactToSave);
            if (modified) {
                addToUpdate.accept(DSSSolvedDiffArtifactContainer.build(toSaveArtifactContainer, wasExistingAndArchived));
            } else {
                addToUpToDate.accept(DSSSolvedDiffArtifactContainer.build(toSaveArtifactContainer, wasExistingAndArchived));
            }
        }
    }

    private <T extends DSSArtifactContainer<T>> boolean fillNewInternalFieldValues_UncheckedIOException(Artifact artifactToSave, T newArtifactContainer) {
        EnrichedBlueprintVersion newEnrichedBlueprintVersion;
        EnrichedBlueprintVersion existingEnrichedBlueprintVersion;
        boolean wasArchived = artifactToSave.status.archived;
        boolean modified = false;
        try {
            existingEnrichedBlueprintVersion = this.systemProvidedCacheService.getSystemEnrichedDefaultBlueprintVersion(artifactToSave.blueprintVersionId);
            if (existingEnrichedBlueprintVersion == null || existingEnrichedBlueprintVersion.blueprintVersion == null) {
                throw new IOException("Cannot find system blueprint version definition for blueprint version: " + String.valueOf(artifactToSave.blueprintVersionId));
            }
            newEnrichedBlueprintVersion = this.systemProvidedCacheService.getSystemEnrichedDefaultBlueprintVersion(newArtifactContainer.artifact.blueprintVersionId);
            if (newEnrichedBlueprintVersion == null || newEnrichedBlueprintVersion.blueprintVersion == null) {
                throw new IOException("Cannot find system blueprint version definition for blueprint version: " + String.valueOf(newArtifactContainer.artifact));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!Objects.equals(artifactToSave.blueprintVersionId, newArtifactContainer.artifact.blueprintVersionId)) {
            modified = true;
            artifactToSave.blueprintVersionId = newArtifactContainer.artifact.blueprintVersionId;
        }
        if (!Objects.equals(artifactToSave.status, newArtifactContainer.artifact.status)) {
            modified = true;
            artifactToSave.status = (com.dataiku.gh.core.models.artifacts.ArtifactStatus)JSON.deepCopy((Object)newArtifactContainer.artifact.status);
        }
        if (!Objects.equals(artifactToSave.name, newArtifactContainer.artifact.name)) {
            modified = true;
            artifactToSave.name = newArtifactContainer.artifact.name;
        }
        Sets.SetView allFieldsIds = Sets.union(existingEnrichedBlueprintVersion.blueprintVersion.fieldDefinitions.keySet(), newEnrichedBlueprintVersion.blueprintVersion.fieldDefinitions.keySet());
        for (String fieldId : allFieldsIds) {
            FieldDefinition existingFieldDefinition = existingEnrichedBlueprintVersion.blueprintVersion.fieldDefinitions.get(fieldId);
            FieldDefinition newFieldDefinition = newEnrichedBlueprintVersion.blueprintVersion.fieldDefinitions.get(fieldId);
            if (existingFieldDefinition != null && newFieldDefinition == null) {
                modified |= artifactToSave.fields.remove(fieldId) != null;
                continue;
            }
            if (this.isDataFieldFromSync(fieldId, newFieldDefinition)) {
                modified |= this.updateField(fieldId, artifactToSave, newArtifactContainer.artifact);
                continue;
            }
            if (this.isDataFieldNotFromSync(fieldId, newFieldDefinition)) {
                if (!wasArchived) continue;
                modified |= artifactToSave.fields.remove(fieldId) != null;
                continue;
            }
            if (existingFieldDefinition == null || existingFieldDefinition.fieldType == newFieldDefinition.fieldType) continue;
            modified |= artifactToSave.fields.remove(fieldId) != null;
        }
        return modified;
    }

    private boolean updateField(String fieldId, Artifact existingArtifact, Artifact newArtifact) {
        Object newFieldValue = newArtifact.fields.get(fieldId);
        Object oldFieldValue = existingArtifact.fields.put(fieldId, newFieldValue);
        return !Objects.equals(oldFieldValue, newFieldValue);
    }

    private boolean isDataFieldFromSync(String fieldId, FieldDefinition fieldDefinition) {
        return !Sets.newHashSet((Object[])new FieldType[]{FieldType.UPLOADED_FILE, FieldType.TIME_SERIES, FieldType.REFERENCE}).contains((Object)fieldDefinition.fieldType) && !Objects.equals(fieldId, "hidden_in_governable_items_table");
    }

    private boolean isDataFieldNotFromSync(String fieldId, FieldDefinition fieldDefinition) {
        return !Sets.newHashSet((Object[])new FieldType[]{FieldType.UPLOADED_FILE, FieldType.TIME_SERIES, FieldType.REFERENCE}).contains((Object)fieldDefinition.fieldType) && Sets.newHashSet((Object[])new String[]{"hidden_in_governable_items_table"}).contains(fieldId);
    }

    @Override
    public ProjectListDiffResult diffProjectListForDeletion(List<DSSProjectIdentifier> dssProjects, List<DSSProjectIdentifierWithId> ghProjects) {
        HashMap reconciliationMap = new HashMap();
        ghProjects.forEach(dssProject -> this.addProjectToReconciliationMap(reconciliationMap, (DSSProjectIdentifierWithId)((Object)dssProject), MutablePair::setLeft));
        dssProjects.forEach(dssProject -> this.addProjectToReconciliationMap(reconciliationMap, new DSSProjectIdentifierWithId((DSSProjectIdentifier)dssProject, null), MutablePair::setRight));
        ProjectListDiffResult result = new ProjectListDiffResult();
        reconciliationMap.values().forEach(ghDssProject -> {
            DSSProjectIdentifierWithId ghProject = (DSSProjectIdentifierWithId)((Object)((Object)ghDssProject.getLeft()));
            DSSProjectIdentifier dssProject = (DSSProjectIdentifier)ghDssProject.getRight();
            if (ghProject != null) {
                if (dssProject == null) {
                    result.projectsToDeleteInGH.add(ghProject);
                } else {
                    result.projectsToKeepInGH.add(ghProject);
                }
            }
        });
        return result;
    }

    private void addProjectToReconciliationMap(Map<String, MutablePair<DSSProjectIdentifierWithId, DSSProjectIdentifier>> reconciliationMap, DSSProjectIdentifierWithId projectIdentifier, BiConsumer<MutablePair<DSSProjectIdentifierWithId, DSSProjectIdentifier>, DSSProjectIdentifierWithId> pairSetter) {
        String projectKey = projectIdentifier.projectKey;
        reconciliationMap.compute(projectKey, (key, value) -> {
            MutablePair p = value == null ? new MutablePair() : value;
            pairSetter.accept(p, projectIdentifier);
            return p;
        });
    }

    private static class ProjectDiffWorkingContainer {
        public Pair<DSSArtifactContainer.DSSProjectArtifactContainer, DSSArtifactContainer.DSSProjectArtifactContainer> project;
        public Map<String, MutablePair<DSSArtifactContainer.DSSBundleArtifactContainer, DSSArtifactContainer.DSSBundleArtifactContainer>> bundles = new HashMap<String, MutablePair<DSSArtifactContainer.DSSBundleArtifactContainer, DSSArtifactContainer.DSSBundleArtifactContainer>>();
        public Map<String, MutablePair<DSSArtifactContainer.DSSDatasetArtifactContainer, DSSArtifactContainer.DSSDatasetArtifactContainer>> datasets = new HashMap<String, MutablePair<DSSArtifactContainer.DSSDatasetArtifactContainer, DSSArtifactContainer.DSSDatasetArtifactContainer>>();
        public Map<String, MutablePair<DSSArtifactContainer.DSSSavedModelArtifactContainer, DSSArtifactContainer.DSSSavedModelArtifactContainer>> savedModel = new HashMap<String, MutablePair<DSSArtifactContainer.DSSSavedModelArtifactContainer, DSSArtifactContainer.DSSSavedModelArtifactContainer>>();
        public Map<String, MutablePair<DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer, DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer>> retrievableKnowledges = new HashMap<String, MutablePair<DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer, DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer>>();
        public Map<String, MutablePair<DSSArtifactContainer.DSSSavedModelVersionArtifactContainer, DSSArtifactContainer.DSSSavedModelVersionArtifactContainer>> savedModelVersion = new HashMap<String, MutablePair<DSSArtifactContainer.DSSSavedModelVersionArtifactContainer, DSSArtifactContainer.DSSSavedModelVersionArtifactContainer>>();

        private ProjectDiffWorkingContainer() {
        }
    }

    private static enum ArtifactStatus {
        EXISTING,
        NEW;

    }

    public static class DiffResult<T> {
        public T artifactsToCreate;
        public T artifactsToUpdate;
        public T artifactsToDelete;
        public T artifactsUpToDate;

        private static <T> DiffResult<T> build(Supplier<T> supplier) {
            DiffResult<T> ret = new DiffResult<T>();
            ret.artifactsToCreate = supplier.get();
            ret.artifactsToUpdate = supplier.get();
            ret.artifactsUpToDate = supplier.get();
            ret.artifactsToDelete = supplier.get();
            return ret;
        }

        public static DiffResult<DSSSolvedDiffDeployerArtifactsContainer> buildForDeployer() {
            return DiffResult.build(DSSSolvedDiffDeployerArtifactsContainer::new);
        }

        public static DiffResult<DSSSolvedDiffProjectArtifactsContainer> buildForProject() {
            return DiffResult.build(DSSSolvedDiffProjectArtifactsContainer::new);
        }
    }

    private static class DeployerDiffWorkingContainer {
        public Map<String, MutablePair<DSSArtifactContainer.DSSAPIDeployerInfraArtifactContainer, DSSArtifactContainer.DSSAPIDeployerInfraArtifactContainer>> apiInfras = new HashMap<String, MutablePair<DSSArtifactContainer.DSSAPIDeployerInfraArtifactContainer, DSSArtifactContainer.DSSAPIDeployerInfraArtifactContainer>>();
        public Map<String, MutablePair<DSSArtifactContainer.DSSProjectDeployerInfraArtifactContainer, DSSArtifactContainer.DSSProjectDeployerInfraArtifactContainer>> projectInfras = new HashMap<String, MutablePair<DSSArtifactContainer.DSSProjectDeployerInfraArtifactContainer, DSSArtifactContainer.DSSProjectDeployerInfraArtifactContainer>>();
        public Map<String, MutablePair<DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer, DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer>> apiDeployments = new HashMap<String, MutablePair<DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer, DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer>>();
        public Map<String, MutablePair<DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer, DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer>> projectDeployments = new HashMap<String, MutablePair<DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer, DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer>>();

        private DeployerDiffWorkingContainer() {
        }
    }

    public static class ProjectListDiffResult {
        public List<DSSProjectIdentifierWithId> projectsToKeepInGH = new ArrayList<DSSProjectIdentifierWithId>();
        public List<DSSProjectIdentifierWithId> projectsToDeleteInGH = new ArrayList<DSSProjectIdentifierWithId>();
    }
}

