/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.relationships.collectors;

import com.dataiku.gh.core.models.relationships.FieldRelationshipData;
import com.dataiku.gh.core.models.relationships.ListFieldRelationshipDataDetails;
import com.dataiku.gh.core.models.relationships.PlainFieldRelationshipDataDetails;
import com.dataiku.gh.core.models.relationships.ReferenceRelationship;
import com.dataiku.gh.core.visitors.IFieldAndListValueVisitor;
import com.dataiku.gh.core.visitors.IFieldValueVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

class ReferencesRelationshipFieldCollector
implements IFieldValueVisitor {
    private final String from;
    private final String fieldId;
    public final List<ReferenceRelationship> relationships = new ArrayList<ReferenceRelationship>();

    ReferencesRelationshipFieldCollector(String from, String fieldId) {
        this.from = from;
        this.fieldId = fieldId;
    }

    @Override
    public void visit(String stringFieldValue) {
        FieldRelationshipData fieldRelationshipData = new FieldRelationshipData();
        fieldRelationshipData.fieldId = this.fieldId;
        fieldRelationshipData.details = new PlainFieldRelationshipDataDetails();
        ReferenceRelationship referenceRelationship = new ReferenceRelationship();
        referenceRelationship.artifactIdFrom = this.from;
        referenceRelationship.artifactIdTo = stringFieldValue;
        referenceRelationship.relationshipData = fieldRelationshipData;
        this.relationships.add(referenceRelationship);
    }

    @Override
    public void visit(List<Object> listFieldValue) {
        IntStream.range(0, listFieldValue.size()).forEach(i -> {
            Object fieldValue = listFieldValue.get(i);
            ListRelationshipFieldCollector collector = new ListRelationshipFieldCollector(i);
            collector.visit(fieldValue);
            this.relationships.add(collector.relationship);
        });
    }

    private class ListRelationshipFieldCollector
    implements IFieldAndListValueVisitor {
        private final int index;
        public ReferenceRelationship relationship;

        private ListRelationshipFieldCollector(int index) {
            this.index = index;
        }

        @Override
        public void visit(String stringFieldValue) {
            ListFieldRelationshipDataDetails listFieldRelationshipDataDetails = new ListFieldRelationshipDataDetails();
            listFieldRelationshipDataDetails.index = this.index;
            FieldRelationshipData fieldRelationshipData = new FieldRelationshipData();
            fieldRelationshipData.fieldId = ReferencesRelationshipFieldCollector.this.fieldId;
            fieldRelationshipData.details = listFieldRelationshipDataDetails;
            ReferenceRelationship referenceRelationship = new ReferenceRelationship();
            referenceRelationship.artifactIdFrom = ReferencesRelationshipFieldCollector.this.from;
            referenceRelationship.artifactIdTo = stringFieldValue;
            referenceRelationship.relationshipData = fieldRelationshipData;
            this.relationship = referenceRelationship;
        }
    }
}

