/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.roles;

import com.dataiku.gh.core.models.configuration.DefaultBlueprintPermissionsGovernConfiguration;
import com.dataiku.gh.core.models.configuration.GovernConfiguration;
import com.dataiku.gh.core.models.roles.Role;
import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.models.roles.permissions.BlueprintPermissions;
import com.dataiku.gh.core.services.configuration.IGovernConfigurationDataService;
import com.dataiku.gh.core.services.roles_and_permissions.roles.IRolesDataService;
import com.dataiku.gh.core.services.signoff.ISignoffsEventService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.storage.roles.assignments.IBlueprintRoleAssignmentsDAO;
import com.dataiku.gh.core.storage.roles.permissions.IBlueprintPermissionsDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RolesDataService
implements IRolesDataService {
    @Autowired
    private IRoleDAO roleDAO;
    @Autowired
    private IBlueprintRoleAssignmentsDAO blueprintRoleAssignmentsDAO;
    @Autowired
    private IBlueprintPermissionsDAO blueprintPermissionsDAO;
    @Autowired
    private IGovernConfigurationDataService governConfigurationDataService;
    @Autowired
    private ISignoffsEventService signoffsEventService;

    @Override
    @GHMandatoryTransaction
    public List<Role> listRoles() throws IOException {
        return this.roleDAO.list();
    }

    @Override
    @GHMandatoryTransaction
    public Role getRole(String roleId) throws IOException {
        return (Role)this.roleDAO.getOrNull(roleId);
    }

    @Override
    @GHMandatoryTransaction
    public Role createRole(Role role) throws IOException {
        return this.saveRole(role, true);
    }

    @Override
    @GHMandatoryTransaction
    public Role saveRole(Role role) throws IOException {
        return this.saveRole(role, false);
    }

    @Override
    @GHMandatoryTransaction
    public Role upsertRole(Role role) throws IOException {
        return this.saveRole(role, !this.roleDAO.exists(role.id));
    }

    @Override
    @GHMandatoryTransaction
    public void deleteRole(String roleId) throws IOException {
        if (!this.roleDAO.exists(roleId)) {
            throw new ValidationException("Role ID: " + roleId + " doesn't exist");
        }
        this.roleDAO.lock(roleId);
        ArrayList<Object> blueprintRoleAssignmentsToSave = new ArrayList<Object>();
        for (Object bra : this.blueprintRoleAssignmentsDAO.list()) {
            if (!((BlueprintRoleAssignments)bra).roleAssignmentsRules.containsKey(roleId)) continue;
            this.blueprintRoleAssignmentsDAO.lock(((BlueprintRoleAssignments)bra).blueprintId);
            blueprintRoleAssignmentsToSave.add(bra);
        }
        ArrayList<BlueprintPermissions> blueprintPermissionsToSave = new ArrayList<BlueprintPermissions>();
        for (BlueprintPermissions bp : this.blueprintPermissionsDAO.list()) {
            if (!bp.rolePermissions.containsKey(roleId)) continue;
            this.blueprintPermissionsDAO.lock(bp.blueprintId);
            blueprintPermissionsToSave.add(bp);
        }
        boolean updateDefaultBpPermissions = false;
        GovernConfiguration defaultBpPermissionsGovernConfig = this.governConfigurationDataService.getConfigurationItem("default-blueprint-permissions");
        BlueprintPermissions defaultBpPermissions = ((DefaultBlueprintPermissionsGovernConfiguration)defaultBpPermissionsGovernConfig).defaultBlueprintPermissions;
        if (defaultBpPermissions.rolePermissions.containsKey(roleId)) {
            this.governConfigurationDataService.lockConfigurationItem("default-blueprint-permissions");
            updateDefaultBpPermissions = true;
        }
        this.roleDAO.delete(roleId);
        for (BlueprintRoleAssignments blueprintRoleAssignments : blueprintRoleAssignmentsToSave) {
            blueprintRoleAssignments.roleAssignmentsRules.remove(roleId);
            this.blueprintRoleAssignmentsDAO.save(blueprintRoleAssignments);
        }
        for (BlueprintPermissions blueprintPermissions : blueprintPermissionsToSave) {
            blueprintPermissions.rolePermissions.remove(roleId);
            this.blueprintPermissionsDAO.save(blueprintPermissions);
        }
        this.signoffsEventService.onRoleDelete(roleId);
        if (updateDefaultBpPermissions) {
            defaultBpPermissions.rolePermissions.remove(roleId);
            this.governConfigurationDataService.upsertConfigurationItem(defaultBpPermissionsGovernConfig);
        }
    }

    private Role saveRole(Role role, boolean creation) throws IOException {
        this.roleDAO.lock(role.id);
        if (creation) {
            this.roleDAO.create(role);
        } else {
            this.roleDAO.save(role);
        }
        return (Role)this.roleDAO.getMandatory(role.id);
    }
}

