/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.blueprints.Action;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.LogicalHook;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.blueprints.WorkflowDefinition;
import com.dataiku.gh.core.models.blueprints.ui.UIDefinition;
import com.dataiku.gh.core.models.blueprints.ui.UIStepDefinition;
import com.dataiku.gh.core.models.blueprints.ui.View;
import com.dataiku.gh.core.models.blueprints.ui.view_components.ViewComponent;
import com.dataiku.gh.core.models.blueprints.ui.view_components.types.ActionViewComponent;
import com.dataiku.gh.core.models.blueprints.ui.view_components.types.FieldViewComponent;
import com.dataiku.gh.core.models.blueprints.ui.view_components.types.PluginActionViewComponent;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.category.StoredCategoryFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.number.StoredNumberFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.StoredReferenceFieldDefinition;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.services.validation.validators.ArtifactFilterValidator;
import com.dataiku.gh.core.services.view_component_registry.ViewComponentRegistryService;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.visitors.HierarchicalFieldDefinitionVisitor;
import com.dataiku.gh.core.visitors.IBlueprintVersionVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BlueprintVersionValidator
extends HierarchicalFieldDefinitionVisitor
implements IBlueprintVersionVisitor {
    private final Set<String> stepDefinitionIds = new HashSet<String>();
    private final Set<String> uiStepDefinitionIds = new HashSet<String>();
    private final ViewComponentRegistryService viewComponentRegistryService;
    private final BlueprintVersion blueprintVersion;

    public BlueprintVersionValidator(BlueprintVersion blueprintVersion, ViewComponentRegistryService viewComponentRegistryService) {
        this.blueprintVersion = blueprintVersion;
        this.viewComponentRegistryService = viewComponentRegistryService;
    }

    @Override
    public void visit(BlueprintVersion blueprintVersion) {
        if (StringUtils.isNotEmpty((CharSequence)blueprintVersion.hierarchicalParentFieldId) && !blueprintVersion.fieldDefinitions.containsKey(blueprintVersion.hierarchicalParentFieldId)) {
            throw new ValidationException("Non existing field definition used as hierarchical parent `" + blueprintVersion.hierarchicalParentFieldId + "` for blueprint version `" + String.valueOf(blueprintVersion.id) + "`");
        }
        if (this.stepDefinitionIds.size() != this.uiStepDefinitionIds.size() || !this.stepDefinitionIds.containsAll(this.uiStepDefinitionIds) || !this.uiStepDefinitionIds.containsAll(this.stepDefinitionIds)) {
            throw new ValidationException("StepValue IDs do not exactly match between workflowDefinition and uiDefinition for blueprint version: " + String.valueOf(blueprintVersion.id));
        }
    }

    @Override
    public void visit(BlueprintVersionId blueprintVersionId) {
        if (!IdentifiersUtils.isValidBlueprintVersionId(blueprintVersionId.versionId)) {
            throw new ValidationException("Invalid blueprint version ID `" + blueprintVersionId.versionId + "` in blueprint version `" + String.valueOf(blueprintVersionId) + "`");
        }
        if (!IdentifiersUtils.isValidBlueprintId(blueprintVersionId.blueprintId)) {
            throw new ValidationException("Invalid referenced blueprint ID `" + blueprintVersionId.blueprintId + "` `in blueprint version `" + String.valueOf(blueprintVersionId) + "`");
        }
    }

    @Override
    public void visit(WorkflowDefinition workflowDefinition) {
    }

    @Override
    public void visit(UIDefinition uiDefinition) {
        this.validateViewId(uiDefinition.artifactPageViewId);
    }

    @Override
    public void visit(UIStepDefinition uiStepDefinition, String stepId) {
        if (StringUtils.isBlank((CharSequence)stepId)) {
            throw new ValidationException("StepId `" + stepId + "` in UIStep is required in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
        this.validateViewId(uiStepDefinition.viewId);
        this.uiStepDefinitionIds.add(stepId);
    }

    @Override
    public void visit(StepDefinition stepDefinition) {
        if (!IdentifiersUtils.isValidHumanReadableId(stepDefinition.id)) {
            throw new ValidationException("Invalid stepValue definition ID `" + stepDefinition.id + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`");
        }
        if (StringUtils.isBlank((CharSequence)stepDefinition.name)) {
            throw new ValidationException("StepValue definition name is required for ID `" + stepDefinition.id + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`");
        }
        if (this.stepDefinitionIds.contains(stepDefinition.id)) {
            throw new ValidationException("Duplicate stepValue ID in workflowDefinition `" + stepDefinition.id + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`");
        }
        this.stepDefinitionIds.add(stepDefinition.id);
        if (stepDefinition.visibilityCondition != null) {
            ArtifactFilterValidator artifactFilterValidator = new ArtifactFilterValidator();
            stepDefinition.visibilityCondition.accept(artifactFilterValidator);
        }
    }

    @Override
    public void visit(LogicalHook logicalHook) {
        if (StringUtils.isBlank((CharSequence)logicalHook.name)) {
            throw new ValidationException("Logical hook name is required in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
    }

    @Override
    public void visit(Action action) {
        if (StringUtils.isBlank((CharSequence)action.name)) {
            throw new ValidationException("Param name in Action is required in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
    }

    @Override
    public void visit(ActionViewComponent viewComponent) {
        this.validateViewComponent(viewComponent);
        if (StringUtils.isBlank((CharSequence)viewComponent.actionId)) {
            throw new ValidationException("Param actionId in ActionViewComponent is required in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
        if (StringUtils.isBlank((CharSequence)viewComponent.actionButtonLabel)) {
            throw new ValidationException("Param label in ActionViewComponent is required in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "` and action id: " + viewComponent.actionId);
        }
        Action actionDef = this.blueprintVersion.actions.get(viewComponent.actionId);
        if (actionDef == null) {
            throw new ValidationException("action id '" + viewComponent.actionId + "' does not exist for view component '" + viewComponent.label + "' in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
    }

    @Override
    public void visit(PluginActionViewComponent viewComponent) {
        this.validateViewComponent(viewComponent);
        if (StringUtils.isBlank((CharSequence)viewComponent.pluginId)) {
            throw new ValidationException("Param pluginId in PluginActionViewComponent is required in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
        if (StringUtils.isBlank((CharSequence)viewComponent.actionId)) {
            throw new ValidationException("Param actionId in PluginActionViewComponent is required in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
        if (StringUtils.isBlank((CharSequence)viewComponent.actionLabel)) {
            throw new ValidationException("Param label in PluginActionViewComponent is required in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
    }

    @Override
    public void visit(FieldViewComponent viewComponent) {
        this.validateViewComponent(viewComponent);
        if (StringUtils.isBlank((CharSequence)viewComponent.fieldId)) {
            throw new ValidationException("Param fieldId in FieldViewComponent is required in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
        if (!IdentifiersUtils.isValidHumanReadableId(viewComponent.fieldId)) {
            throw new ValidationException("Invalid fieldId in FieldViewComponent `" + viewComponent.label + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`");
        }
        this.validateFieldDefBinding(viewComponent);
    }

    @Override
    public void visit(StoredCategoryFieldDefinition fieldDefinition, String fieldId) {
        super.visit(fieldDefinition, fieldId);
        if (CollectionUtils.isEmpty((Collection)fieldDefinition.categories)) {
            throw new ValidationException("The field definition `" + fieldId + "` must contain at least one category in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`");
        }
        for (String category : fieldDefinition.categories) {
            if (!StringUtils.isBlank((CharSequence)category)) continue;
            throw new ValidationException("A category cannot be blank in field `" + fieldId + "` and blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`");
        }
    }

    @Override
    public void visit(StoredNumberFieldDefinition fieldDefinition, String fieldId) {
        super.visit(fieldDefinition, fieldId);
        if (fieldDefinition.max != null && fieldDefinition.max < fieldDefinition.min) {
            throw new ValidationException("Invalid number field definition `" + fieldId + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`, max cannot be inferior to min: " + fieldDefinition.max + " < " + fieldDefinition.min);
        }
    }

    @Override
    public void visit(StoredReferenceFieldDefinition fieldDefinition, String fieldId) {
        super.visit(fieldDefinition, fieldId);
        if (fieldDefinition.allowedBlueprints.stream().anyMatch(StringUtils::isBlank)) {
            throw new ValidationException("Invalid Field Definition `" + fieldId + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`, an allowed blueprint id is not defined: " + String.valueOf(fieldDefinition.allowedBlueprints));
        }
    }

    @Override
    public void visit(FieldDefinition fieldDefinition, String fieldId) {
        if (StringUtils.isBlank((CharSequence)fieldDefinition.label)) {
            throw new ValidationException("Field `" + fieldId + "` label is mandatory in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
        FieldDefinition.ListConfig listConfig = fieldDefinition.listConfig;
        if (listConfig == null) {
            return;
        }
        if (listConfig.cardinalityMin != null && listConfig.cardinalityMin < 0) {
            throw new ValidationException("Minimal cardinality for `" + fieldId + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "` can not be negative: min = " + listConfig.cardinalityMin);
        }
        if (listConfig.cardinalityMax != null && listConfig.cardinalityMax <= 0) {
            throw new ValidationException("Maximal cardinality for `" + fieldId + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "` can not be zero or negative: max = " + listConfig.cardinalityMax);
        }
        if (listConfig.cardinalityMin != null && listConfig.cardinalityMax != null && listConfig.cardinalityMax < listConfig.cardinalityMin) {
            throw new ValidationException("Maximal cardinality for `" + fieldId + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "` can not be inferior than minimum cardinality: min = " + listConfig.cardinalityMin + "; max = " + listConfig.cardinalityMax);
        }
    }

    @Override
    public void visit(View view, String viewId) {
        if (!IdentifiersUtils.isValidHumanReadableId(viewId)) {
            throw new ValidationException("Invalid View ID `" + viewId + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`");
        }
        if (StringUtils.isBlank((CharSequence)view.label)) {
            throw new ValidationException("View label is required for ID `" + viewId + "` in blueprint version `" + String.valueOf(this.blueprintVersion.id) + "`");
        }
    }

    private void validateViewComponent(ViewComponent viewComponent) {
        if (StringUtils.isBlank((CharSequence)viewComponent.label)) {
            throw new ValidationException("View Component label is required in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
        if (viewComponent.visibilityCondition != null) {
            ArtifactFilterValidator artifactFilterValidator = new ArtifactFilterValidator();
            viewComponent.visibilityCondition.accept(artifactFilterValidator);
        }
    }

    private <T extends FieldViewComponent> void validateFieldDefBinding(FieldViewComponent fieldViewComponent) {
        FieldDefinition fieldDef = this.blueprintVersion.fieldDefinitions.get(fieldViewComponent.fieldId);
        if (fieldDef == null) {
            throw new ValidationException("Field id '" + fieldViewComponent.fieldId + "' does not exist for view component '" + fieldViewComponent.label + "' in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
        if (!this.viewComponentRegistryService.allowedFieldTypesByViewComponent.get(fieldViewComponent.getClass()).contains((Object)fieldDef.fieldType)) {
            throw new ValidationException("View Component '" + fieldViewComponent.label + "' can't be bound to fieldDefinition of type '" + String.valueOf((Object)fieldDef.fieldType) + "' in blueprint version  " + String.valueOf(this.blueprintVersion.id));
        }
    }

    private void validateViewId(String viewId) {
        if (StringUtils.isNotBlank((CharSequence)viewId) && !this.blueprintVersion.uiDefinition.views.containsKey(viewId)) {
            throw new ValidationException("View Id `" + viewId + "` does not exist in blueprint version: " + String.valueOf(this.blueprintVersion.id));
        }
    }
}

