/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.user_config;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.user_config.UserConfiguration;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.model.QUserConfiguration;
import com.dataiku.gh.core.storage.sql.model.QUserConfigurationHistory;
import com.dataiku.gh.core.storage.sql.user_config.UserConfigurationRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.storage.user_config.IUserConfigurationDAO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanTemplate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.SimpleTemplate;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;

public class UserConfigurationDAO
extends AbstractItemBasedDAO<String, UserConfiguration, UserConfiguration>
implements IUserConfigurationDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.user_config");
    @Autowired
    private UserConfigurationRowMapper userConfigurationRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.USER_CONFIGURATION;
    }

    @Override
    protected RowMapper<UserConfiguration> getRowMapper() {
        return this.userConfigurationRowMapper;
    }

    @Override
    protected String getId(UserConfiguration item) {
        return item.userIdentifier;
    }

    @Override
    protected RelationalPathBase<?> getItemTablePath() {
        return QUserConfiguration.userConfiguration;
    }

    @Override
    protected SimplePath<Object> getItemTableJsonColumnPath() {
        return QUserConfiguration.userConfiguration.userConfigurationJson;
    }

    @Override
    protected Predicate getIdCondition(String id) {
        return QUserConfiguration.userConfiguration.userConfigurationId.eq((Object)id);
    }

    @Override
    protected RelationalPathBase<?> getHistoryTablePath() {
        return QUserConfigurationHistory.userConfigurationHistory;
    }

    @Override
    protected SimplePath<Object> getHistoryRevisionColumnPath() {
        return QUserConfigurationHistory.userConfigurationHistory._revisionJson;
    }

    @Override
    protected SimplePath<Object> getHistoryJsonColumnPath() {
        return QUserConfigurationHistory.userConfigurationHistory.userConfigurationJson;
    }

    @Override
    public List<UserConfiguration> getAndLockConfigWithPageId(String pageId) throws IOException {
        SimpleTemplate<Object> fieldExpr = QueryBuilderUtils.jsonObjectDefaultSQLNull(QUserConfiguration.userConfiguration.userConfigurationJson, new String[]{"pages", pageId});
        BooleanTemplate booleanExpression = QueryBuilderUtils.jsonPathExists(fieldExpr, "strict $");
        SQLQuery query = (SQLQuery)((SQLQuery)this.buildBaseSelectQuery().where((Predicate)booleanExpression)).forUpdate();
        try {
            return this.querydslJdbcTemplate.query(query, this.userConfigurationRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }
}

