/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.reports;

import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.server.services.UsageDataReporting;
import com.dataiku.dip.utils.AbstractBoundedQueueHandler;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.server.services.PubSubService;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReflectedEventsService
extends AbstractBoundedQueueHandler<IReflectedEventsService.ReflectedEvent>
implements IReflectedEventsService {
    private static final int MAX_EVENTS = 100;
    private static final int BATCH_SIZE = 5;
    private final File volatileFile = ApplicationConfigurator.getFile((String)"caches/reflected-events-v.json");
    @Autowired
    private PubSubService pubSub;
    private static final Logger logger = Logger.getLogger((String)"dku.reports.reflectedevents");

    public ReflectedEventsService() {
        super("dku.reflectedEvents.queue.max", 1000, "ReflectedEventsQueueThread", "dku.reflectedEvents");
    }

    @PostConstruct
    public void init() {
        this.pubSub.subscribe("reflected-event", evt -> {
            logger.info((Object)("Handling reflected event via pubsub: " + evt.payload.message));
            this.enqueueIgnore(evt.payload);
        });
    }

    public synchronized void process(IReflectedEventsService.ReflectedEvent event) throws IOException {
        ReportedEventsFile data = this.readData();
        while (data.events.size() >= 99) {
            logger.debug((Object)"Reflected events queue is full, dropping old event");
            data.events.remove(0);
        }
        data.events.add(event);
        logger.debug((Object)("Writing reflected events DB file=" + String.valueOf(this.volatileFile) + " size=" + data.events.size()));
        JSON.prettyToFile((Object)data, (File)this.volatileFile);
    }

    public synchronized ReportedEventsFile popBatchToSend() throws IOException {
        ReportedEventsFile send = new ReportedEventsFile();
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettings();
        if (gs.udrMode != UsageDataReporting.UsageDataReportingMode.DEFAULT) {
            logger.debug((Object)"UDR is disabled, not sending stored reflected events");
            return send;
        }
        ReportedEventsFile data = this.readData();
        if (data.events.size() > 5) {
            send.events = data.events.subList(0, 5);
            data.events = data.events.subList(5, data.events.size() - 1);
        } else {
            send.events = data.events;
            data.events = new ArrayList<IReflectedEventsService.ReflectedEvent>();
        }
        JSON.prettyToFile((Object)data, (File)this.volatileFile);
        return send;
    }

    public void publish(IReflectedEventsService.ReflectedEvent event) throws IOException {
        this.enqueueIgnore(event);
    }

    private ReportedEventsFile readData() throws IOException {
        assert (Thread.holdsLock((Object)this));
        File file = this.volatileFile;
        if (file.isFile()) {
            return (ReportedEventsFile)JSON.parseFile((File)file, ReportedEventsFile.class);
        }
        return new ReportedEventsFile();
    }

    @UIModel
    public static class ReportedEventsFile {
        public List<IReflectedEventsService.ReflectedEvent> events = new ArrayList<IReflectedEventsService.ReflectedEvent>();
    }
}

