/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.ColumnInfo;
import io.trino.jdbc.TrinoResultSetMetaData;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TrinoParameterMetaData
implements ParameterMetaData {
    private final List<ColumnInfo> parameterInfo;

    TrinoParameterMetaData(List<ColumnInfo> parameterInfo) {
        this.parameterInfo = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameterInfo, "parameterInfo is null"));
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterInfo.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        switch (this.getParameter(param).getNullable()) {
            case NO_NULLS: {
                return 0;
            }
            case NULLABLE: {
                return 1;
            }
            case UNKNOWN: {
                return 2;
            }
        }
        throw new SQLException(String.format("Invaliad Nullable Value %s", new Object[]{this.getParameter(param).getNullable()}));
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParameter(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParameter(param).getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParameter(param).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParameter(param).getColumnType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParameter(param).getColumnTypeSignature().getRawType();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return TrinoResultSetMetaData.getType(this.getParameter(param).getColumnType());
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private ColumnInfo getParameter(int column) throws SQLException {
        if (column <= 0 || column > this.parameterInfo.size()) {
            throw new SQLException(String.format("Invalid column index: %s (only allow between 1 to %s)", column, this.parameterInfo.size()));
        }
        return this.parameterInfo.get(column - 1);
    }
}

