/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.generated;

import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.scoring.ClassificationResult;
import com.dataiku.scoring.RegressionResult;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationResult;
import com.dataiku.scoring.pipelines.OverrideInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class Prediction<T> {
    public final T prediction;
    public final OverrideInfo override;

    protected Prediction(T prediction, OverrideInfo override) {
        this.prediction = prediction;
        this.override = override;
    }

    public T getPrediction() {
        return this.prediction;
    }

    public Optional<OverrideInfo> getOverrideInfo() {
        return Optional.ofNullable(this.override);
    }

    public static class PClassificationWithMap
    extends Prediction<String> {
        public final Map<String, Double> probabilities;

        protected PClassificationWithMap(PClassification classification, String[] classes) {
            super((String)classification.getPrediction(), classification.override);
            this.probabilities = new HashMap<String, Double>(classes.length);
            double[] probas = classification.probabilities;
            for (int i = 0; i < classes.length; ++i) {
                this.probabilities.put(classes[i], probas != null ? Double.valueOf(probas[i]) : null);
            }
        }

        public Map<String, Double> getProbabilities() {
            return this.probabilities;
        }
    }

    public static class PClassification
    extends Prediction<String>
    implements ClassificationResult {
        public final double[] probabilities;

        public PClassification(com.dataiku.scoring.pipelines.ClassificationResult result) {
            super((String)result.getPrediction(), result.overrideInfo);
            this.probabilities = result.getProbabilities();
        }

        @Override
        public double[] getProbabilities() {
            return this.probabilities;
        }
    }

    public static class NPClassification
    extends Prediction<String>
    implements ClassificationResult {
        protected NPClassification(NonProbabilisticClassificationResult result) {
            super((String)result.getPrediction(), result.overrideInfo);
        }

        @Override
        public double[] getProbabilities() {
            throw new UnsupportedOperationException("Requested probabilities on non-probabilistic model");
        }
    }

    public static class Regression
    extends Prediction<Double>
    implements RegressionResult {
        @Nullable
        public final Double predictionIntervalLower;
        @Nullable
        public final Double predictionIntervalUpper;

        protected Regression(com.dataiku.scoring.pipelines.RegressionResult result) {
            super((Double)result.getPrediction(), result.overrideInfo);
            this.predictionIntervalLower = result.getPredictionInterval().map(i -> i.lower).orElse(null);
            this.predictionIntervalUpper = result.getPredictionInterval().map(i -> i.upper).orElse(null);
        }

        @Override
        public Optional<Double> getPredictionIntervalLower() {
            return Optional.ofNullable(this.predictionIntervalLower);
        }

        @Override
        public Optional<Double> getPredictionIntervalUpper() {
            return Optional.ofNullable(this.predictionIntervalUpper);
        }
    }
}

