/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.linalg;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class Util {
    private Util() {
    }

    private static class RangeIterator
    implements Iterator<Integer> {
        private final int size;
        private int index;

        public RangeIterator(int size) {
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public Integer next() {
            if (this.index < this.size) {
                return this.index++;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Range
    implements Iterable<Integer> {
        private final int size;

        public Range(int size) {
            this.size = size;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new RangeIterator(this.size);
        }
    }
}

