/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractAnumMeaning;
import com.dataiku.dip.utils.FastSafePatternMatcher;

public class FrenchDoubleMeaning
extends AbstractAnumMeaning {
    private static final String EXP_PART = "([eE][+-]?[0-9]+)?";
    private static final FastSafePatternMatcher MATCHER = new FastSafePatternMatcher("[+-]?([0-9]{1,3} ([0-9]{3} )*)?[0-9]+(([eE][+-]?[0-9]+)?$|,[0-9]+([eE][+-]?[0-9]+)?)");

    @Override
    public double detects(String v) {
        if (v == null) {
            return 0.0;
        }
        boolean foundDigit = false;
        for (int i = 0; i < v.length(); ++i) {
            if (!Character.isDigit(v.charAt(i))) continue;
            foundDigit = true;
            break;
        }
        if (!foundDigit) {
            if (v.equals("NaN") || v.equals("Infinity") || v.equals("-Infinity")) {
                return 0.25;
            }
            return 0.0;
        }
        if (MATCHER.matches(v)) {
            int spaceCount = 0;
            boolean hasComma = false;
            for (int i = 0; i < v.length(); ++i) {
                char c = v.charAt(i);
                hasComma |= c == ',';
                spaceCount += c == ' ' ? 1 : 0;
            }
            return !hasComma && spaceCount > 10 ? 0.0 : 0.25;
        }
        return 0.0;
    }
}

