/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongList
implements Iterable<Long> {
    private transient long[] data;
    private int size;

    public LongList(int initialCapacity) {
        this.data = new long[initialCapacity];
    }

    public LongList() {
        this(10);
    }

    public LongList(LongList other) {
        this.size = other.size();
        this.data = new long[other.capacity()];
        System.arraycopy(other.getAllData(), 0, this.data, 0, other.capacity());
    }

    private long[] getAllData() {
        return this.data;
    }

    public long[] getValidDataCopy() {
        long[] newData = new long[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        return newData;
    }

    public long get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
        return this.data[index];
    }

    public long getUnsafe(int index) {
        return this.data[index];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int capacity() {
        return this.data.length;
    }

    public void setSize(int newSize) {
        if (newSize > this.capacity()) {
            throw new IndexOutOfBoundsException("Trying to set size to " + newSize + " but capacity only " + this.capacity());
        }
        this.size = newSize;
    }

    public long set(int index, long element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
        long previous = this.data[index];
        this.data[index] = element;
        return previous;
    }

    public void add(long o) {
        if (this.size >= this.data.length) {
            this.grow(this.size + 1);
        }
        this.data[this.size++] = o;
    }

    public void grow(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            long[] oldData = this.data;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new long[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public void growExact(int capacity) {
        int oldCapacity = this.data.length;
        if (oldCapacity >= capacity) {
            return;
        }
        long[] oldData = this.data;
        this.data = new long[capacity];
        System.arraycopy(oldData, 0, this.data, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private int nextIndex = 0;

            @Override
            public boolean hasNext() {
                return this.nextIndex < LongList.this.size();
            }

            @Override
            public Long next() {
                if (this.nextIndex >= LongList.this.size()) {
                    throw new NoSuchElementException();
                }
                return LongList.this.data[this.nextIndex++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported on LongList.");
            }
        };
    }
}

