/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.code.CodeEnvImportUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.CodeEnvVersionChecker;
import com.dataiku.dip.code.PythonCodeEnvUtils;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.model.serverconfig.EndpointConfigWithCodeEnv;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class APINodeCodeEnvImporter {
    private static final String CODE_ENV_RESOURCE_INIT_SCRIPT_DONE = "init_done.txt";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.code-envs");

    public void importEnvIfNeeded(CodeEnvModel.EnvLang envLang, String serviceId, String endpointId, File exportedEnvDir, File targetDir, File cacheBaseDir, boolean forceRebuildEnv) throws Exception {
        logger.info((Object)("Importing env " + String.valueOf(envLang) + " from " + String.valueOf(exportedEnvDir) + " to " + String.valueOf(targetDir)));
        if (this.f(targetDir, "ready.txt").isFile()) {
            logger.info((Object)"Already ready, nothing to do");
            return;
        }
        File unmanagedEnvPath = ((LambdaContext)SpringUtils.getBean(LambdaContext.class)).getFile(new String[]{"unmanaged-code-envs", envLang.toString().toLowerCase(), serviceId, endpointId});
        if (unmanagedEnvPath.isDirectory()) {
            logger.infoV("Env for %s %s %s is non-managed, only linking it", new Object[]{envLang, serviceId, endpointId});
            DKUFileUtils.forceCreateSymbolicLink((Path)targetDir.toPath(), (Path)unmanagedEnvPath.toPath());
        } else {
            File targetVersionDir = this.importManagedEnv(envLang, exportedEnvDir, cacheBaseDir, forceRebuildEnv, CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE, CodeEnvModel.EnvImportSpecificationMode.SPECIFIED);
            logger.infoV("Linking %s -> %s", new Object[]{targetDir, targetVersionDir});
            DKUFileUtils.forceCreateSymbolicLink((Path)targetDir.toPath(), (Path)targetVersionDir.toPath());
        }
    }

    public File importManagedEnv(CodeEnvModel.EnvLang envLang, File exportedEnvDir, File cacheBaseDir, boolean forceRebuildEnv, CodeEnvModel.CodeEnvDeploymentMode deploymentMode, CodeEnvModel.EnvImportSpecificationMode specMode) throws Exception {
        DKUtils.SmartLogTailBuilder logTailBuilder;
        boolean needsBuild;
        Object versionToUse;
        LambdaServerConfig lsc = ((LambdaContext)SpringUtils.getBean(LambdaContext.class)).getConfigOrNull();
        LambdaServerConfig.APINodeCodeEnvsSettings envSettings = null;
        if (lsc != null && lsc.codeEnvsSettings != null) {
            envSettings = lsc.codeEnvsSettings.preventOverrideFromImportedEnvs ? lsc.codeEnvsSettings : null;
        }
        String hash = new CodeEnvVersionChecker().getCodeEnvSpecHash(envLang, exportedEnvDir, specMode);
        logger.info((Object)("Hash of the env to import is " + hash));
        File hashCacheRoot = new File(cacheBaseDir, hash);
        if (hashCacheRoot.isDirectory()) {
            logger.info((Object)"Hash cache root exists");
            long version = DKUFileUtils.highestFileNumber((File)hashCacheRoot, (String)"v");
            if (version == -1L) {
                versionToUse = "v1";
                needsBuild = true;
            } else if (forceRebuildEnv) {
                versionToUse = "v" + (version + 1L);
                needsBuild = true;
            } else if (!new File(hashCacheRoot, "v" + version + "/ready.txt").isFile()) {
                logger.warn((Object)("Version " + version + " does not have the ready marker, will rebuild"));
                versionToUse = "v" + (version + 1L);
                needsBuild = true;
            } else {
                versionToUse = "v" + version;
                needsBuild = false;
            }
        } else {
            logger.info((Object)"No hash cache root");
            DKUFileUtils.mkdirs((File)hashCacheRoot);
            versionToUse = "v1";
            needsBuild = true;
        }
        logger.infoV("versionToUse=%s build=%s", new Object[]{versionToUse, needsBuild});
        File targetVersionDir = new File(hashCacheRoot, (String)versionToUse);
        if (needsBuild) {
            if (targetVersionDir.exists()) {
                DKUFileUtils.forceDelete((File)targetVersionDir);
            }
            DKUFileUtils.mkdirs((File)targetVersionDir);
            logTailBuilder = new DKUtils.SmartLogTailBuilder();
            switch (envLang) {
                case PYTHON: {
                    CodeEnvImportUtils.importPythonEnvInFolder((AuthCtx)DSSAuthCtx.newNone(), (File)targetVersionDir, (File)exportedEnvDir, (File)targetVersionDir, (CodeEnvModel.CodeEnvDeploymentMode)deploymentMode, (CodeEnvModel.EnvImportSpecificationMode)specMode, (DKUtils.SmartLogTailBuilder)logTailBuilder, (GeneralSettingsDAO.AbstractCodeEnvExtraSettings)envSettings);
                    CodeEnvImportUtils.markManagedNotReady((File)targetVersionDir);
                    if (!APINodeCodeEnvImporter.isResourceInitScriptRequired(envLang, deploymentMode, targetVersionDir)) break;
                    APINodeCodeEnvImporter.runResourceInitScriptAndMarkDone(targetVersionDir, hash, logTailBuilder);
                    break;
                }
                case R: {
                    CodeEnvImportUtils.importREnvInFolder((AuthCtx)DSSAuthCtx.newNone(), (File)targetVersionDir, (File)exportedEnvDir, (File)targetVersionDir, (CodeEnvModel.CodeEnvDeploymentMode)deploymentMode, (CodeEnvModel.EnvImportSpecificationMode)specMode, (DKUtils.SmartLogTailBuilder)logTailBuilder, (GeneralSettingsDAO.AbstractCodeEnvExtraSettings)envSettings);
                }
            }
        }
        if (APINodeCodeEnvImporter.isResourceInitScriptRequired(envLang, deploymentMode, targetVersionDir)) {
            logger.infoV("Resource init script for code env in %s has not already been run, running it now", new Object[]{targetVersionDir.getAbsolutePath()});
            logTailBuilder = new DKUtils.SmartLogTailBuilder();
            APINodeCodeEnvImporter.runResourceInitScriptAndMarkDone(targetVersionDir, hash, logTailBuilder);
        }
        CodeEnvImportUtils.markManagedReady((File)targetVersionDir);
        return targetVersionDir;
    }

    private static void runResourceInitScriptAndMarkDone(File targetVersionDir, String hash, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        File descFolder = DKUFileUtils.getWithin((File)targetVersionDir, (String[])new String[]{"desc"});
        File resourcesFolder = DKUFileUtils.getWithin((File)targetVersionDir, (String[])new String[]{"resources"});
        File envRootFolder = DKUFileUtils.getWithin((File)targetVersionDir, (String[])new String[]{"env"});
        File log = DKUFileUtils.getWithin((File)targetVersionDir, (String[])new String[]{"importPythonEnv.log"});
        DKUFileUtils.mkdirsParent((File)log);
        PythonCodeEnvUtils.maybeRunResourcesInitScript((AuthCtx)DSSAuthCtx.newNone(), (String)hash, (File)descFolder, (File)envRootFolder, (File)resourcesFolder, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log, null);
        APINodeCodeEnvImporter.markResourceInitScriptDone(targetVersionDir);
    }

    private static boolean isResourceInitScriptRequired(CodeEnvModel.EnvLang envLang, CodeEnvModel.CodeEnvDeploymentMode deploymentMode, File targetVersionDir) throws IOException {
        if (!CodeEnvModel.EnvLang.PYTHON.equals((Object)envLang) || CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED.equals((Object)deploymentMode) || APINodeCodeEnvImporter.isResourceInitScriptDone(targetVersionDir)) {
            return false;
        }
        File descFolder = DKUFileUtils.getWithin((File)targetVersionDir, (String[])new String[]{"desc"});
        CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)DKUFileUtils.getWithin((File)descFolder, (String[])new String[]{"desc.json"}), CodeEnvModel.PythonEnvDesc.class);
        return desc.installCorePackages && desc.updateResourcesApiNode;
    }

    private static boolean isResourceInitScriptDone(File targetVersionDir) {
        return new File(targetVersionDir, CODE_ENV_RESOURCE_INIT_SCRIPT_DONE).isFile();
    }

    private static void markResourceInitScriptDone(File targetVersionDir) throws IOException {
        DKUFileUtils.createIfNotExists((File)new File(targetVersionDir, CODE_ENV_RESOURCE_INIT_SCRIPT_DONE));
    }

    public static void linkToHostNodeCodeEnvs(ServiceGenContext sc) throws IOException {
        LambdaContext lambdaContext = (LambdaContext)SpringUtils.getBean(LambdaContext.class);
        LambdaServerConfig.DevLambdaServerSettings devLambdaServerSettings = lambdaContext.getMandatoryConfig().devLambdaServerSettings;
        if (null == devLambdaServerSettings) {
            throw new IllegalArgumentException("Dev lambda server settings not found in the server configuration");
        }
        ApplicationConfigurator.DSSNodeType hostNodeType = devLambdaServerSettings.hostNodeType;
        logger.infoV("Trying to link lambda dev server code environments to the %s node ones", new Object[]{hostNodeType.toString()});
        for (LambdaEndpointConfig endpointConfig : sc.getConfig().endpoints) {
            CodeEnvModel.UsedCodeEnvRef codeEnvRef;
            logger.infoV("Checking if endpoint \"%s\" requires a code environment", new Object[]{endpointConfig.id});
            try {
                codeEnvRef = APINodeCodeEnvImporter.getCodeEnvRef(endpointConfig, sc);
            }
            catch (Exception e) {
                codeEnvRef = null;
                logger.warnV((Throwable)e, "Error while trying the get the code environment for endpoint \"%s\". It will not be linked it to the starting node code environment and will be rebuilt.", new Object[]{endpointConfig.id});
            }
            if (null == codeEnvRef || null == codeEnvRef.envName) continue;
            CodeEnvModel.EnvLang envLang = codeEnvRef.envLang;
            String envName = codeEnvRef.envName;
            File targetDir = DKUFileUtils.getWithin((File)sc.getBaseFolder(), (String[])new String[]{"endpoint-" + endpointConfig.id, envLang.getFolderName() + "-env-live"});
            logger.infoV("Linking lambda dev server code env of \"%s\" endpoint to %s node %s code env \"%s\"", new Object[]{endpointConfig.id, hostNodeType.toString().toLowerCase(), envLang.getLanguageInfo(), envName});
            try {
                String envVersion = CodeEnvResolutionService.getEnvVersionToUseForContainerImageLookup((String)envName, (CodeEnvModel.EnvLang)envLang, (String)devLambdaServerSettings.projectKey, (ApplicationConfigurator.DSSNodeType)hostNodeType);
                if (envVersion != null) {
                    logger.infoV("Targeting code environment version \"%s\"", new Object[]{envVersion});
                }
                File apiDesignerActualEnvDir = CodeEnvResolutionService.getActualEnvDir((String)envName, (CodeEnvModel.EnvLang)envLang, (String)envVersion, (ApplicationConfigurator.DSSNodeType)hostNodeType);
                File apiDesignerEnvDescDir = CodeEnvResolutionService.getEnvDescDir((String)envName, (CodeEnvModel.EnvLang)envLang, (String)envVersion, (ApplicationConfigurator.DSSNodeType)hostNodeType);
                File apiDesignerEnvResourcesDir = CodeEnvResolutionService.getEnvResourcesDir((String)envName, (CodeEnvModel.EnvLang)envLang, (String)envVersion, (ApplicationConfigurator.DSSNodeType)hostNodeType);
                logger.infoV("Looking for actual code environment in \"%s\" and code environment desc in \"%s\"", new Object[]{apiDesignerActualEnvDir.getAbsolutePath(), apiDesignerEnvDescDir.getAbsolutePath()});
                if (apiDesignerActualEnvDir.exists() && apiDesignerEnvDescDir.exists()) {
                    DKUFileUtils.mkdirs((File)targetDir);
                    logger.infoV("Linking actual code environment to %s", new Object[]{apiDesignerActualEnvDir.getAbsolutePath()});
                    DKUFileUtils.forceCreateSymbolicLink((Path)DKUFileUtils.getWithin((File)targetDir, (String[])new String[]{"env"}).toPath(), (Path)apiDesignerActualEnvDir.toPath());
                    logger.infoV("Linking code environment desc to %s", new Object[]{apiDesignerEnvDescDir.getAbsolutePath()});
                    DKUFileUtils.forceCreateSymbolicLink((Path)DKUFileUtils.getWithin((File)targetDir, (String[])new String[]{"desc"}).toPath(), (Path)apiDesignerEnvDescDir.toPath());
                    if (apiDesignerEnvResourcesDir.exists()) {
                        logger.infoV("Linking code environment resources to %s", new Object[]{apiDesignerEnvResourcesDir.getAbsolutePath()});
                        DKUFileUtils.forceCreateSymbolicLink((Path)DKUFileUtils.getWithin((File)targetDir, (String[])new String[]{"resources"}).toPath(), (Path)apiDesignerEnvResourcesDir.toPath());
                    }
                    logger.infoV("Marking code environment of endpoint \"%s\" as ready", new Object[]{endpointConfig.id});
                    CodeEnvImportUtils.markManagedReady((File)targetDir);
                    continue;
                }
                logger.warnV("The %s code environment \"%s\" does not exist on the %s node or is incomplete. Code environment for endpoint %s will be rebuilt.", new Object[]{envLang.getLanguageInfo(), envName, hostNodeType.toString().toLowerCase(), endpointConfig.id});
            }
            catch (CodedIOException e) {
                logger.warnV("Unexpected %s code environment type for \"%s\". Skipping it.", new Object[]{envLang.getLanguageInfo(), envName});
            }
        }
        logger.infoV("Finished linking lambda dev server code environments to the %s node ones", new Object[]{hostNodeType.toString()});
    }

    @Nullable
    private static CodeEnvModel.UsedCodeEnvRef getCodeEnvRef(@Nonnull LambdaEndpointConfig endpointConfig, ServiceGenContext sc) throws IOException {
        switch (endpointConfig.type) {
            case STD_PREDICTION: 
            case STD_FORECAST: 
            case STD_CAUSAL_PREDICTION: 
            case STD_CLUSTERING: {
                PredictionEndpointConfig predictionEndpointConfig = (PredictionEndpointConfig)endpointConfig;
                File modelFolder = sc.getModelFolder(predictionEndpointConfig.modelId);
                File mlFlowModelVersionInfoFile = DKUFileUtils.getWithinFollowLink((File)modelFolder, (String[])new String[]{"mlflow_imported_model.json"});
                if (mlFlowModelVersionInfoFile.isFile()) {
                    MLFlowModelVersionInfo mlFlowModelVersionInfo = (MLFlowModelVersionInfo)JSON.parseFile((File)mlFlowModelVersionInfoFile, MLFlowModelVersionInfo.class);
                    return new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, mlFlowModelVersionInfo.pythonCodeEnvName);
                }
                File coreParamsFile = DKUFileUtils.getWithinFollowLink((File)modelFolder, (String[])new String[]{"core_params.json"});
                ResolvedCoreParams coreParams = (ResolvedCoreParams)JSON.parseFile((File)coreParamsFile, ResolvedCoreParams.class);
                if (null == coreParams.executionParams) {
                    return null;
                }
                return new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, coreParams.executionParams.envName);
            }
            case CUSTOM_PREDICTION: 
            case PY_FUNCTION: 
            case CUSTOM_R_PREDICTION: 
            case R_FUNCTION: {
                EndpointConfigWithCodeEnv endpointConfigWithCodeEnv = (EndpointConfigWithCodeEnv)endpointConfig;
                return endpointConfigWithCodeEnv.getCodeEnvRef();
            }
        }
        return null;
    }

    public File registerManagedEnv(CodeEnvModel.EnvLang envLang, File cacheBaseDir, File exportedEnvDir, File builtEnvDir, CodeEnvModel.EnvImportSpecificationMode specMode) throws Exception {
        boolean needsLink;
        Object versionToUse;
        String hash = new CodeEnvVersionChecker().getCodeEnvSpecHash(envLang, exportedEnvDir, specMode);
        logger.info((Object)("Hash of the env to import is " + hash));
        File hashCacheRoot = new File(cacheBaseDir, hash);
        if (hashCacheRoot.isDirectory()) {
            logger.info((Object)"Hash cache root exists");
            long version = DKUFileUtils.highestFileNumber((File)hashCacheRoot, (String)"v");
            if (version == -1L) {
                versionToUse = "v1";
                needsLink = true;
            } else if (!new File(hashCacheRoot, "v" + version + "/ready.txt").isFile()) {
                logger.warn((Object)("Version " + version + " does not have the ready marker, will register"));
                versionToUse = "v" + (version + 1L);
                needsLink = true;
            } else {
                versionToUse = "v" + version;
                needsLink = false;
            }
        } else {
            logger.info((Object)"No hash cache root");
            DKUFileUtils.mkdirs((File)hashCacheRoot);
            versionToUse = "v1";
            needsLink = true;
        }
        File targetVersionDir = new File(hashCacheRoot, (String)versionToUse);
        if (needsLink) {
            Files.deleteIfExists(targetVersionDir.toPath());
            DKUFileUtils.mkdirs((File)targetVersionDir);
            switch (envLang) {
                case PYTHON: {
                    CodeEnvImportUtils.registerPythonEnvInFolder((AuthCtx)DSSAuthCtx.newNone(), (File)targetVersionDir, (File)exportedEnvDir, (File)builtEnvDir, (CodeEnvModel.EnvImportSpecificationMode)CodeEnvModel.EnvImportSpecificationMode.ACTUAL);
                    break;
                }
                case R: {
                    CodeEnvImportUtils.registerREnvInFolder((AuthCtx)DSSAuthCtx.newNone(), (File)targetVersionDir, (File)exportedEnvDir, (File)builtEnvDir, (CodeEnvModel.EnvImportSpecificationMode)CodeEnvModel.EnvImportSpecificationMode.ACTUAL);
                }
            }
        }
        return targetVersionDir;
    }

    private File f(File f, String ... chunks) {
        return new File(f, StringUtils.join((Object[])chunks, (String)"/"));
    }
}

