/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.controllers;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.auth.AuthVerificationService;
import com.dataiku.lambda.controllers.LambdaControllerUtils;
import com.dataiku.lambda.controllers.RequestMetadata;
import com.dataiku.lambda.endpoints.functioncommon.FunctionEndpointHandlerBase;
import com.dataiku.lambda.endpoints.pyfunction.PyFunctionEndpointHandler;
import com.dataiku.lambda.model.api.DKUCustomHTTPResponse;
import com.dataiku.lambda.model.api.FunctionResponse;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class FunctionEndpointsController
extends LambdaAPIControllerBase {
    @Autowired
    private LambdaContext lambdaContext;
    @Autowired
    private ServicesService serviceService;
    @Autowired
    private AuthVerificationService authService;
    private static final Pattern HEADER_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.function.controller");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/public/api/v1/{serviceId}/{endpointId}/run"}, method={RequestMethod.POST, RequestMethod.GET})
    public void run(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String endpointId) throws Exception {
        try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + serviceId));
             ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("ep:" + endpointId));){
            MDC.put((String)"serviceId", (Object)serviceId);
            MDC.put((String)"endpointId", (Object)endpointId);
            JsonObject obj = new JsonObject();
            if ("POST".equals(req.getMethod())) {
                JsonObject requestBody = (JsonObject)this.getRequestBodyAsOrNull(req, JsonObject.class);
                if (null != requestBody) {
                    obj = requestBody;
                } else {
                    logger.debug((Object)"Empty body received, treating it as an empty json object");
                }
            } else {
                obj = LambdaControllerUtils.makeObjectFromReqParams(req.getParameterMap());
            }
            ServiceManager manager = this.serviceService.getServiceManagerCheck(serviceId);
            this.authService.checkAuth(serviceId, manager.getConfig(), req);
            QueryAPIKey apiKey = this.authService.getApiKeyForInternalCalls(serviceId, manager.getConfig(), req);
            boolean isRequestMetadataEnabled = this.lambdaContext.getMandatoryConfig().isRequestMetadataEnabled;
            RequestMetadata requestMetadata = RequestMetadata.extractFrom(req, isRequestMetadataEnabled);
            ServiceManager.RefcountedEndpoint re = manager.acquireEndpoint(endpointId, null);
            try {
                FunctionEndpointHandlerBase reh = (FunctionEndpointHandlerBase)re.getHandler();
                if (reh instanceof PyFunctionEndpointHandler && ((PyFunctionEndpointHandler)reh).hasCustomResponse()) {
                    FunctionResponse functionResponse = reh.runAndLog(obj, re, apiKey, requestMetadata);
                    DKUCustomHTTPResponse customFunctionResponse = (DKUCustomHTTPResponse)JSON.parse((JsonElement)functionResponse.response, DKUCustomHTTPResponse.class);
                    FunctionEndpointsController.setHeader(resp);
                    if (null != customFunctionResponse) {
                        this.writeCustomHTTPResponseToResponse(resp, customFunctionResponse);
                    } else {
                        resp.setStatus(204);
                    }
                } else {
                    this.writeJSON2(resp, reh.runAndLog(obj, re, apiKey, requestMetadata));
                }
            }
            finally {
                manager.releaseEndpoint(re);
            }
        }
    }

    public void writeCustomHTTPResponseToResponse(HttpServletResponse resp, DKUCustomHTTPResponse customHTTPResponse) throws IOException {
        logger.traceV("Writing status code %d to response", new Object[]{customHTTPResponse.code});
        resp.setStatus(customHTTPResponse.code);
        for (List header : customHTTPResponse.headers) {
            if (CollectionUtils.isEmpty((Collection)header)) {
                logger.debug((Object)"Ignoring buggy header with empty key and value");
                continue;
            }
            String key = (String)header.get(0);
            String value = header.size() > 1 ? (String)header.get(1) : "";
            logger.traceV("Writing header %s to response", new Object[]{key});
            if (!HEADER_NAME_PATTERN.matcher(key).matches()) {
                throw new IllegalArgumentException("Header name `" + key + "' is not valid");
            }
            resp.addHeader(key, value);
        }
        if (null != customHTTPResponse.body) {
            if (customHTTPResponse.isBase64) {
                byte[] decoded = Base64.getDecoder().decode(customHTTPResponse.body);
                logger.traceV("Writing binary body with length %d", new Object[]{decoded.length});
                resp.getOutputStream().write(decoded);
                resp.getOutputStream().flush();
            } else {
                logger.traceV("Writing text body `%s' with length %d", new Object[]{customHTTPResponse.body, customHTTPResponse.body.length()});
                resp.getWriter().write(customHTTPResponse.body);
                resp.getWriter().flush();
            }
        } else {
            logger.trace((Object)"Empty body");
        }
    }
}

