/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.pool;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.APINodeMetrics;
import com.dataiku.lambda.endpoints.EndpointUnavailableException;
import com.dataiku.lambda.endpoints.pool.IPipelinePool;
import com.dataiku.lambda.endpoints.pool.PoolCallbacks;
import com.dataiku.lambda.endpoints.pool.PoolablePipeline;
import com.dataiku.lambda.model.serverconfig.EndpointPoolConfig;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class PipelinePool<P extends PoolablePipeline>
implements IPipelinePool<P> {
    public static final String PIPELINES_IN_FLIGHT = "pipelinesInFlight";
    public static final String FREE_PIPELINES = "freePipelines";
    public static final String PIPELINES_DESTROYED = "pipelinesDestroyed";
    public static final String PIPELINES_CREATED = "pipelinesCreated";
    protected boolean destroying = false;
    protected int inFlight;
    protected int baking;
    protected final int ceil;
    protected final int floor;
    protected final int cruise;
    protected final int queue;
    protected final int timeout;
    private final ArrayDeque<Thread> pending;
    private final List<P> freePipelines;
    private final PoolCallbacks<P> callbacks;
    private final String serviceId;
    private final String endpointId;
    private final String loggerSuffix;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.pipelinepool");

    public PipelinePool(PoolCallbacks<P> callbacks, String serviceId, String endpointId, EndpointPoolConfig poolConfig) {
        this.callbacks = callbacks;
        this.serviceId = serviceId;
        this.endpointId = endpointId;
        this.ceil = poolConfig.ceil;
        this.floor = poolConfig.floor;
        this.cruise = poolConfig.cruise;
        this.queue = poolConfig.queue;
        this.timeout = poolConfig.timeout;
        Preconditions.checkArgument((this.ceil > 0 ? 1 : 0) != 0, (Object)"Max. pipelines (ceil) should be >= 1");
        Preconditions.checkArgument((this.floor > 0 && this.floor <= this.ceil ? 1 : 0) != 0, (Object)("Min. pipelines (floor) should be >= 1 and <= " + this.ceil));
        Preconditions.checkArgument((this.cruise >= this.floor && this.cruise <= this.ceil ? 1 : 0) != 0, (Object)("Default pipelines (cruise) should be >= " + this.floor + " and <= " + this.ceil));
        Preconditions.checkArgument((this.queue >= 0 ? 1 : 0) != 0, (Object)"Request queue should be >= 0");
        Preconditions.checkArgument((this.timeout > 0 ? 1 : 0) != 0, (Object)"Request timeout should be > 0");
        logger.infoV("Initializing pipelines pool for %s/%s: floor=%d cruise=%d ceil=%d queue=%d timeout=%d", new Object[]{serviceId, endpointId, this.floor, this.cruise, this.ceil, this.queue, this.timeout});
        this.pending = new ArrayDeque(this.queue);
        this.freePipelines = new ArrayList<P>(this.ceil);
        this.inFlight = 0;
        this.baking = 0;
        this.loggerSuffix = " (" + serviceId + "/" + endpointId + ")";
    }

    @Override
    public final void init() throws Exception {
        int i;
        ArrayList<P> pipelines = new ArrayList<P>(this.floor);
        for (i = 0; i < this.floor; ++i) {
            pipelines.add(i, this.acquire());
        }
        for (i = 0; i < this.floor; ++i) {
            this.release((PoolablePipeline)pipelines.get(i));
        }
    }

    @Override
    public synchronized void destroy() {
        logger.info((Object)("Destroy pool" + this.loggerSuffix));
        assert (this.inFlight == 0);
        this.destroying = true;
        while (!this.freePipelines.isEmpty()) {
            this.destroy((PoolablePipeline)this.freePipelines.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(P pipeline) {
        logger.info((Object)("Destroying pipeline" + this.loggerSuffix));
        APINodeMetrics.endpointMeter(this.serviceId, this.endpointId, PIPELINES_DESTROYED).mark();
        pipeline.destroy();
        PipelinePool pipelinePool = this;
        synchronized (pipelinePool) {
            if (this.freePipelines.contains(pipeline)) {
                this.freePipelines.remove(pipeline);
                APINodeMetrics.endpointCounter(this.serviceId, this.endpointId, FREE_PIPELINES).dec();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyOnError(P pipeline) {
        PipelinePool pipelinePool = this;
        synchronized (pipelinePool) {
            --this.inFlight;
            this.notifyAll();
        }
        APINodeMetrics.endpointCounter(this.serviceId, this.endpointId, PIPELINES_IN_FLIGHT).dec();
        this.destroy(pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(P pipeline) {
        APINodeMetrics.endpointCounter(this.serviceId, this.endpointId, PIPELINES_IN_FLIGHT).dec();
        boolean shutdown = this.destroying;
        PipelinePool pipelinePool = this;
        synchronized (pipelinePool) {
            int totalPipelines = this.freePipelines.size() + this.inFlight + this.baking;
            boolean bl = this.pending.isEmpty() && totalPipelines > this.cruise;
            --this.inFlight;
            int newFreePipelines = this.freePipelines.size() + 1;
            logger.debugV("releasing pipeline " + this.loggerSuffix + " pending=%d inFlight=%d free=%d baking=%d cruise=%d -> shutdown= %s", new Object[]{this.pending.size(), this.inFlight, newFreePipelines, this.baking, this.cruise, shutdown |= bl});
            if (!shutdown) {
                APINodeMetrics.endpointCounter(this.serviceId, this.endpointId, FREE_PIPELINES).inc();
                this.freePipelines.add(pipeline);
            }
            this.notifyAll();
        }
        if (shutdown) {
            this.destroy(pipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P acquire() throws Exception {
        P pipeline;
        PipelinePool pipelinePool = this;
        synchronized (pipelinePool) {
            this.checkDestroying();
            logger.debugV("acquiring pipeline " + this.loggerSuffix + " pending=%d inFlight=%d free=%d baking=%d", new Object[]{this.pending.size(), this.inFlight, this.freePipelines.size(), this.baking});
            if (!this.canAcquire()) {
                if (this.pending.size() >= this.queue) {
                    throw new EndpointUnavailableException("Request queue is full");
                }
                long queuedUntil = System.currentTimeMillis() + (long)this.timeout;
                this.pending.add(Thread.currentThread());
                try {
                    while (!this.canAcquire() || this.pending.peek() != Thread.currentThread()) {
                        if (System.currentTimeMillis() > queuedUntil) {
                            throw new EndpointUnavailableException("Request timed out");
                        }
                        try {
                            this.wait(Math.max(1L, queuedUntil - System.currentTimeMillis()));
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                        this.checkDestroying();
                    }
                }
                finally {
                    this.pending.remove(Thread.currentThread());
                }
            }
            if (this.freePipelines.size() > 0) {
                APINodeMetrics.endpointCounter(this.serviceId, this.endpointId, FREE_PIPELINES).dec();
                APINodeMetrics.endpointCounter(this.serviceId, this.endpointId, PIPELINES_IN_FLIGHT).inc();
                ++this.inFlight;
                return (P)((PoolablePipeline)this.freePipelines.remove(0));
            }
            ++this.baking;
        }
        logger.info((Object)("Creating a pipeline " + this.loggerSuffix));
        try {
            pipeline = this.callbacks.instantiatePipeline();
        }
        catch (Throwable t) {
            PipelinePool pipelinePool2 = this;
            synchronized (pipelinePool2) {
                --this.baking;
                this.notifyAll();
            }
            throw t;
        }
        PipelinePool pipelinePool3 = this;
        synchronized (pipelinePool3) {
            --this.baking;
            ++this.inFlight;
        }
        logger.info((Object)("Pipeline created " + this.loggerSuffix));
        APINodeMetrics.endpointMeter(this.serviceId, this.endpointId, PIPELINES_CREATED).mark();
        APINodeMetrics.endpointCounter(this.serviceId, this.endpointId, PIPELINES_IN_FLIGHT).inc();
        return pipeline;
    }

    private void checkDestroying() {
        if (this.destroying) {
            throw new EndpointUnavailableException("Endpoint is shutting down");
        }
    }

    private boolean canAcquire() {
        return this.freePipelines.size() > 0 || this.inFlight + this.baking < this.ceil;
    }
}

