/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.util.Objects;
import javax.measure.UnitConverter;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.ExpConverter;
import tech.units.indriya.internal.function.calc.Calculator;
import tech.uom.lib.common.function.ValueSupplier;

public final class LogConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private static final long serialVersionUID = -7584688290961460870L;
    private final double base;
    private final double logOfBase;

    public LogConverter(double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
    }

    public double getBase() {
        return this.base;
    }

    public boolean isIdentity() {
        return false;
    }

    @Override
    protected boolean canReduceWith(AbstractConverter that) {
        if (that instanceof ExpConverter) {
            return ((ExpConverter)that).getBase() == this.base;
        }
        return false;
    }

    @Override
    protected AbstractConverter reduce(AbstractConverter that) {
        return AbstractConverter.IDENTITY;
    }

    @Override
    public AbstractConverter inverseWhenNotIdentity() {
        return new ExpConverter(this.base);
    }

    @Override
    public final String transformationLiteral() {
        if (this.base == Math.E) {
            return "x -> ln(x)";
        }
        return String.format("x -> log(base=%s, x)", this.base);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LogConverter) {
            LogConverter that = (LogConverter)obj;
            return Objects.equals(this.base, that.base);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base);
    }

    @Override
    protected Number convertWhenNotIdentity(Number value) {
        return Calculator.of(value).log().divide(this.logOfBase).peek();
    }

    public boolean isLinear() {
        return false;
    }

    public String getValue() {
        return this.toString();
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof ValueSupplier) {
            return this.getValue().compareTo(String.valueOf(((ValueSupplier)o).getValue()));
        }
        return -1;
    }
}

