/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.util.ExpressionUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFilterUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParquetFilterUtils.class);

    private ParquetFilterUtils() {
    }

    public static Optional<FilterPredicate> toParquetFilter(MessageType messageType, Predicate predicate) {
        Map<Column, ParquetField> map = ParquetFilterUtils.extractParquetFields(messageType);
        return ParquetFilterUtils.convertToParquetFilter(map, predicate);
    }

    private static Map<Column, ParquetField> extractParquetFields(MessageType messageType) {
        HashMap<Column, ParquetField> hashMap = new HashMap<Column, ParquetField>();
        for (ColumnDescriptor columnDescriptor : messageType.getColumns()) {
            String[] stringArray = columnDescriptor.getPath();
            Type type = messageType.getType(stringArray);
            if (type.getRepetition() == Type.Repetition.REPEATED) continue;
            assert (type.isPrimitive()) : "Only primitive types are expected from .getColumns()";
            PrimitiveType primitiveType = type.asPrimitiveType();
            hashMap.put(new Column(stringArray), ParquetField.of(type.getLogicalTypeAnnotation(), primitiveType));
        }
        return hashMap;
    }

    private static boolean canUseLiteral(Literal literal, PrimitiveType primitiveType) {
        DataType dataType = literal.getDataType();
        LogicalTypeAnnotation logicalTypeAnnotation = primitiveType.getLogicalTypeAnnotation();
        switch (primitiveType.getPrimitiveTypeName()) {
            case BOOLEAN: {
                return dataType instanceof BooleanType;
            }
            case INT32: {
                if (!ParquetFilterUtils.isInteger(literal)) {
                    return false;
                }
                return logicalTypeAnnotation == null || logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation).getBitWidth() <= 32 || logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation;
            }
            case INT64: {
                if (!ParquetFilterUtils.isLong(literal)) {
                    return false;
                }
                return logicalTypeAnnotation == null || logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation).getBitWidth() <= 64;
            }
            case FLOAT: {
                return ParquetFilterUtils.isFloat(literal);
            }
            case DOUBLE: {
                return ParquetFilterUtils.isDouble(literal);
            }
            case BINARY: {
                return ParquetFilterUtils.isBinary(literal) && (logicalTypeAnnotation == null || logicalTypeAnnotation instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation);
            }
        }
        return false;
    }

    private static Optional<FilterPredicate> convertToParquetFilter(Map<Column, ParquetField> map, Predicate predicate) {
        String string;
        switch (string = predicate.getName().toLowerCase(Locale.ROOT)) {
            case "=": 
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                return ParquetFilterUtils.convertComparatorToParquetFilter(map, predicate);
            }
            case "not": {
                return ParquetFilterUtils.convertNotToParquetFilter(map, predicate);
            }
            case "and": {
                return ParquetFilterUtils.convertAndToParquetFilter(map, predicate);
            }
            case "or": {
                return ParquetFilterUtils.convertOrToParquetFilter(map, predicate);
            }
            case "is_null": {
                return ParquetFilterUtils.convertIsNullIsNotNull(map, predicate, false);
            }
            case "is_not_null": {
                return ParquetFilterUtils.convertIsNullIsNotNull(map, predicate, true);
            }
        }
        return ParquetFilterUtils.visitUnsupported(predicate, string + " is not a supported predicate.");
    }

    private static Optional<FilterPredicate> convertComparatorToParquetFilter(Map<Column, ParquetField> map, Predicate predicate) {
        Expression expression;
        Expression expression2 = ExpressionUtils.getLeft((Expression)predicate);
        Expression expression3 = ExpressionUtils.getRight((Expression)predicate);
        if (expression2 instanceof Literal && expression3 instanceof Column) {
            expression = expression2;
            expression2 = expression3;
            expression3 = expression;
        }
        if (!(expression2 instanceof Column) || !(expression3 instanceof Literal)) {
            return ParquetFilterUtils.visitUnsupported(predicate, "Comparison predicate must have a column and a literal.");
        }
        expression = (Column)expression2;
        Literal literal = (Literal)expression3;
        ParquetField parquetField = map.get(expression);
        if (parquetField == null) {
            return ParquetFilterUtils.visitUnsupported(predicate, "Column used in predicate does not exist in the parquet file.");
        }
        if (literal.getValue() == null) {
            return ParquetFilterUtils.visitUnsupported(predicate, "Literal value is null for a comparator operator. Comparator is not supported for null values as the Parquet comparator is not null safe");
        }
        if (!ParquetFilterUtils.canUseLiteral(literal, parquetField.primitiveType)) {
            return ParquetFilterUtils.visitUnsupported(predicate, "Literal type is not compatible with the column type: " + literal.getDataType());
        }
        PrimitiveType primitiveType = parquetField.primitiveType;
        String string = ColumnPath.get((String[])expression.getNames()).toDotString();
        String string2 = predicate.getName();
        switch (primitiveType.getPrimitiveTypeName()) {
            case BOOLEAN: {
                Operators.BooleanColumn booleanColumn = FilterApi.booleanColumn((String)string);
                if (!"=".equals(string2)) break;
                return Optional.of(FilterApi.eq((Operators.Column)booleanColumn, (Comparable)Boolean.valueOf(ParquetFilterUtils.getBoolean(literal))));
            }
            case INT32: {
                Operators.IntColumn intColumn = FilterApi.intColumn((String)string);
                switch (string2) {
                    case "=": {
                        return Optional.of(FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(ParquetFilterUtils.getInt(literal))));
                    }
                    case "<": {
                        return Optional.of(FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(ParquetFilterUtils.getInt(literal))));
                    }
                    case "<=": {
                        return Optional.of(FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(ParquetFilterUtils.getInt(literal))));
                    }
                    case ">": {
                        return Optional.of(FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(ParquetFilterUtils.getInt(literal))));
                    }
                    case ">=": {
                        return Optional.of(FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(ParquetFilterUtils.getInt(literal))));
                    }
                }
                break;
            }
            case INT64: {
                Operators.LongColumn longColumn = FilterApi.longColumn((String)string);
                switch (string2) {
                    case "=": {
                        return Optional.of(FilterApi.eq((Operators.Column)longColumn, (Comparable)Long.valueOf(ParquetFilterUtils.getLong(literal))));
                    }
                    case "<": {
                        return Optional.of(FilterApi.lt((Operators.Column)longColumn, (Comparable)Long.valueOf(ParquetFilterUtils.getLong(literal))));
                    }
                    case "<=": {
                        return Optional.of(FilterApi.ltEq((Operators.Column)longColumn, (Comparable)Long.valueOf(ParquetFilterUtils.getLong(literal))));
                    }
                    case ">": {
                        return Optional.of(FilterApi.gt((Operators.Column)longColumn, (Comparable)Long.valueOf(ParquetFilterUtils.getLong(literal))));
                    }
                    case ">=": {
                        return Optional.of(FilterApi.gtEq((Operators.Column)longColumn, (Comparable)Long.valueOf(ParquetFilterUtils.getLong(literal))));
                    }
                }
                break;
            }
            case FLOAT: {
                Operators.FloatColumn floatColumn = FilterApi.floatColumn((String)string);
                switch (string2) {
                    case "=": {
                        return Optional.of(FilterApi.eq((Operators.Column)floatColumn, (Comparable)Float.valueOf(ParquetFilterUtils.getFloat(literal))));
                    }
                    case "<": {
                        return Optional.of(FilterApi.lt((Operators.Column)floatColumn, (Comparable)Float.valueOf(ParquetFilterUtils.getFloat(literal))));
                    }
                    case "<=": {
                        return Optional.of(FilterApi.ltEq((Operators.Column)floatColumn, (Comparable)Float.valueOf(ParquetFilterUtils.getFloat(literal))));
                    }
                    case ">": {
                        return Optional.of(FilterApi.gt((Operators.Column)floatColumn, (Comparable)Float.valueOf(ParquetFilterUtils.getFloat(literal))));
                    }
                    case ">=": {
                        return Optional.of(FilterApi.gtEq((Operators.Column)floatColumn, (Comparable)Float.valueOf(ParquetFilterUtils.getFloat(literal))));
                    }
                }
                break;
            }
            case DOUBLE: {
                Operators.DoubleColumn doubleColumn = FilterApi.doubleColumn((String)string);
                switch (string2) {
                    case "=": {
                        return Optional.of(FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(ParquetFilterUtils.getDouble(literal))));
                    }
                    case "<": {
                        return Optional.of(FilterApi.lt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(ParquetFilterUtils.getDouble(literal))));
                    }
                    case "<=": {
                        return Optional.of(FilterApi.ltEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(ParquetFilterUtils.getDouble(literal))));
                    }
                    case ">": {
                        return Optional.of(FilterApi.gt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(ParquetFilterUtils.getDouble(literal))));
                    }
                    case ">=": {
                        return Optional.of(FilterApi.gtEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(ParquetFilterUtils.getDouble(literal))));
                    }
                }
                break;
            }
            case BINARY: {
                Operators.BinaryColumn binaryColumn = FilterApi.binaryColumn((String)string);
                Binary binary = ParquetFilterUtils.getBinary(literal);
                switch (string2) {
                    case "=": {
                        return Optional.of(FilterApi.eq((Operators.Column)binaryColumn, (Comparable)binary));
                    }
                    case "<": {
                        return Optional.of(FilterApi.lt((Operators.Column)binaryColumn, (Comparable)binary));
                    }
                    case "<=": {
                        return Optional.of(FilterApi.ltEq((Operators.Column)binaryColumn, (Comparable)binary));
                    }
                    case ">": {
                        return Optional.of(FilterApi.gt((Operators.Column)binaryColumn, (Comparable)binary));
                    }
                    case ">=": {
                        return Optional.of(FilterApi.gtEq((Operators.Column)binaryColumn, (Comparable)binary));
                    }
                }
            }
        }
        return ParquetFilterUtils.visitUnsupported(predicate, String.format("Unsupported column type (%s) with comparator (%s): ", primitiveType, string2));
    }

    private static Optional<FilterPredicate> convertNotToParquetFilter(Map<Column, ParquetField> map, Predicate predicate) {
        Optional<FilterPredicate> optional = ParquetFilterUtils.convertToParquetFilter(map, (Predicate)ExpressionUtils.getUnaryChild((Expression)predicate));
        return optional.map(FilterApi::not);
    }

    private static Optional<FilterPredicate> convertOrToParquetFilter(Map<Column, ParquetField> map, Predicate predicate) {
        Optional<FilterPredicate> optional = ParquetFilterUtils.convertToParquetFilter(map, ExpressionUtils.asPredicate((Expression)ExpressionUtils.getLeft((Expression)predicate)));
        Optional<FilterPredicate> optional2 = ParquetFilterUtils.convertToParquetFilter(map, ExpressionUtils.asPredicate((Expression)ExpressionUtils.getRight((Expression)predicate)));
        if (optional.isPresent() && optional2.isPresent()) {
            return Optional.of(FilterApi.or((FilterPredicate)optional.get(), (FilterPredicate)optional2.get()));
        }
        return Optional.empty();
    }

    private static Optional<FilterPredicate> convertAndToParquetFilter(Map<Column, ParquetField> map, Predicate predicate) {
        Optional<FilterPredicate> optional = ParquetFilterUtils.convertToParquetFilter(map, ExpressionUtils.asPredicate((Expression)ExpressionUtils.getLeft((Expression)predicate)));
        Optional<FilterPredicate> optional2 = ParquetFilterUtils.convertToParquetFilter(map, ExpressionUtils.asPredicate((Expression)ExpressionUtils.getRight((Expression)predicate)));
        if (optional.isPresent() && optional2.isPresent()) {
            return Optional.of(FilterApi.and((FilterPredicate)optional.get(), (FilterPredicate)optional2.get()));
        }
        if (optional.isPresent()) {
            return optional;
        }
        return optional2;
    }

    private static Optional<FilterPredicate> convertIsNullIsNotNull(Map<Column, ParquetField> map, Predicate predicate, boolean bl) {
        Expression expression = ExpressionUtils.getUnaryChild((Expression)predicate);
        if (!(expression instanceof Column)) {
            return ParquetFilterUtils.visitUnsupported(predicate, "IS NULL predicate must have a column input.");
        }
        Column column = (Column)expression;
        ParquetField parquetField = map.get(column);
        if (parquetField == null) {
            return ParquetFilterUtils.visitUnsupported(predicate, "Column used in predicate does not exist in the parquet file.");
        }
        String string = ColumnPath.get((String[])column.getNames()).toDotString();
        switch (parquetField.primitiveType.getPrimitiveTypeName()) {
            case BOOLEAN: {
                return ParquetFilterUtils.createIsNullOrIsNotNullPredicate(FilterApi.booleanColumn((String)string), bl);
            }
            case INT32: {
                return ParquetFilterUtils.createIsNullOrIsNotNullPredicate(FilterApi.intColumn((String)string), bl);
            }
            case INT64: {
                return ParquetFilterUtils.createIsNullOrIsNotNullPredicate(FilterApi.longColumn((String)string), bl);
            }
            case FLOAT: {
                return ParquetFilterUtils.createIsNullOrIsNotNullPredicate(FilterApi.floatColumn((String)string), bl);
            }
            case DOUBLE: {
                return ParquetFilterUtils.createIsNullOrIsNotNullPredicate(FilterApi.doubleColumn((String)string), bl);
            }
            case BINARY: {
                return ParquetFilterUtils.createIsNullOrIsNotNullPredicate(FilterApi.binaryColumn((String)string), bl);
            }
        }
        return ParquetFilterUtils.visitUnsupported(predicate, "Unsupported column type: " + parquetField.primitiveType);
    }

    private static <T extends Comparable<T>, C extends Operators.Column<T>> Optional<FilterPredicate> createIsNullOrIsNotNullPredicate(C c, boolean bl) {
        return Optional.of(bl ? FilterApi.notEq(c, null) : FilterApi.eq(c, null));
    }

    private static Optional<FilterPredicate> visitUnsupported(Predicate predicate, String string) {
        logger.info("Unsupported predicate: {}. Reason: {}", (Object)predicate, (Object)string);
        return Optional.empty();
    }

    private static boolean isBoolean(Literal literal) {
        return literal.getDataType() instanceof BooleanType;
    }

    private static boolean getBoolean(Literal literal) {
        Preconditions.checkArgument((boolean)ParquetFilterUtils.isBoolean(literal), (String)"Literal is not a boolean: %s", (Object[])new Object[]{literal});
        return (Boolean)literal.getValue();
    }

    private static boolean isInteger(Literal literal) {
        DataType dataType = literal.getDataType();
        if (dataType instanceof LongType) {
            return (long)((Long)literal.getValue()).intValue() == (Long)literal.getValue();
        }
        return dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof DateType;
    }

    private static int getInt(Literal literal) {
        Preconditions.checkArgument((boolean)ParquetFilterUtils.isInteger(literal), (String)"Literal is not an integer: %s", (Object[])new Object[]{literal});
        DataType dataType = literal.getDataType();
        if (dataType instanceof LongType) {
            return ((Long)literal.getValue()).intValue();
        }
        return ((Number)literal.getValue()).intValue();
    }

    private static boolean isLong(Literal literal) {
        DataType dataType = literal.getDataType();
        return dataType instanceof LongType || dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof DateType;
    }

    private static long getLong(Literal literal) {
        Preconditions.checkArgument((boolean)ParquetFilterUtils.isLong(literal), (String)"Literal is not a long: %s", (Object[])new Object[]{literal});
        DataType dataType = literal.getDataType();
        if (dataType instanceof LongType) {
            return (Long)literal.getValue();
        }
        return ((Number)literal.getValue()).longValue();
    }

    private static boolean isFloat(Literal literal) {
        return literal.getDataType() instanceof FloatType;
    }

    private static float getFloat(Literal literal) {
        Preconditions.checkArgument((boolean)ParquetFilterUtils.isFloat(literal), (String)"Literal is not a float: %s", (Object[])new Object[]{literal});
        return ((Number)literal.getValue()).floatValue();
    }

    private static boolean isDouble(Literal literal) {
        return literal.getDataType() instanceof DoubleType;
    }

    private static double getDouble(Literal literal) {
        Preconditions.checkArgument((boolean)ParquetFilterUtils.isDouble(literal), (String)"Literal is not a double: %s", (Object[])new Object[]{literal});
        return ((Number)literal.getValue()).doubleValue();
    }

    private static boolean isBinary(Literal literal) {
        DataType dataType = literal.getDataType();
        return dataType instanceof BinaryType || dataType instanceof StringType;
    }

    private static Binary getBinary(Literal literal) {
        Preconditions.checkArgument((boolean)ParquetFilterUtils.isBinary(literal), (String)"Literal is not a binary: %s", (Object[])new Object[]{literal});
        DataType dataType = literal.getDataType();
        if (dataType instanceof BinaryType) {
            return Binary.fromConstantByteArray((byte[])((byte[])literal.getValue()));
        }
        return Binary.fromString((String)((String)literal.getValue()));
    }

    private static class ParquetField {
        final LogicalTypeAnnotation logicalType;
        final PrimitiveType primitiveType;

        private ParquetField(LogicalTypeAnnotation logicalTypeAnnotation, PrimitiveType primitiveType) {
            this.logicalType = logicalTypeAnnotation;
            this.primitiveType = primitiveType;
        }

        static ParquetField of(LogicalTypeAnnotation logicalTypeAnnotation, PrimitiveType primitiveType) {
            return new ParquetField(logicalTypeAnnotation, primitiveType);
        }
    }
}

