/*
 * Decompiled with CFR 0.152.
 */
package dip.clean;

import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.plugin.BackendClient;
import com.dataiku.dip.plugin.CustomRunnable;
import com.dataiku.dip.plugin.ProgressTracker;
import com.dataiku.dip.plugin.ResultTableDTO;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.timelines.ProjectTimelineBehavior;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CleanDbs
implements CustomRunnable {
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private String projectKey;
    private boolean deleteJobs;
    private boolean deleteChecks;
    private boolean deleteMetrics;
    private boolean deleteScenarios;
    private boolean deleteTimelines;
    private int maxAge;
    @Autowired
    private ReadWriteJobsInternalDB jobsDB;
    @Autowired
    private TimelinesInternalDB timelinesDB;
    private static Logger logger = Logger.getLogger((String)"dku.clean.dbs");

    public void init(String projectKey, JsonObject config, JsonObject pluginConfig, ProgressTracker progressTracker, BackendClient backendClient) throws Exception {
        this.projectKey = projectKey;
        if (config.get("allProjects").getAsBoolean()) {
            this.projectKey = null;
        }
        this.deleteJobs = config.get("jobs").getAsBoolean();
        this.deleteChecks = config.get("checks").getAsBoolean();
        this.deleteMetrics = config.get("metrics").getAsBoolean();
        this.deleteScenarios = config.get("scenarios").getAsBoolean();
        this.deleteTimelines = config.get("timelines").getAsBoolean();
        this.maxAge = config.get("age").getAsInt();
        SpringUtils.getInstance().autowire((Object)this);
    }

    public byte[] run() throws Exception {
        long maxTimestamp = DateTime.now().minusDays(this.maxAge).getMillis();
        ArrayList deletions = Lists.newArrayList();
        try (DSSDBConnection conn = this.jobsDB.acquireConnection();){
            if (this.deleteJobs) {
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("JOB", "JOB_PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "jobs"));
            }
            if (this.deleteChecks) {
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("CHECKS_LAST", "PROJECT_KEY").where(EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last checks"));
                deletions.add(this.executeOneDeleteStatement(conn, DeleteQueryBuilder.deleteFrom((SQLUtils.SQLTable)this.jobsDB.resolveTable("CHECKS_HISTORY")).where(EBF.col("SESSION_INDEX").in((Object)this.buildSessionIndicesSqlQueryExpr("CHECKS_SESSIONS", maxTimestamp))).toSql(this.jobsDB.getDialect()), "checks history"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("CHECKS_SESSIONS", "PROJECT_KEY").where(EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "checks sessions"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_PARTITION_LAST", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last partitions data quality"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_PARTITION_HISTORY", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "data quality partitions history"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_OBJECT_LAST", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last data quality objects"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_OBJECT_HISTORY", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "data quality objects history"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_PROJECT_LAST", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last data quality project"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_PROJECT_HISTORY", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "data quality project history"));
            }
            if (this.deleteMetrics) {
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("METRICS_LAST", "PROJECT_KEY").where(EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last metrics"));
                deletions.add(this.executeOneDeleteStatement(conn, DeleteQueryBuilder.deleteFrom((SQLUtils.SQLTable)this.jobsDB.resolveTable("METRICS_HISTORY")).where(EBF.col("SESSION_INDEX").in((Object)this.buildSessionIndicesSqlQueryExpr("METRICS_SESSIONS", maxTimestamp))).toSql(this.jobsDB.getDialect()), "metrics history"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("METRICS_SESSIONS", "PROJECT_KEY").where(EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "metrics sessions"));
            }
            if (this.deleteScenarios) {
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("SCENARIO_RUNS", "SCENARIO_PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "scenario runs"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("STEP_RUNS", "SCENARIO_PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "scenario steps"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("TRIGGER_FIRES", "SCENARIO_PROJECT_KEY").where(EBF.col("TIME_TRIGGER").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "triggers"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("FLOW_OBJECT_ACTION", "PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last object changes"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("FLOW_OBJECT_ACTION_HISTORY", "PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "object changes history"));
            }
        }
        if (this.deleteTimelines) {
            List timelineProjectKeysToClear;
            if (this.projectKey == null) {
                TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
                try (Transaction t = transactionService.beginRead();){
                    timelineProjectKeysToClear = ((ProjectsService)SpringUtils.getBean(ProjectsService.class)).listKeys();
                }
            } else {
                timelineProjectKeysToClear = Lists.newArrayList((Object[])new String[]{this.projectKey});
            }
            for (String pkey : timelineProjectKeysToClear) {
                logger.info((Object)("Cleaning timeline for project " + pkey));
                ProjectTimelineBehavior behavior = this.timelinesDB.getDao(pkey);
                try (DSSDBConnection conn = this.timelinesDB.acquireConnection(pkey);){
                    deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder(behavior.getResolvedTable(), "PROJECT_KEY", pkey).where(EBF.col("ITEM_TIME").lt((Object)maxTimestamp)).toSql(behavior.getDialect()), "timeline (" + pkey + ")"));
                }
            }
        }
        List<ResultTableDTO.ResultTableColumnDTO> resultTableDTOColumns = Arrays.asList(new ResultTableDTO.ResultTableColumnDTO("Deleted", "STRING"), new ResultTableDTO.ResultTableColumnDTO("Count", "STRING"));
        ArrayList<List<String>> resultTableDTOData = new ArrayList<List<String>>();
        for (ReportElement deletion : deletions) {
            resultTableDTOData.add(Arrays.asList(deletion.name, String.valueOf(deletion.deleted)));
        }
        return JSON.json((Object)new ResultTableDTO("Clear internal database", resultTableDTOColumns, resultTableDTOData)).getBytes(StandardCharsets.UTF_8);
    }

    private ExpressionBuilder buildSessionIndicesSqlQueryExpr(String sessionsTable, long maxTimestamp) {
        SelectQueryBuilder checkSessionIndices = new SelectQueryBuilder();
        checkSessionIndices.from(this.jobsDB.resolveTable(sessionsTable), sessionsTable);
        checkSessionIndices.select("SESSION_INDEX");
        if (this.projectKey != null) {
            checkSessionIndices.where(new ExpressionBuilder[]{EBF.col("PROJECT_KEY").eq((Object)this.projectKey)});
        }
        checkSessionIndices.where(new ExpressionBuilder[]{EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)});
        return EBF.expr(checkSessionIndices.toSQL(this.jobsDB.getDialect()));
    }

    private DeleteQueryBuilder createDeleteQueryBuilder(SQLUtils.SQLTable table, String projectKeyColumnName, String projectKeyValue) {
        DeleteQueryBuilder deleteQueryBuilder = DeleteQueryBuilder.deleteFrom((SQLUtils.SQLTable)table);
        if (projectKeyValue != null) {
            deleteQueryBuilder.where(EBF.col(projectKeyColumnName).nullUnsafeEq((Object)projectKeyValue));
        }
        return deleteQueryBuilder;
    }

    private DeleteQueryBuilder createDeleteQueryBuilder(String tableName, String projectKeyColumnName) {
        return this.createDeleteQueryBuilder(this.jobsDB.resolveTable(tableName), projectKeyColumnName, this.projectKey);
    }

    public void abort() {
    }

    private ReportElement executeOneDeleteStatement(DSSDBConnection conn, String sql, String name) throws SQLException {
        try (Statement st = conn.createStatement();){
            logger.info((Object)("Starting cleanup statement " + sql));
            int deleted = st.executeUpdate(sql);
            logger.info((Object)("Cleanup statement done, deleted=" + deleted));
            conn.commit();
            ReportElement reportElement = new ReportElement(name, deleted);
            return reportElement;
        }
    }

    private class ReportElement {
        final String name;
        final int deleted;

        ReportElement(String name, int deleted) {
            this.name = name;
            this.deleted = deleted;
        }
    }
}

