/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.protocol;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.http.HttpException;
import net.snowflake.ingest.internal.apache.http.HttpRequest;
import net.snowflake.ingest.internal.apache.http.HttpRequestInterceptor;
import net.snowflake.ingest.internal.apache.http.annotation.Contract;
import net.snowflake.ingest.internal.apache.http.annotation.ThreadingBehavior;
import net.snowflake.ingest.internal.apache.http.params.HttpParams;
import net.snowflake.ingest.internal.apache.http.protocol.HttpContext;
import net.snowflake.ingest.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s2 = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s2 = (String)params.getParameter("http.useragent");
            }
            if (s2 == null) {
                s2 = this.userAgent;
            }
            if (s2 != null) {
                request.addHeader("User-Agent", s2);
            }
        }
    }
}

