/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.client;

import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.HttpClient;
import com.dataiku.dss.shadelib.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.conn.ClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import com.dataiku.hproxy.client.HProxyException;
import com.dataiku.hproxy.model.JsonifiableError;
import com.dataiku.hproxy.model.PingResponse;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

abstract class HProxyClientBase {
    private final String secretKey;
    protected Logger logger;
    private PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
    private HttpClient client;
    private String serverURL;

    protected HProxyClientBase(String serverURL, String secretKey) {
        this.logger = Logger.getLogger(this.getClass());
        this.serverURL = serverURL;
        this.secretKey = secretKey;
        this.connectionManager.setMaxTotal(100);
        this.connectionManager.setDefaultMaxPerRoute(50);
        this.client = new DefaultHttpClient((ClientConnectionManager)this.connectionManager);
    }

    protected void call(String cmd, Map<String, Object> parameters) throws IOException, HProxyException {
        this.call(cmd, parameters, Object.class);
    }

    protected <T> T call(String cmd, Map<String, Object> parameters, Class<T> returnType) throws IOException, HProxyException {
        if (this.logger.isDebugEnabled()) {
            // empty if block
        }
        try {
            String body;
            HttpResponse forwardResp;
            Object responseObject = null;
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            Gson gson = new Gson();
            for (Map.Entry<String, Object> param : parameters.entrySet()) {
                Object val = param.getValue();
                String serialized = gson.toJson(val);
                pairs.add(new BasicNameValuePair(param.getKey(), serialized));
            }
            pairs.add(new BasicNameValuePair("__shared_secret__", this.secretKey));
            HttpPost post = new HttpPost(this.serverURL + "/" + cmd);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "utf8"));
            try {
                forwardResp = this.client.execute((HttpUriRequest)post);
                body = IOUtils.toString((InputStream)forwardResp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IllegalStateException e) {
                this.logger.warn((Object)"Connection problem", (Throwable)e);
                throw new IOException("Unable to connect to the HProxy server", e);
            }
            catch (IOException e) {
                this.logger.warn((Object)"Connection problem", (Throwable)e);
                throw new IOException("Unable to connect to the HProxy server", e);
            }
            int code = forwardResp.getStatusLine().getStatusCode();
            if (code == 200) {
                responseObject = gson.fromJson(body, returnType);
                if (responseObject == null) {
                    this.logger.warn((Object)"Call returned null");
                } else if (this.logger.isDebugEnabled()) {
                    // empty if block
                }
                Object object = responseObject;
                return (T)object;
            }
            if (code == 403) {
                throw new HProxyException("Shared secret refused by the HProxy server");
            }
            try {
                JsonifiableError responseError = (JsonifiableError)gson.fromJson(body, JsonifiableError.class);
                HProxyException exception = new HProxyException(responseError);
                this.logger.info((Object)"Call failed on HProxy server", (Throwable)exception);
                throw exception;
            }
            catch (JsonSyntaxException e) {
                this.logger.info((Object)"Invalid HProxy server response", (Throwable)e);
                throw new IOException("Invalid HProxy server response");
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                // empty if block
            }
        }
    }

    public boolean ping() {
        try {
            PingResponse pr = this.call("ping", new Parameters(), PingResponse.class);
            return pr.ok;
        }
        catch (HProxyException | IOException exception) {
            return false;
        }
    }

    protected static class Parameters
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 9201261293827222456L;

        protected Parameters() {
        }

        Parameters with(String k, Object v) {
            this.put(k, v);
            return this;
        }
    }
}

