/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.hive.executor;

import com.dataiku.hproxy.model.hive.ExecutionQueryParams;
import com.dataiku.hproxy.server.Context;
import com.dataiku.hproxy.server.hive.executor.HiveLoaderHandler;
import com.dataiku.hproxy.server.hive.executor.IHiveLoader;
import com.dataiku.hproxy.server.hive.executor.SeparateClassLoaderExecutor;
import com.dataiku.hproxy.server.hive.executor.SessionHandlerPool;
import com.dataiku.hproxy.utils.Reflector;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class HiveLoaderPool {
    private final Map<ExecutionQueryParams, HiveLoaderHandler> hiveLoaders = Maps.newHashMap();
    private final ClassLoader hiveClassLoader;
    private final Context ctx;
    private final SeparateClassLoaderExecutor classLoaderExecutor;
    private static Logger logger = Logger.getLogger(HiveLoaderPool.class);

    HiveLoaderPool(ClassLoader hiveClassLoader, Context ctx, SeparateClassLoaderExecutor classLoaderExecutor) {
        this.hiveClassLoader = hiveClassLoader;
        this.ctx = ctx;
        this.classLoaderExecutor = classLoaderExecutor;
    }

    public IHiveLoader getHiveLoader(ExecutionQueryParams params) throws Exception {
        return this.get(params).getHiveLoader();
    }

    public SessionHandlerPool getSessionHandlers(ExecutionQueryParams params) throws Exception {
        return this.get(params).getSessionHandlers();
    }

    private HiveLoaderHandler get(ExecutionQueryParams params) throws Exception {
        HiveLoaderHandler hiveLoaderHandler = this.hiveLoaders.get(params);
        if (hiveLoaderHandler == null) {
            logger.info((Object)("Create new hive loader for parameters: " + params.toString()));
            return this.create(params);
        }
        logger.info((Object)("Use existing hive loader for parameters: " + params.toString()));
        return hiveLoaderHandler;
    }

    private HiveLoaderHandler create(final ExecutionQueryParams params) throws Exception {
        try {
            IHiveLoader hiveLoader = this.classLoaderExecutor.runFully(new Callable<IHiveLoader>(){

                @Override
                public IHiveLoader call() throws Exception {
                    return (IHiveLoader)new Reflector(HiveLoaderPool.this.hiveClassLoader).callStatic("com.dataiku.hproxy.sandbox.hive.common.HiveLoaderImpl", "initTunedHiveForNotebook", new Object[]{HiveLoaderPool.this.ctx.getHadoopFS(), params.forceMr, params.extraConf});
                }
            });
            HiveLoaderHandler hiveLoaderHandler = new HiveLoaderHandler(hiveLoader, this.classLoaderExecutor);
            this.hiveLoaders.put(params, hiveLoaderHandler);
            return hiveLoaderHandler;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create hive loader", (Throwable)e);
            throw new Exception("Unable to create hive loader");
        }
    }
}

