/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.hive.executor;

import com.dataiku.hproxy.server.hive.executor.IHiveSession;
import com.dataiku.hproxy.server.hive.executor.IQueryHandler;
import com.dataiku.hproxy.server.hive.executor.SeparateClassLoaderExecutor;
import com.dataiku.hproxy.server.hive.executor.SessionHandlerPool;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SessionHandler {
    private final IHiveSession session;
    private final SessionHandlerPool pool;
    private final SeparateClassLoaderExecutor hiveThread;
    private final Map<String, IQueryHandler> queries;
    private final Set<String> addedJars;
    private static Logger logger = Logger.getLogger(SessionHandler.class);

    public SessionHandler(Set<String> addedJars, IHiveSession session, SessionHandlerPool pool, SeparateClassLoaderExecutor executor) {
        this.addedJars = addedJars;
        this.session = session;
        this.pool = pool;
        this.hiveThread = executor.spawnAnother("SessionHandler");
        this.queries = Maps.newHashMap();
    }

    public IHiveSession getSession() {
        return this.session;
    }

    public Set<String> getAddedJars() {
        return this.addedJars;
    }

    public void give() {
        if (!this.hiveThread.isShutdown()) {
            this.pool.give(this);
        }
    }

    public SeparateClassLoaderExecutor getHiveThread() {
        return this.hiveThread;
    }

    public void destroy() {
        logger.info((Object)"Destroying session handler");
        this.session.destroy();
        this.hiveThread.shutdown();
        this.pool.forget(this);
    }

    public synchronized int getRegisteredCount() {
        return this.queries.size();
    }

    public synchronized void registerUsage(IQueryHandler query) {
        this.queries.put(query.getIdentifier(), query);
    }

    public synchronized void deregisterUsage(IQueryHandler query) {
        this.queries.remove(query.getIdentifier());
        if (this.queries.size() == 0) {
            logger.info((Object)"Session not used by any query anymore, disposing");
            this.pool.dispose(this);
        }
    }
}

