/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.pig.checker;

import com.dataiku.hproxy.model.pig.FieldDescription;
import com.dataiku.hproxy.model.pig.ValidationResult;
import com.dataiku.hproxy.server.pig.checker.IPigCheckerImpl;
import com.dataiku.hproxy.utils.Reflector;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public class PigCheckerImpl
implements IPigCheckerImpl {
    private String pigScript;
    private Reflector reflect;
    private static Pattern javaCCSourceLocPattern = Pattern.compile("line ([0-9]+), column ([0-9]+)");
    private static Pattern javaCCCleanupPattern = Pattern.compile("\\.?\\s*<\\s*line\\s*[0-9]+,\\s*column\\s*[0-9]+\\s*>\\s*");
    private static Logger logger = Logger.getLogger(PigCheckerImpl.class);

    public void init(ClassLoader pigClassLoader, String pigScript) {
        this.pigScript = pigScript;
        this.reflect = new Reflector(pigClassLoader);
        logger.info((Object)("New Pig validator for script :\n" + pigScript));
    }

    private List<FieldDescription> getFields(Object schema) throws Exception {
        ArrayList<FieldDescription> ret = new ArrayList<FieldDescription>();
        if (schema == null) {
            return ret;
        }
        Iterable it = (Iterable)this.reflect.call(schema, "getFields", new Object[0]);
        if (it == null) {
            return ret;
        }
        for (Object fs : (Iterable)this.reflect.call(schema, "getFields", new Object[0])) {
            FieldDescription pf = new FieldDescription();
            pf.name = (String)this.reflect.getAttribute(fs, "alias");
            pf.type = (String)this.reflect.callStatic("org.apache.pig.data.DataType", "findTypeName", new Object[]{this.reflect.getAttribute(fs, "type")});
            if (this.reflect.getStaticAttribute("org.apache.pig.data.DataType", "BAG").equals(this.reflect.getAttribute(fs, "type")) || this.reflect.getStaticAttribute("org.apache.pig.data.DataType", "TUPLE").equals(this.reflect.getAttribute(fs, "type")) || this.reflect.getStaticAttribute("org.apache.pig.data.DataType", "MAP").equals(this.reflect.getAttribute(fs, "type"))) {
                pf.fields = this.getFields(this.reflect.getAttribute(fs, "schema"));
            }
            if ("bag".equals(pf.type) && pf.fields.size() == 1 && "tuple".equals(((FieldDescription)pf.fields.get((int)0)).type)) {
                FieldDescription tuple = (FieldDescription)pf.fields.get(0);
                tuple.type = "bag-of-tuples";
                tuple.name = pf.name;
                ret.add(tuple);
                continue;
            }
            ret.add(pf);
        }
        return ret;
    }

    private Properties getProperties() {
        Properties pigProperties = new Properties();
        pigProperties.setProperty("mapred.output.compress", "true");
        pigProperties.setProperty("mapred.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        return pigProperties;
    }

    public ValidationResult checkCompile() throws Exception {
        Object gp = null;
        ValidationResult ret = new ValidationResult();
        StopWatch sw_PigChecker = new StopWatch();
        sw_PigChecker.start();
        Object pigServer = this.reflect.newInstance("org.apache.pig.PigServer", new Object[]{"local"});
        logger.info((Object)("PigServer instance created in " + sw_PigChecker.getTime() + "ms"));
        try {
            StopWatch sw_GruntParser = new StopWatch();
            sw_GruntParser.start();
            try {
                gp = this.reflect.newInstance("org.apache.pig.tools.grunt.GruntParser", new Object[]{new StringReader(this.pigScript), pigServer});
                logger.debug((Object)"Instanciated GruntParser using Pig 0.13 compatibility mode");
            }
            catch (Exception e) {
                logger.debug((Object)"Failed to instanciate GruntParser using Pig 0.13 compatibility mode");
            }
            if (gp == null) {
                try {
                    gp = this.reflect.newInstance("org.apache.pig.tools.grunt.GruntParser", new Object[]{new StringReader(this.pigScript)});
                    this.reflect.call(gp, "setParams", new Object[]{pigServer});
                    logger.debug((Object)"Instanciated GruntParser using Pig 0.10->0.12 compatibility mode");
                }
                catch (Exception e) {
                    logger.debug((Object)"Failed to instanciate GruntParser using Pig 0.10->0.12 compatibility mode");
                }
            }
            logger.info((Object)("GruntParser instance created in " + sw_GruntParser.getTime() + "ms"));
            this.reflect.call(gp, "setInteractive", new Object[]{false});
            this.reflect.call(pigServer, "setBatchOn", new Object[0]);
            StopWatch sw_parseTime = new StopWatch();
            sw_parseTime.start();
            this.reflect.call(gp, "parseOnly", new Object[0]);
            logger.info((Object)("Pig script parsed in " + sw_parseTime.getTime() + "ms"));
            Object currDAG = this.reflect.getAttribute(pigServer, "currDAG");
            StopWatch sw_validateTime = new StopWatch();
            sw_validateTime.start();
            this.reflect.call(currDAG, "validateQuery", new Object[0]);
            logger.info((Object)("Pig script validated in " + sw_validateTime.getTime() + "ms"));
            ret.ok = true;
        }
        catch (InvocationTargetException wrappedException) {
            int uglyPartIndex;
            Throwable e = wrappedException.getCause();
            logger.error((Object)"Caught error", e);
            Iterator loc = this.tryToFindSourceLocation(e);
            if (loc != null) {
                logger.error((Object)("Found loc: " + (Integer)this.reflect.call((Object)loc, "line", new Object[0]) + " - " + (Integer)this.reflect.call((Object)loc, "offset", new Object[0])));
                ret.errorLine = (Integer)this.reflect.call((Object)loc, "line", new Object[0]);
                ret.errorOffset = (Integer)this.reflect.call((Object)loc, "offset", new Object[0]);
            }
            Object errMsg = e.getMessage();
            for (Throwable nestedException = e.getCause(); nestedException != null; nestedException = nestedException.getCause()) {
                errMsg = nestedException.getMessage() + " / " + (String)errMsg;
            }
            if (StringUtils.isBlank((String)errMsg)) {
                errMsg = "Unknown Pig error";
            }
            if ((uglyPartIndex = ((String)(errMsg = javaCCCleanupPattern.matcher((CharSequence)errMsg).replaceAll(" "))).indexOf("Was expecting one of:")) != -1) {
                errMsg = ((String)errMsg).substring(0, uglyPartIndex);
            }
            ret.errorMessage = errMsg;
        }
        Object currDAG = this.reflect.getAttribute(pigServer, "currDAG");
        Map operators = (Map)this.reflect.call(currDAG, "getAliasOp", new Object[0]);
        for (Map.Entry sp : operators.entrySet()) {
            FieldDescription out = new FieldDescription();
            out.name = (String)sp.getKey();
            if (out.name == null || out.name.isEmpty() || out.name.charAt(0) >= '0' && out.name.charAt(0) <= '9') continue;
            out.type = "relation";
            Object lro = sp.getValue();
            Object schema = this.reflect.call(lro, "getSchema", new Object[0]);
            if (schema != null) {
                out.fields = this.getFields(this.reflect.callStatic("org.apache.pig.newplan.logical.Util", "translateSchema", new Object[]{schema}));
            }
            ret.relationSchemas.add(out);
        }
        if (gp != null) {
            Class c = this.reflect.getClassForName("org.apache.pig.tools.grunt.GruntParser");
            Method m = c.getDeclaredMethod("quit", new Class[0]);
            m.setAccessible(true);
            m.invoke(gp, new Object[0]);
        }
        this.reflect.call(pigServer, "shutdown", new Object[0]);
        return ret;
    }

    private Object tryToFindSourceLocation(Throwable e) throws Exception {
        Matcher m;
        CharSequence msg;
        if (this.reflect.isInstanceOf((Object)e, "org.apache.pig.impl.logicalLayer.FrontendException")) {
            for (Throwable cause = (Throwable)this.reflect.call((Object)e, "getCause", new Object[0]); cause != null; cause = cause.getCause()) {
                if (!this.reflect.isInstanceOf((Object)cause, "org.apache.pig.parser.PigRecognitionException")) continue;
                try {
                    return this.reflect.getAttribute((Object)cause, "location");
                }
                catch (Throwable t) {
                    logger.error((Object)"Failed to read error details", t);
                }
            }
        }
        if ((msg = (CharSequence)this.reflect.call((Object)e, "getMessage", new Object[0])) != null && (m = javaCCSourceLocPattern.matcher(msg)).find()) {
            Object ex = this.reflect.newInstance("org.apache.pig.parser.SourceLocation", new Object[]{null, Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))});
            return ex;
        }
        return null;
    }

    public void close() {
        try {
            Class pc = this.reflect.getClassForName("org.apache.pig.impl.PigContext");
            Class ccl = this.reflect.getInnerClass(pc, "ContextClassLoader");
            Constructor c = ccl.getDeclaredConstructor(ClassLoader.class);
            c.setAccessible(true);
            Object freshClassLoader = c.newInstance(this.reflect.getClassLoader());
            this.reflect.setStaticAttribute("org.apache.pig.impl.PigContext", "classloader", freshClassLoader);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to reset the Pig classloader", (Throwable)e);
        }
        try {
            this.reflect.setStaticAttribute("org.apache.pig.EvalFunc", "nextSchemaId", (Object)0);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to reset schema id counter", (Throwable)e);
        }
    }
}

