/*
 * Decompiled with CFR 0.152.
 */
package com.BoxOfC.LevenshteinAutomatonTest;

import com.BoxOfC.LevenshteinAutomaton.Position;
import com.BoxOfC.LevenshteinAutomaton.State;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(enabled=false)
public class PositionTest {
    @DataProvider(name="transitionInternalTestDp")
    public Object[][] transitionInternalTestDataProvider() {
        int numberOfTests = 1000;
        int maxE = 10;
        Object[][] newArgArrayContainerArray = new Object[numberOfTests][1];
        for (int i = 0; i < numberOfTests; ++i) {
            int randomN = (int)(Math.random() * (double)maxE) + 1;
            int randomI = (int)(Math.random() * (double)(2 * randomN + 1));
            boolean randomT = i % 2 == 0;
            newArgArrayContainerArray[i] = new Object[]{new Position(randomI, randomN, randomT)};
        }
        return newArgArrayContainerArray;
    }

    public void matchTransitionAssertion(Position p, State s) {
        assert (s.getMemberPositions()[0].equals(new Position(p.getI() + 1, p.getE(), false)));
    }

    public void insertionTransitionAssertion(Position p, State s) {
        assert (s.getMemberPositions()[0].equals(new Position(p.getI(), p.getE() + 1, false)));
    }

    public void transpositionTransitionAssertion(Position p, State s) {
        assert (s.getMemberPositions()[0].equals(new Position(p.getI() + 2, p.getE(), false)));
    }

    public void preTranspositionTransitionAssertion(Position p, State s, int hitIndex) {
        Position assertPos0 = new Position(p.getI(), p.getE() + 1, false);
        Position assertPos1 = new Position(p.getI(), p.getE() + 1, true);
        Position assertPos2 = new Position(p.getI() + 1, p.getE() + 1, false);
        Position assertPos3 = new Position(p.getI() + hitIndex + 1, p.getE() + (hitIndex + 1) - 1, false);
        Position[] memberPositionArray = s.getMemberPositions();
        assert (memberPositionArray[0].equals(assertPos0));
        assert (memberPositionArray[1].equals(assertPos1));
        assert (memberPositionArray[2].equals(assertPos2));
        assert (memberPositionArray[3].equals(assertPos3));
    }

    public void defaultTransitionAssertion(Position p, State s) {
        Position assertPos0 = new Position(p.getI(), p.getE() + 1, false);
        Position assertPos1 = new Position(p.getI() + 1, p.getE() + 1, false);
        Position[] memberPositionArray = s.getMemberPositions();
        assert (memberPositionArray[0].equals(assertPos0));
        assert (memberPositionArray[1].equals(assertPos1));
    }

    public void deletionTransitionAssertion(Position p, State s, int hitIndex) {
        Position assertPos0 = new Position(p.getI(), p.getE() + 1, false);
        Position assertPos1 = new Position(p.getI() + 1, p.getE() + 1, false);
        Position assertPos2 = new Position(p.getI() + hitIndex + 1, p.getE() + (hitIndex + 1) - 1, false);
        Position[] memberPositionArray = s.getMemberPositions();
        assert (memberPositionArray[0].equals(assertPos0));
        assert (memberPositionArray[1].equals(assertPos1));
        assert (memberPositionArray[2].equals(assertPos2));
    }

    @Test(dataProvider="transitionInternalTestDp")
    public void transitionInternalTest(Position p) {
        int mdStartIndex;
        for (int mdi = mdStartIndex = p.getE() + (!p.getT() ? 2 : 1); mdi >= p.getE(); --mdi) {
            for (int rsi = 0; rsi <= 2; ++rsi) {
                block38: for (int hii = -1; hii <= 4; ++hii) {
                    int currentE = mdi == p.getE() + 2 ? 0 : p.getE();
                    boolean currentT = rsi < 2 ? false : p.getT();
                    Position currentPosition = new Position(p.getI(), currentE, currentT);
                    State s = currentPosition.transitionInternal(mdi, rsi, hii);
                    if (currentE == 0 && currentE < mdi) {
                        block0 : switch (rsi) {
                            case 0: {
                                this.insertionTransitionAssertion(currentPosition, s);
                                break;
                            }
                            case 1: {
                                switch (hii) {
                                    case 0: {
                                        this.matchTransitionAssertion(currentPosition, s);
                                        break block0;
                                    }
                                }
                                this.defaultTransitionAssertion(currentPosition, s);
                                break;
                            }
                            default: {
                                switch (hii) {
                                    case -1: {
                                        this.defaultTransitionAssertion(currentPosition, s);
                                        break block0;
                                    }
                                    case 0: {
                                        this.matchTransitionAssertion(currentPosition, s);
                                        break block0;
                                    }
                                    case 1: {
                                        this.preTranspositionTransitionAssertion(currentPosition, s, hii);
                                        break block0;
                                    }
                                }
                                this.deletionTransitionAssertion(currentPosition, s, hii);
                                break;
                            }
                        }
                        continue;
                    }
                    if (currentE > 0 && currentE < mdi) {
                        switch (rsi) {
                            case 0: {
                                this.insertionTransitionAssertion(currentPosition, s);
                                continue block38;
                            }
                            case 1: {
                                switch (hii) {
                                    case 0: {
                                        this.matchTransitionAssertion(currentPosition, s);
                                        break;
                                    }
                                    default: {
                                        this.defaultTransitionAssertion(currentPosition, s);
                                        break;
                                    }
                                }
                                continue block38;
                            }
                            default: {
                                if (!currentT) {
                                    switch (hii) {
                                        case -1: {
                                            this.defaultTransitionAssertion(currentPosition, s);
                                            break;
                                        }
                                        case 0: {
                                            this.matchTransitionAssertion(currentPosition, s);
                                            break;
                                        }
                                        case 1: {
                                            this.preTranspositionTransitionAssertion(currentPosition, s, hii);
                                            break;
                                        }
                                        default: {
                                            this.deletionTransitionAssertion(currentPosition, s, hii);
                                            break;
                                        }
                                    }
                                    continue block38;
                                }
                                switch (hii) {
                                    case 0: {
                                        this.transpositionTransitionAssertion(currentPosition, s);
                                        continue block38;
                                    }
                                    default: {
                                        assert (s == null);
                                        continue block38;
                                    }
                                }
                            }
                        }
                    }
                    switch (rsi) {
                        case 0: {
                            assert (s == null);
                            continue block38;
                        }
                        default: {
                            if (!currentPosition.getT()) {
                                switch (hii) {
                                    case 0: {
                                        this.matchTransitionAssertion(currentPosition, s);
                                        continue block38;
                                    }
                                }
                                assert (s == null);
                                continue block38;
                            }
                            switch (hii) {
                                case 0: {
                                    this.transpositionTransitionAssertion(currentPosition, s);
                                    continue block38;
                                }
                            }
                            assert (s == null);
                            continue block38;
                        }
                    }
                }
            }
        }
    }
}

