/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aiexplanations.flow;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.transform.ColumnRenamer;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfDesc;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfRule;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

class RecipeSummarizer {
    @Autowired
    private RecipesDAO recipesDAO;

    public RecipeSummarizer() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private static void removeField(JsonObject obj, String key) {
        if (obj.has(key)) {
            obj.remove(key);
        }
    }

    public RecipeSummary summarize(FlowRecipe flowRecipe) throws Exception {
        SerializedRecipe serializedRecipe = flowRecipe.getModel();
        String payloadStr = this.recipesDAO.getPayloadOrNull(serializedRecipe.projectKey, serializedRecipe.name);
        switch (serializedRecipe.type) {
            case "topn": {
                TopNRecipeSummary ret = new TopNRecipeSummary();
                ret.recipeType = serializedRecipe.type;
                ret.inputDatasets.add(flowRecipe.getSources().get(0).getRef(serializedRecipe.getProjectKey()));
                TopNRecipePayloadParams payload = (TopNRecipePayloadParams)JSON.parse((String)payloadStr, TopNRecipePayloadParams.class);
                Object desc = "";
                if (!payload.keys.isEmpty()) {
                    desc = (String)desc + "For each group of rows identified by " + payload.keys.stream().map(k -> "\"" + k + "\"").collect(Collectors.joining(",")) + ", ";
                }
                desc = (String)desc + "keep only the ";
                if (payload.firstRows > 0) {
                    desc = (String)desc + "first " + payload.firstRows + " ";
                }
                if (payload.lastRows > 0) {
                    desc = (String)desc + "last " + payload.firstRows + " ";
                }
                ret.topDesc = desc = (String)desc + "ordered by " + payload.orders.stream().map(o -> "\"" + o.column + "\"").collect(Collectors.joining(","));
                return ret;
            }
            case "join": {
                JoinRecipeSummary ret = new JoinRecipeSummary();
                ret.recipeType = serializedRecipe.type;
                ret.inputDatasets = serializedRecipe.getInputsForRole("main").stream().map(i -> i.ref).collect(Collectors.toList());
                JoinRecipePayloadParams payload = (JoinRecipePayloadParams)JSON.parse((String)payloadStr, JoinRecipePayloadParams.class);
                boolean bl = ret.isSimpleJoin = ret.inputDatasets.size() == 2 && payload.joins.size() == 1;
                if (ret.isSimpleJoin) {
                    JoinRecipePayloadParams datasetNamesPayload = JoinRecipeHelper.resolveDatasetNames(payload, serializedRecipe);
                    JoinRecipePayloadParams.JoinDesc join = (JoinRecipePayloadParams.JoinDesc)datasetNamesPayload.joins.get(0);
                    ret.singleJoinDesc = "a " + String.valueOf((Object)join.type) + " join between ";
                    ret.singleJoinDesc = ret.singleJoinDesc + join.on.stream().map(on -> {
                        String leftDataset = ((JoinRecipePayloadParams.InputDesc)datasetNamesPayload.virtualInputs.get((int)on.column1.table)).name;
                        String rightDataset = ((JoinRecipePayloadParams.InputDesc)datasetNamesPayload.virtualInputs.get((int)on.column2.table)).name;
                        String leftCol = on.column1.name;
                        String rightCol = on.column2.name;
                        return "\"" + leftDataset + "\".\"" + leftCol + " and \"" + rightDataset + "\".\"" + rightCol;
                    }).collect(Collectors.joining(", and between "));
                    ret.matchedOutputDataset = serializedRecipe.getOutputsForRole((String)"main").get((int)0).ref;
                    if (!serializedRecipe.getOutputsForRole("unmatchedLeft").isEmpty()) {
                        ret.leftUnmatchedDataset = serializedRecipe.getOutputsForRole((String)"unmatchedLeft").get((int)0).ref;
                    }
                    if (!serializedRecipe.getOutputsForRole("unmatchedRight").isEmpty()) {
                        ret.rightUnmatchedDataset = serializedRecipe.getOutputsForRole((String)"unmatchedRight").get((int)0).ref;
                    }
                } else {
                    ret.outputDataset = serializedRecipe.getOutputsForRole((String)"main").get((int)0).ref;
                }
                return ret;
            }
            case "grouping": {
                GroupingRecipeSummary ret = new GroupingRecipeSummary();
                ret.recipeType = serializedRecipe.type;
                ret.inputDatasets.add(flowRecipe.getSources().get(0).getRef(serializedRecipe.getProjectKey()));
                ret.outputDataset = serializedRecipe.getOutputsForRole((String)"main").get((int)0).ref;
                GroupingRecipePayloadParams payload = (GroupingRecipePayloadParams)JSON.parse((String)payloadStr, GroupingRecipePayloadParams.class);
                if (FilterDescUtils.willFilter(payload.preFilter)) {
                    ret.preFilterDesc = FilterDescUtils.getFilterRepr(payload.preFilter);
                }
                ret.groupingKeys = payload.getRawGroupingKeys().stream().map(gk -> gk.column).collect(Collectors.toList());
                ret.aggregations = payload.values.stream().flatMap(gv -> {
                    ArrayList<CallSite> aggrs = new ArrayList<CallSite>();
                    if (gv.avg) {
                        aggrs.add((CallSite)((Object)("Average of " + gv.column)));
                    }
                    if (gv.sum) {
                        aggrs.add((CallSite)((Object)("Sum of " + gv.column)));
                    }
                    if (gv.min) {
                        aggrs.add((CallSite)((Object)("Min of " + gv.column)));
                    }
                    if (gv.max) {
                        aggrs.add((CallSite)((Object)("Max of " + gv.column)));
                    }
                    if (gv.countDistinct) {
                        aggrs.add((CallSite)((Object)("Count distinct of " + gv.column)));
                    }
                    return aggrs.stream();
                }).collect(Collectors.toList());
                return ret;
            }
            case "shaker": {
                PrepareRecipeSummary ret = new PrepareRecipeSummary();
                ret.recipeType = serializedRecipe.type;
                ret.inputDatasets.add(serializedRecipe.getInputsForRole((String)"main").get((int)0).ref);
                ret.outputDataset = serializedRecipe.getOutputsForRole((String)"main").get((int)0).ref;
                SerializedShakerScript serializedShakerScript = (SerializedShakerScript)JSON.parse((String)payloadStr, SerializedShakerScript.class);
                ret.processorDescs = AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(serializedShakerScript).stream().map(step -> {
                    JsonObject cleanStep;
                    if (VisualIfRule.META.getName().equals(step.type)) {
                        VisualIfDesc.TransformedVisualIfDesc transformedStep = new VisualIfDesc.TransformedVisualIfDesc(((VisualIfRule.Parameter)step.params).visualIfDesc);
                        cleanStep = JSON.toJsonObject((Object)transformedStep);
                    } else {
                        if (ColumnRenamer.META.getName().equals(step.type)) {
                            ColumnRenamer.Parameter columnRenamerParameter = (ColumnRenamer.Parameter)step.params;
                            if (columnRenamerParameter.renamings.size() > 5) {
                                columnRenamerParameter.renamings = columnRenamerParameter.renamings.subList(0, 4);
                            }
                        }
                        cleanStep = JSON.toJsonObject((Object)step);
                    }
                    RecipeSummarizer.removeField(cleanStep, "alwaysShowComment");
                    RecipeSummarizer.removeField(cleanStep, "metaType");
                    RecipeSummarizer.removeField(cleanStep, "preview");
                    RecipeSummarizer.removeField(cleanStep, "disabled");
                    RecipeSummarizer.removeField(cleanStep, "mainColor");
                    RecipeSummarizer.removeField(cleanStep, "secondaryColor");
                    return JSON.json((Object)cleanStep);
                }).collect(Collectors.toList());
                return ret;
            }
            case "vstack": {
                StackRecipeSummary ret = new StackRecipeSummary();
                ret.recipeType = serializedRecipe.type;
                ret.inputDatasets = serializedRecipe.getInputsForRole("main").stream().map(i -> i.ref).collect(Collectors.toList());
                ret.outputDataset = serializedRecipe.getOutputsForRole((String)"main").get((int)0).ref;
                return ret;
            }
            case "sampling": {
                FilterRecipeSummary ret = new FilterRecipeSummary();
                ret.recipeType = serializedRecipe.type;
                ret.inputDatasets = serializedRecipe.getInputsForRole("main").stream().map(i -> i.ref).collect(Collectors.toList());
                ret.outputDataset = serializedRecipe.getOutputsForRole((String)"main").get((int)0).ref;
                FilterDesc filterDesc = (FilterDesc)JSON.parse((String)payloadStr, FilterDesc.class);
                if (FilterDescUtils.willFilter(filterDesc)) {
                    ret.keepFilterDesc = FilterDescUtils.getFilterRepr(filterDesc);
                }
                return ret;
            }
        }
        GenericRecipeSummary ret = new GenericRecipeSummary();
        ret.recipeType = serializedRecipe.type;
        ret.inputDatasets = serializedRecipe.getInputsForRole("main").stream().map(i -> i.ref).collect(Collectors.toList());
        ret.outputDatasets = serializedRecipe.getOutputsForRole("main").stream().map(o -> o.ref).collect(Collectors.toList());
        return ret;
    }

    static class TopNRecipeSummary
    extends RecipeSummary {
        String topDesc;

        TopNRecipeSummary() {
        }
    }

    static class JoinRecipeSummary
    extends RecipeSummary {
        boolean isSimpleJoin;
        String singleJoinDesc;
        String matchedOutputDataset;
        String leftUnmatchedDataset;
        String rightUnmatchedDataset;
        String outputDataset;

        JoinRecipeSummary() {
        }
    }

    static class GroupingRecipeSummary
    extends RecipeSummary {
        String outputDataset;
        List<String> groupingKeys;
        List<String> aggregations;
        String preFilterDesc;

        GroupingRecipeSummary() {
        }
    }

    static class PrepareRecipeSummary
    extends RecipeSummary {
        String outputDataset;
        List<String> processorDescs = new ArrayList<String>();

        PrepareRecipeSummary() {
        }
    }

    static class StackRecipeSummary
    extends RecipeSummary {
        String outputDataset;

        StackRecipeSummary() {
        }
    }

    static class FilterRecipeSummary
    extends RecipeSummary {
        String outputDataset;
        String keepFilterDesc;

        FilterRecipeSummary() {
        }
    }

    static class GenericRecipeSummary
    extends RecipeSummary {
        List<String> outputDatasets = new ArrayList<String>();

        GenericRecipeSummary() {
        }
    }

    public static class RecipeSummary {
        String recipeType;
        List<String> inputDatasets = new ArrayList<String>();
    }
}

