/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class EnvironmentNameExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        ResolvedCoreParams coreParams = model.getCoreParams();
        if (coreParams != null && coreParams.executionParams != null) {
            switch (coreParams.executionParams.envSelection.envMode) {
                case USE_BUILTIN_MODE: {
                    return "DSS builtin environment";
                }
                case INHERIT: {
                    return "Inherited project default (" + coreParams.executionParams.envName + ")";
                }
                case EXPLICIT_ENV: {
                    return "Explicitly chosen environment (" + coreParams.executionParams.envSelection.envName + ")";
                }
            }
            throw new IOException("No environment found for model " + model.fullModelId);
        }
        throw new IOException("No environment found for model " + model.fullModelId);
    }
}

