/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.helpers;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.MockableSystem;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import org.apache.commons.lang.StringUtils;

public class UrlUtil {
    private UrlUtil() {
    }

    public static String getDSSInternalRootUrl(GeneralSettingsDAO.GeneralSettings generalSettings) {
        String internalUrl = generalSettings.studioInternalUrl;
        if (StringUtils.isNotBlank((String)internalUrl)) {
            return internalUrl;
        }
        return UrlUtil.getDSSLocalhostRootUrl();
    }

    public static String getDSSExternalRootUrl(GeneralSettingsDAO.GeneralSettings generalSettings) {
        String externalUrl = generalSettings.studioExternalUrl;
        if (StringUtils.isNotBlank((String)externalUrl)) {
            return externalUrl;
        }
        return null;
    }

    public static String getDSSLocalhostRootUrl() {
        String basePort = DKUApp.getIniValue((String)"server", (String)"port");
        if (basePort == null && (basePort = MockableSystem.getenv((String)"DKU_BASE_PORT")) == null) {
            throw new IllegalStateException("DKU_BASE_PORT environment variable is not set");
        }
        boolean ssl = Boolean.parseBoolean(DKUApp.getIniValue((String)"server", (String)"ssl"));
        return (ssl ? "https" : "http") + "://localhost:" + Integer.parseInt(basePort);
    }
}

