/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKUDateUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScoringRecipeUtils {

    public static class ModelMetadataUtils {
        private static String prefixColName = "smmd_";
        private static String savedModelIdColName = "savedModelId";
        private static String modelVersionColName = "modelVersion";
        private static String fullModelIdColName = "fullModelId";
        private static String predictionTimeColName = "predictionTime";
        private static List<String> colNames = Arrays.asList(ModelMetadataUtils.prefixedColName(savedModelIdColName), ModelMetadataUtils.prefixedColName(modelVersionColName), ModelMetadataUtils.prefixedColName(fullModelIdColName), ModelMetadataUtils.prefixedColName(predictionTimeColName));

        private static String prefixedColName(String colName) {
            return prefixColName + colName;
        }

        public static List<SchemaColumn> getModelMetadataSchemaColumns() {
            ArrayList<SchemaColumn> columnsToAdd = new ArrayList<SchemaColumn>();
            columnsToAdd.add(new SchemaColumn(colNames.get(0), Type.STRING));
            columnsToAdd.add(new SchemaColumn(colNames.get(1), Type.STRING));
            columnsToAdd.add(new SchemaColumn(colNames.get(2), Type.STRING));
            columnsToAdd.add(new SchemaColumn(colNames.get(3), Type.DATE));
            return columnsToAdd;
        }

        public static List<Column> getModelMetadataColumns(StreamColumnFactory scf) {
            ArrayList<Column> modelMetadataColumns = new ArrayList<Column>();
            for (String col : colNames) {
                modelMetadataColumns.add((Column)scf.column(col));
            }
            return modelMetadataColumns;
        }

        public static List<String> getModelMetadata(FullModelId fmi) {
            ArrayList<String> modelMetadata = new ArrayList<String>();
            modelMetadata.add(fmi.getSavedModelID());
            modelMetadata.add(fmi.getSavedModelVersionID());
            modelMetadata.add(fmi.toString());
            modelMetadata.add(DKUDateUtils.isoFormatUTCNow());
            return modelMetadata;
        }

        public static Map<String, List<String>> getPartitionedModelMetadata(FullModelId basedModelFMI) throws IOException {
            HashMap<String, List<String>> partitionedModelMetadata = new HashMap<String, List<String>>();
            Map<String, String> partModelsNameAndVersion = basedModelFMI.getPartitionToVersion();
            for (Map.Entry<String, String> partition : partModelsNameAndVersion.entrySet()) {
                ArrayList<String> modelMetadata = new ArrayList<String>();
                FullModelId partitionedModelFMI = basedModelFMI.getSMModelPartition(partition.getKey(), partition.getValue());
                modelMetadata.add(partitionedModelFMI.getSavedModelID());
                modelMetadata.add(partitionedModelFMI.getSavedModelVersionID());
                modelMetadata.add(partitionedModelFMI.toString());
                modelMetadata.add(DKUDateUtils.isoFormatUTCNow());
                partitionedModelMetadata.put(partition.getKey(), modelMetadata);
            }
            return partitionedModelMetadata;
        }

        public static Map<String, String> getPartitionedFMIs(FullModelId basedModelFMI) throws IOException {
            HashMap<String, String> partitionedFMIs = new HashMap<String, String>();
            Map<String, String> partModelsNameAndVersion = basedModelFMI.getPartitionToVersion();
            for (Map.Entry<String, String> partition : partModelsNameAndVersion.entrySet()) {
                FullModelId partitionedModelFMI = basedModelFMI.getSMModelPartition(partition.getKey(), partition.getValue());
                partitionedFMIs.put(partition.getKey(), partitionedModelFMI.toString());
            }
            return partitionedFMIs;
        }

        public static String schemaIncludesModelMetadata(Schema schema) {
            for (String col : colNames) {
                if (schema.getColumn(col) == null) continue;
                return col;
            }
            return null;
        }

        public static void sqlAddModelMetadata(SelectQueryBuilder scoredSQB, FullModelId fmi) {
            ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
            scoredSQB.select(EBF.cst(fmi.getSavedModelID()), colNames.get(0));
            scoredSQB.select(EBF.cst(fmi.getSavedModelVersionID()), colNames.get(1));
            scoredSQB.select(EBF.cst(fmi.toString()), colNames.get(2));
            scoredSQB.select(EBF.cst(DKUDateUtils.isoFormatUTCNow()), colNames.get(3));
        }

        public static void sqlAddModelMetadata(SQLQueryWithSchema outerQuery, FullModelId fmi) {
            ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
            outerQuery.select(EBF.cst(fmi.getSavedModelID()), colNames.get(0));
            outerQuery.select(EBF.cst(fmi.getSavedModelVersionID()), colNames.get(1));
            outerQuery.select(EBF.cst(fmi.toString()), colNames.get(2));
            outerQuery.select(EBF.cst(DKUDateUtils.isoFormatUTCNow()), colNames.get(3));
        }
    }
}

