/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.SavedModelCodes;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.CausalPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.ClassicalPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.DeepHubPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesBasicService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesHelper;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesMeta;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionScoringRecipeSchemaComputer;
import com.dataiku.dip.analysis.ml.prediction.flow.TabularPredictionScoringRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.TimeseriesForecastingTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.DeepHubPreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.DeepHubPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ResolvedCausalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.scoring.exports.SQLScoring;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PredictionRecipesService
extends PredictionRecipesBasicService {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private PredictionSMMgmtService savedModelsMgmtService;
    @Autowired
    private SavedModelsCRUDService savedModelsService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ShakerRecipeService shakerRecipeService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private GenericRecipesValidationService validationService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private ManagedFoldersService managedFolderService;
    private static Logger logger = Logger.getLogger((String)"dku.analysis.flow");

    public Pair<String, String> createTrainingRecipePrep_NT(AuthCtx u, FullModelId fmi, AnyLoc trainSet, AnyLoc testSet, TrainingRecipeCreationOptions options, String modelName, AnyLoc managedFolder) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        String targetProjectKey = fmi.getTaskLoc().analysisProjectKey;
        PredictionModelDetails details = PredictionResultsReader.makeModelDetails(fmi);
        if (details.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) {
            throw ErrorContext.iae((String)"Can't create a recipe on a non-DONE model");
        }
        if (details instanceof ClassicalPredictionModelDetails && ((ClassicalPredictionModelDetails)details).modeling.algorithm.backendType == MLTask.BackendType.VERTICA) {
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_VERTICA_NOT_SUPPORTED, "Cannot create training recipe for model " + String.valueOf(fmi));
        }
        SavedModel savedModel = new SavedModel(targetProjectKey, SecretKeyGenerator.generate((int)8));
        savedModel.name = modelName;
        Dataset trainDataset = null;
        Dataset testDataset = null;
        ManagedFolder folder = null;
        try (Transaction t = this.transactionService.beginRead();){
            trainDataset = this.datasetAccessService.getMandatoryUnsafe(trainSet);
            if (testSet != null) {
                testDataset = this.datasetAccessService.getMandatoryUnsafe(testSet);
            }
            if (managedFolder != null) {
                folder = this.managedFolderService.getMandatoryUnsafe(managedFolder.getProjectKey(), managedFolder.getId());
            }
        }
        MLPaths.createIfNeededSavedModelFolderAndRestrictPermissions(savedModel);
        File targetSMFolder = MLPaths.savedModelBaseFolder(savedModel.projectKey, savedModel.id);
        FilesystemACLUtils.grantFSReadACLs(u, savedModel.projectKey, targetSMFolder);
        if (fmi.isPartitionedBaseModel() || fmi.isModelPartition()) {
            this.savedModelsMgmtService.createFromPartitionedMLTask(fmi.getPartitionedBaseModel(), savedModel);
            savedModel.partitioning = trainDataset.getPartitioningSchema();
            savedModel.cleanTemporaryVersionsPostJob = true;
        } else {
            this.savedModelsMgmtService.createFromMLTask(fmi, savedModel, true);
        }
        AbstractPredictionTrainingRecipePayloadParams desc = switch (fmi.getPredictionType()) {
            case PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_CLASSIFICATION, PredictionMLTask.PredictionType.DEEP_HUB_IMAGE_OBJECT_DETECTION -> new DeepHubPredictionTrainingRecipePayloadParams();
            case PredictionMLTask.PredictionType.MULTICLASS, PredictionMLTask.PredictionType.BINARY_CLASSIFICATION, PredictionMLTask.PredictionType.REGRESSION -> new ClassicalPredictionTrainingRecipePayloadParams();
            case PredictionMLTask.PredictionType.TIMESERIES_FORECAST -> new TimeseriesForecastingTrainingRecipePayloadParams();
            case PredictionMLTask.PredictionType.CAUSAL_BINARY_CLASSIFICATION, PredictionMLTask.PredictionType.CAUSAL_REGRESSION -> new CausalPredictionTrainingRecipePayloadParams();
            default -> throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)fmi.getPredictionType()));
        };
        this.prepareTrainDesc(desc, details, options, fmi);
        Map<Metric, String> metricsValues = this.createMetrics(fmi, details);
        ArrayList contentTypeChunks = Lists.newArrayList();
        contentTypeChunks.add(savedModel.miniTask.taskType.name().toLowerCase());
        contentTypeChunks.add(savedModel.miniTask.backendType.name().toLowerCase());
        savedModel.contentType = Joiner.on((String)"/").join((Iterable)contentTypeChunks);
        SerializedRecipe sr = new SerializedRecipe();
        sr.type = PredictionRecipesMeta.TRAINING_META.getType();
        if (desc.needsInputDataFolder) {
            assert (folder != null);
            savedModel.needsInputDataFolder = true;
            sr.addInput("data", folder.getSmartName(targetProjectKey));
        }
        sr.params = new ContainerRecipeParams();
        ResolvedCoreParams rcp = fmi.getResolvedCoreParams();
        ContainerExecUtils.expandContainerParamsIfNeeded(sr, rcp);
        sr.addInput("main", trainSet.getSmartName(targetProjectKey));
        sr.addOutput("main", savedModel.id, false);
        RecipeCreationUtils.makeEqualsOrAllAvailableDep(sr, "main", trainSet.getSmartName(targetProjectKey), trainDataset, savedModel);
        if (testSet != null) {
            sr.addInput("test", testSet.getSmartName(targetProjectKey));
            RecipeCreationUtils.makeEqualsOrAllAvailableDep(sr, "test", testSet.getSmartName(targetProjectKey), testDataset, savedModel);
        }
        sr.labels = fmi.getTrainedWithMLTask().labels;
        logger.info((Object)("Training recipe ready: \n" + JSON.pretty((Object)desc)));
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            this.savedModelsService.save(savedModel, true, false);
            sr.name = this.recipeSaveService.transmogrifyName(targetProjectKey, "train_" + modelName.replaceAll("[^A-Za-z0-9\\-_]", "_"));
            sr.projectKey = targetProjectKey;
            String inputZone = this.flowZonesService.retrieveInputZone(sr);
            if (inputZone != null) {
                this.flowZonesService.attachObjectToZone(inputZone, sr.projectKey, sr);
                this.flowZonesService.attachObjectToZone(inputZone, sr.projectKey, savedModel);
            }
            this.shakerRecipeService.updateDependenciesOnAnyRecipe(targetProjectKey, sr, desc.script);
            this.recipeSaveService.create(fmi.getTaskLoc().analysisProjectKey, sr, JSON.pretty((Object)desc));
            this.metricsComputationService.saveMetricsValues(u, savedModel, MetricTargetType.SAVED_MODEL, MetricsComputationService.fakeSMVersionPartition(savedModel.activeVersion), new DateTime(details.trainInfo.endTime), metricsValues, this.buildMetricsEnvironment());
            rwt.commit("Created train recipe " + sr.projectKey + "." + sr.name);
        }
        return new Pair((Object)sr.name, (Object)savedModel.id);
    }

    private MetricsComputationService.MetricsComputationEnvironment buildMetricsEnvironment() throws IOException {
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = false;
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        return environment;
    }

    public boolean updateTrainingRecipePrep_NT(AuthCtx u, FullModelId fmi, SerializedRecipe sr, boolean activate, TrainingRecipeCreationOptions options) throws Exception {
        boolean modelToBeDeployedNeedsDataFolder;
        AbstractPredictionTrainingRecipePayloadParams desc;
        SavedModel sm;
        TransactionContext.assertNoAttachedTransaction();
        String targetProjectKey = fmi.getTaskLoc().analysisProjectKey;
        PredictionModelDetails details = PredictionResultsReader.makeModelDetails(fmi);
        if (details.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) {
            throw ErrorContext.iae((String)"Can't update a recipe on a non-DONE model");
        }
        if (details instanceof ClassicalPredictionModelDetails && ((ClassicalPredictionModelDetails)details).modeling.algorithm.backendType == MLTask.BackendType.VERTICA) {
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_VERTICA_NOT_SUPPORTED, "Cannot create training recipe for model " + String.valueOf(fmi));
        }
        ManagedFolder folder = null;
        try (Transaction t = this.transactionService.beginRead();){
            sm = this.savedModelsService.getMandatory(targetProjectKey, sr.getSingleOutput((String)"main").ref);
            SerializedRecipe.RecipeInput mainInput = sr.getSingleInput("main");
            this.datasetAccessService.getMandatory(AnyLoc.resolveSmart(targetProjectKey, mainInput.ref));
            if (sr.getInputsForRole("test").size() > 0) {
                this.datasetAccessService.getMandatory(AnyLoc.resolveSmart(targetProjectKey, sr.getInputsForRole((String)"test").get((int)0).ref));
            }
            if (sr.getInputsForRole("data").size() > 0) {
                folder = this.managedFolderService.getMandatory(targetProjectKey, sr.getInputsForRole((String)"data").get((int)0).ref);
            }
            String payload = this.recipesDAO.getPayloadOrNull(fmi.getProjectKey(), sr.name);
            desc = (AbstractPredictionTrainingRecipePayloadParams)JSON.parse((String)payload, AbstractPredictionTrainingRecipePayloadParams.class);
        }
        sr.labels = fmi.getTrainedWithMLTask().labels;
        ResolvedPredictionCoreParams coreParamsFromModelDetails = (ResolvedPredictionCoreParams)details.getCoreParams();
        ResolvedPredictionCoreParams coreParamsFromRecipeDesc = desc.getCoreParams();
        if (!coreParamsFromModelDetails.prediction_type.equals((Object)coreParamsFromRecipeDesc.prediction_type)) {
            throw ErrorContext.iae((String)"Can't update a recipe on a different prediction type");
        }
        boolean isCausal = coreParamsFromModelDetails instanceof ResolvedCausalPredictionCoreParams;
        if (!coreParamsFromModelDetails.target_variable.equals(coreParamsFromRecipeDesc.target_variable)) {
            String targetRoleName = isCausal ? "outcome" : "target";
            throw ErrorContext.iae((String)String.format("Can't update a recipe on a different %s variable", targetRoleName));
        }
        if (isCausal) {
            ResolvedCausalPredictionCoreParams coreParamsFromCausalModelDetails = (ResolvedCausalPredictionCoreParams)coreParamsFromModelDetails;
            ResolvedCausalPredictionCoreParams coreParamsFromCausalRecipeDesc = (ResolvedCausalPredictionCoreParams)desc.getCoreParams();
            if (!coreParamsFromCausalModelDetails.treatment_variable.equals(coreParamsFromCausalRecipeDesc.treatment_variable)) {
                throw ErrorContext.iae((String)"Can't update a recipe on a different treatment variable");
            }
        }
        if (coreParamsFromModelDetails instanceof ResolvedTimeseriesForecastingCoreParams) {
            ResolvedTimeseriesForecastingCoreParams coreParamsFromForecastingModelDetails = (ResolvedTimeseriesForecastingCoreParams)coreParamsFromModelDetails;
            ResolvedTimeseriesForecastingCoreParams coreParamsFromForecastingRecipeDesc = (ResolvedTimeseriesForecastingCoreParams)desc.getCoreParams();
            if (!coreParamsFromForecastingModelDetails.timeVariable.equals(coreParamsFromForecastingRecipeDesc.timeVariable)) {
                throw ErrorContext.iae((String)"Can't update a recipe on a different time variable");
            }
            HashSet<String> timeseriesIdentifiersInRecipe = new HashSet<String>(coreParamsFromForecastingRecipeDesc.timeseriesIdentifiers);
            HashSet<String> timeseriesIdentifiersInTask = new HashSet<String>(coreParamsFromForecastingModelDetails.timeseriesIdentifiers);
            if (!timeseriesIdentifiersInRecipe.equals(timeseriesIdentifiersInTask)) {
                throw ErrorContext.iae((String)"Can't update a recipe on different time series identifier columns");
            }
        }
        if (desc.backendType == null) {
            throw ErrorContext.iae((String)"Invalid recipe params: backend type is not set");
        }
        if (!coreParamsFromModelDetails.backendType.equals((Object)desc.backendType)) {
            throw ErrorContext.iae((String)"Can't update a recipe on a different backend type");
        }
        if (coreParamsFromModelDetails.isPartitioned() != sm.isPartitioned()) {
            throw ErrorContext.iae((String)"Can't update the partitioning option on a training recipe");
        }
        if (coreParamsFromModelDetails instanceof ResolvedClassicalPredictionCoreParams && (modelToBeDeployedNeedsDataFolder = StringUtils.isNotBlank((String)((ResolvedClassicalPredictionCoreParams)coreParamsFromModelDetails).managedFolderSmartId)) != desc.needsInputDataFolder) {
            throw ErrorContext.iae((String)"Can't update a recipe with different input managed folder requirement");
        }
        if (!desc.splitParams.ttPolicy.equals((Object)details.splitDesc.params.ttPolicy)) {
            if (desc.splitParams.ttPolicy.equals((Object)SplitParams.TrainTestPolicy.EXPLICIT_FILTERING_TWO_DATASETS)) {
                sr.clearInputsForRole("test");
            } else if (details.splitDesc.params.ttPolicy.equals((Object)SplitParams.TrainTestPolicy.EXPLICIT_FILTERING_TWO_DATASETS)) {
                throw ErrorContext.iae((String)"Can't update recipe: went from one input dataset to two");
            }
        }
        this.prepareTrainDesc(desc, details, options, fmi);
        desc.script.contextProjectKey = sm.projectKey;
        ResolvedCoreParams rcp = fmi.getResolvedCoreParams();
        ContainerExecUtils.expandContainerParamsIfNeeded(sr, rcp);
        Map<Metric, String> metricsValues = this.createMetrics(fmi, details);
        logger.info((Object)("Training recipe ready: \n" + JSON.pretty((Object)desc)));
        MLPaths.createIfNeededSavedModelFolderAndRestrictPermissions(sm);
        File targetSMFolder = MLPaths.savedModelBaseFolder(sm.projectKey, sm.id);
        FilesystemACLUtils.grantFSReadACLs(u, sm.projectKey, targetSMFolder);
        boolean schemaChanged = false;
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            String versionId = fmi.isPartitionedBaseModel() || fmi.isModelPartition() ? this.savedModelsMgmtService.updateFromPartitionedMLTask(fmi.getPartitionedBaseModel(), sm) : this.savedModelsMgmtService.updateFromMLTask(fmi, sm, true);
            sm.lastExportedFrom = fmi.toString();
            sm.lastTrainIndex = 1L;
            if (activate) {
                schemaChanged = this.savedModelsMgmtService.setActive(sm, versionId) && this.hasDownstreamRecipe(sm);
            } else {
                this.savedModelsService.save(sm, false, false);
            }
            this.recipeSaveService.save(fmi.getTaskLoc().analysisProjectKey, sr, JSON.pretty((Object)desc));
            this.metricsComputationService.saveMetricsValues(u, sm, MetricTargetType.SAVED_MODEL, MetricsComputationService.fakeSMVersionPartition(versionId), new DateTime(details.trainInfo.endTime), metricsValues, this.buildMetricsEnvironment());
            rwt.commit("Updated train recipe " + sr.projectKey + "." + sr.name);
            boolean bl = schemaChanged;
            return bl;
        }
    }

    private Map<Metric, String> createMetrics(FullModelId fmi, ModelDetailsBase details) throws IOException {
        if (fmi.getHeadMLTask() instanceof PredictionMLTask.ClassicalPredictionMLTask) {
            PredictionMLTask.ClassicalPredictionMLTask predictionMLTask = (PredictionMLTask.ClassicalPredictionMLTask)fmi.getHeadMLTask();
            ((ClassicalPredictionModelDetails)details).headTaskCMW = predictionMLTask.modeling.metrics.costMatrixWeights;
        }
        HashMap metricsValues = Maps.newHashMap();
        this.metricsComputationService.scoopTabularPredictionMetrics(metricsValues, details);
        return metricsValues;
    }

    public void computeAndSaveMetrics(AuthCtx user, FullModelId fmi) throws Exception {
        MetricsComputationService.MetricsComputationEnvironment environment;
        SavedModel sm;
        assert (fmi.type == FullModelId.Type.SAVED);
        PredictionModelDetails details = PredictionResultsReader.makeModelDetails(fmi);
        Map<Metric, String> metricsValues = this.createMetrics(fmi, details);
        try (Transaction t = this.transactionService.beginRead();){
            sm = this.savedModelsService.getMandatory(fmi.getProjectKey(), fmi.getSavedModelID());
            environment = this.buildMetricsEnvironment();
        }
        this.metricsComputationService.saveMetricsValues(user, sm, MetricTargetType.SAVED_MODEL, MetricsComputationService.fakeSMVersionPartition(fmi.getSavedModelVersionID()), new DateTime(details.trainInfo.endTime), metricsValues, environment);
    }

    public boolean hasDownstreamRecipe(SavedModel sm) throws IOException {
        for (SerializedRecipe recipe : this.recipesDAO.listUnsafe(sm.projectKey)) {
            if (!recipe.getType().equals(PredictionRecipesMeta.SCORING_META.getType()) && !recipe.getType().equals(PredictionRecipesMeta.EVALUATION_META.getType()) || recipe.getInputsForRole("model").size() != 1 || !recipe.getSingleInput((String)"model").ref.endsWith(sm.id)) continue;
            return true;
        }
        return false;
    }

    public RecipeCreator.CreationResult createScoringRecipe_NT(AuthCtx u, String projectKey, ScoringRecipeCreationOptions options) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        PredictionRecipesHelper helper = new PredictionRecipesHelper();
        SpringUtils.getInstance().autowire((Object)helper);
        return helper.createScoringRecipe_NT(u, projectKey, options);
    }

    public String createEvaluationRecipe_NT(AuthCtx u, String projectKey, EvaluationRecipeCreationOptions options) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        PredictionRecipesHelper helper = new PredictionRecipesHelper();
        SpringUtils.getInstance().autowire((Object)helper);
        return helper.createEvaluationRecipe_NT(u, projectKey, null, options);
    }

    public String createStandaloneEvaluationRecipe_NT(AuthCtx u, String projectKey, StandaloneEvaluationRecipeCreationOptions options) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        PredictionRecipesHelper helper = new PredictionRecipesHelper();
        SpringUtils.getInstance().autowire((Object)helper);
        return helper.createStandaloneEvaluationRecipe_NT(u, projectKey, options);
    }

    private void prepareTrainDesc(AbstractPredictionTrainingRecipePayloadParams desc, ModelDetailsBase summaryBase, TrainingRecipeCreationOptions options, FullModelId fmi) throws IOException {
        logger.info((Object)("Preparing train recipe with options : " + JSON.json((Object)options)));
        if (desc instanceof ClassicalPredictionTrainingRecipePayloadParams) {
            this.prepareTrainDescClassicalPrediction((ClassicalPredictionTrainingRecipePayloadParams)desc, (ClassicalPredictionModelDetails)summaryBase, options);
        } else if (desc instanceof DeepHubPredictionTrainingRecipePayloadParams) {
            this.prepareTrainDescDeepHub((DeepHubPredictionTrainingRecipePayloadParams)desc, (DeepHubPredictionModelDetails)summaryBase);
        } else if (desc instanceof TimeseriesForecastingTrainingRecipePayloadParams) {
            this.prepareTrainDescTimeseriesForecasting((TimeseriesForecastingTrainingRecipePayloadParams)desc, (TimeseriesForecastingModelDetails)summaryBase, options);
        } else if (desc instanceof CausalPredictionTrainingRecipePayloadParams) {
            this.prepareTrainDescCausalPrediction((CausalPredictionTrainingRecipePayloadParams)desc, (CausalPredictionModelDetails)summaryBase, options);
        } else {
            throw new IllegalArgumentException("Unsupported recipe payload params: " + desc.getClass().getSimpleName());
        }
        desc.splitParams = summaryBase.splitDesc.params;
        desc.script = fmi.parseSessionFile("script.json", SerializedShakerScript.class);
        desc.generatingModelId = fmi.toString();
        desc.modelVersionNamePrefix = fmi.getUserMeta().name;
        ResolvedCoreParams summaryCoreParams = summaryBase.getCoreParams();
        desc.backendType = summaryCoreParams.backendType;
        if (desc.backendType == MLTask.BackendType.PY_MEMORY || desc.backendType == MLTask.BackendType.KERAS || desc.backendType == MLTask.BackendType.DEEP_HUB) {
            desc.envSelection = summaryCoreParams.executionParams.envSelection;
            desc.envName = summaryCoreParams.executionParams.envName;
        }
        desc.expectedPreparationOutputSchema = summaryBase.splitDesc.schema;
    }

    private void prepareTrainDescClassicalPrediction(ClassicalPredictionTrainingRecipePayloadParams desc, ClassicalPredictionModelDetails summary, TrainingRecipeCreationOptions options) {
        desc.core = summary.coreParams;
        desc.needsInputDataFolder = StringUtils.isNotBlank((String)summary.coreParams.managedFolderSmartId);
        desc.core.managedFolderSmartId = null;
        desc.preprocessing = summary.preprocessing;
        desc.assertionsParams = summary.assertionsParams;
        desc.overridesParams = summary.overridesParams;
        desc.core.savedModelType = SavedModel.SavedModelType.DSS_MANAGED;
        if (options.redoOptimization) {
            desc.modeling = (PreTrainPredictionModelingParams)JSON.deepCopy((Object)summary.modeling);
        } else {
            PreTrainPredictionModelingParams.Algorithm algorithm = summary.modeling.algorithm;
            desc.modeling = algorithm.meta.regridifyToPreTrain((PostTrainPredictionModelingParams)summary.actualParams.resolved, summary.modeling);
        }
        if (options.redoThresholdOptimization) {
            desc.modeling.autoOptimizeThreshold = true;
        } else {
            desc.modeling.autoOptimizeThreshold = false;
            desc.modeling.forcedClassifierThreshold = options.fixedThreshold;
        }
        desc.sparkParams.sparkConf = summary.coreParams.executionParams.sparkParams.sparkConf;
        desc.sparkParams.sparkExecutionEngine = summary.coreParams.executionParams.sparkParams.sparkExecutionEngine;
        desc.sparkParams.sparkUseGlobalMetastore = summary.coreParams.executionParams.sparkParams.sparkUseGlobalMetastore;
        desc.sparkParams.sparkPreparedDFStorageLevel = summary.coreParams.executionParams.sparkParams.sparkPreparedDFStorageLevel;
        desc.operationMode = summary.splitDesc.params.kfold ? AbstractPredictionTrainingRecipePayloadParams.OperationMode.TRAIN_KFOLD : AbstractPredictionTrainingRecipePayloadParams.OperationMode.TRAIN_SPLITTED_ONLY;
    }

    private void prepareTrainDescDeepHub(DeepHubPredictionTrainingRecipePayloadParams desc, DeepHubPredictionModelDetails summary) {
        desc.core = summary.coreParams;
        desc.needsInputDataFolder = true;
        desc.core.managedFolderSmartId = null;
        desc.preprocessing = summary.preprocessing;
        desc.modeling = (DeepHubPreTrainModelingParams)JSON.deepCopy((Object)summary.modeling);
    }

    private void prepareTrainDescTimeseriesForecasting(TimeseriesForecastingTrainingRecipePayloadParams desc, TimeseriesForecastingModelDetails summary, TrainingRecipeCreationOptions options) {
        desc.core = summary.coreParams;
        desc.preprocessing = summary.preprocessing;
        if (options.redoOptimization) {
            desc.modeling = (PreTrainPredictionModelingParams)JSON.deepCopy((Object)summary.modeling);
        } else {
            PreTrainPredictionModelingParams.Algorithm algorithm = summary.modeling.algorithm;
            desc.modeling = algorithm.meta.regridifyToPreTrain((PostTrainPredictionModelingParams)summary.actualParams.resolved, summary.modeling);
        }
        desc.operationMode = summary.splitDesc.params.kfold ? AbstractPredictionTrainingRecipePayloadParams.OperationMode.TRAIN_KFOLD : AbstractPredictionTrainingRecipePayloadParams.OperationMode.TRAIN_SPLITTED_AND_FULL;
    }

    private void prepareTrainDescCausalPrediction(CausalPredictionTrainingRecipePayloadParams desc, CausalPredictionModelDetails summary, TrainingRecipeCreationOptions options) {
        desc.core = summary.coreParams;
        desc.preprocessing = summary.preprocessing;
        if (options.redoOptimization) {
            desc.modeling = (PreTrainPredictionModelingParams)JSON.deepCopy((Object)summary.modeling);
        } else {
            PreTrainPredictionModelingParams.Algorithm algorithm = summary.modeling.algorithm;
            desc.modeling = algorithm.meta.regridifyToPreTrain((PostTrainPredictionModelingParams)summary.actualParams.resolved, summary.modeling);
        }
    }

    public Map<SerializedRecipe, SavedModel> listUpdatableTrain(String projectKey, PredictionMLTask pmlTaskFromAnalysis) throws Exception {
        String treatmentVariable = null;
        String timeVariable = null;
        HashSet<String> timeSeriesIds = null;
        if (pmlTaskFromAnalysis instanceof PredictionMLTask.CausalPredictionMLTask) {
            treatmentVariable = ((PredictionMLTask.CausalPredictionMLTask)pmlTaskFromAnalysis).treatmentVariable;
        }
        if (pmlTaskFromAnalysis instanceof PredictionMLTask.TimeseriesForecastingMLTask) {
            PredictionMLTask.TimeseriesForecastingMLTask forecastingTaskFromAnalysis = (PredictionMLTask.TimeseriesForecastingMLTask)pmlTaskFromAnalysis;
            timeVariable = forecastingTaskFromAnalysis.timeVariable;
            timeSeriesIds = new HashSet<String>(forecastingTaskFromAnalysis.timeseriesIdentifiers);
        }
        HashMap<String, SavedModel> models = new HashMap<String, SavedModel>();
        for (SavedModel sm : this.savedModelsService.list(projectKey)) {
            if (sm.miniTask == null || sm.getType() != MLTask.MLTaskType.PREDICTION) continue;
            PredictionMLTask pmlTaskFromSM = (PredictionMLTask)sm.miniTask;
            if (!Objects.equals((Object)pmlTaskFromSM.predictionType, (Object)pmlTaskFromAnalysis.predictionType) || !Objects.equals(pmlTaskFromSM.targetVariable, pmlTaskFromAnalysis.targetVariable) || !Objects.equals((Object)pmlTaskFromSM.backendType, (Object)pmlTaskFromAnalysis.backendType)) continue;
            if (pmlTaskFromSM instanceof PredictionMLTask.CausalPredictionMLTask) {
                PredictionMLTask.CausalPredictionMLTask causalTaskFromSavedModel = (PredictionMLTask.CausalPredictionMLTask)pmlTaskFromSM;
                if (!causalTaskFromSavedModel.treatmentVariable.equals(treatmentVariable)) continue;
                models.put(sm.id, sm);
                continue;
            }
            if (pmlTaskFromSM instanceof PredictionMLTask.TimeseriesForecastingMLTask) {
                PredictionMLTask.TimeseriesForecastingMLTask forecastingTaskFromSavedModel = (PredictionMLTask.TimeseriesForecastingMLTask)pmlTaskFromSM;
                HashSet<String> timeseriesIdentifiersFromSavedModel = new HashSet<String>(forecastingTaskFromSavedModel.timeseriesIdentifiers);
                if (!forecastingTaskFromSavedModel.timeVariable.equals(timeVariable) || !timeSeriesIds.equals(timeseriesIdentifiersFromSavedModel)) continue;
                models.put(sm.id, sm);
                continue;
            }
            models.put(sm.id, sm);
        }
        logger.info((Object)("Check what we can redeploy with models: " + JSON.json(models)));
        HashMap<SerializedRecipe, SavedModel> result = new HashMap<SerializedRecipe, SavedModel>();
        if (!models.isEmpty()) {
            for (SerializedRecipe recipe : this.recipesDAO.list(projectKey)) {
                if (recipe.getOutputsForRole("main").size() != 1 || !models.containsKey(recipe.getSingleOutput((String)"main").ref)) continue;
                result.put(recipe, (SavedModel)models.get(recipe.getSingleOutput((String)"main").ref));
            }
        }
        return result;
    }

    public TabularPredictionScoringRecipePayloadParams getScoringRecipeDesc(String projectKey, String recipeId) throws IOException {
        String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeId);
        if (payload == null) {
            throw new IOException("Failed to parse payload for scoring recipe.");
        }
        return (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)payload, TabularPredictionScoringRecipePayloadParams.class);
    }

    public SingleWriteTransactionTransactionService.DetransactionalizedCallable<String> getSqlScoringQuery(AuthCtx authCtx, FullModelId fmi, SerializedRecipe sr, SavedModel sm) throws Exception {
        TabularPredictionScoringRecipePayloadParams desc = this.getScoringRecipeDesc(sm.getProjectKey(), sr.getId());
        ClassicalPredictionModelDetails details = PredictionResultsReader.makeDetails(fmi);
        FlowRecipe fr = new FlowRecipe(sr);
        RecipeRunnableSubgraph sg = this.validationService.getSampleSubgraph(fr);
        JobActivity activity = new JobActivity(sg);
        String connection = SQLQueryRecipeUtils.getSourceConnections((AuthCtx)authCtx, (RecipeRunnableSubgraph)sg).firstConnection;
        SQLDialect dialect = SQLConnectionProvider.getConnectionDialect(authCtx, connection);
        ResolvedClassicalPredictionCoreParams coreParams = (ResolvedClassicalPredictionCoreParams)JSON.parseFile((File)new File(fmi.getModelFolder(), "core_params.json"), ResolvedClassicalPredictionCoreParams.class);
        Pair<MLFlowUtils.ModelPartitionMode, FullModelId> modelPartitionModeFullModelIdPair = MLFlowUtils.getModelPartitionModeAndFullModelId(activity, coreParams, fmi);
        fmi = (FullModelId)modelPartitionModeFullModelIdPair.second;
        return PredictionRecipesService.getCallableSqlQuery(authCtx, activity, desc, fmi, this.getColumnsToAddForPrediction(desc, details, sm), dialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSqlQuery(AuthCtx auth, JobActivity activity, TabularPredictionScoringRecipePayloadParams desc, FullModelId fmi, Schema predictedColumns, SQLDialect dialect) throws Exception {
        SingleWriteTransactionTransactionService.DetransactionalizedCallable<String> callableSqlQuery = PredictionRecipesService.getCallableSqlQuery(auth, activity, desc, fmi, predictedColumns, dialect);
        ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).stashTheSingleTransaction();
        try {
            String string = callableSqlQuery.call_NT();
            return string;
        }
        finally {
            ((SingleWriteTransactionTransactionService)SpringUtils.getBean(SingleWriteTransactionTransactionService.class)).unstashTheSingleTransaction();
        }
    }

    private static SingleWriteTransactionTransactionService.DetransactionalizedCallable<String> getCallableSqlQuery(AuthCtx auth, JobActivity activity, final TabularPredictionScoringRecipePayloadParams desc, final FullModelId fmi, Schema predictedColumns, final SQLDialect dialect) throws Exception {
        ArrayList<String> keptColumns;
        Dataset outputDataset;
        logger.info((Object)"Generating SQL query for prediction scoring");
        FlowDataset inputFDS = activity.getSubgraph().getSourceDatasets().get(0);
        final Dataset inputDataset = inputFDS.getMandatory((DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class));
        if (!DatasetInspector.isSQLOrHive(inputDataset)) {
            throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Cannot use the SQL engine on a non-SQL dataset.");
        }
        if (activity.getSubgraph().getTargetsDatasets().isEmpty()) {
            outputDataset = null;
        } else {
            FlowDataset outputFDS = activity.getSubgraph().getTargetsDatasets().get(0);
            outputDataset = outputFDS.getMandatory((DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class));
        }
        final List<Partition> inputPartitions = activity.getSubgraph().getSourcePartitions(inputFDS);
        if (desc.filterInputColumns) {
            keptColumns = desc.keptInputColumns;
        } else {
            keptColumns = new ArrayList<String>();
            for (SchemaColumn c2 : inputDataset.getSchema().columns) {
                keptColumns.add(c2.getName());
            }
        }
        for (SchemaColumn predictedColumn : predictedColumns.getColumns()) {
            if (!keptColumns.contains(predictedColumn.getName())) continue;
            logger.warn((Object)("Column " + predictedColumn.getName() + " will be overwritten by prediction, not keeping it"));
            keptColumns.remove(predictedColumn.getName());
        }
        final PredictionScoringRecipeSchemaComputer schemaComputer = (PredictionScoringRecipeSchemaComputer)PredictionRecipesMeta.SCORING_META.buildSchemaComputer(auth, activity);
        final SavedModel sm = PredictionRecipesService.getSavedModel(activity);
        return new SingleWriteTransactionTransactionService.DetransactionalizedCallable<String>(){

            @Override
            public String call_NT() throws Exception {
                schemaComputer.setPayload(JSON.json((Object)desc));
                Schema outputSchema = schemaComputer.getSchema_NT();
                SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(inputDataset, dialect, null);
                Double forcedClassifierThreshold = desc.overrideModelSpecifiedThreshold ? Double.valueOf(desc.forcedClassifierThreshold) : null;
                Dataset workingOutputDataset = outputDataset == null ? new Dataset() : outputDataset;
                workingOutputDataset.setSchema(outputSchema);
                String query = SQLScoring.buildQuery(fmi, sm, inputDataset, inputPartitions, workingOutputDataset, keptColumns, table, dialect, forcedClassifierThreshold);
                logger.info((Object)("Generated query length=" + query.length()));
                logger.info((Object)("Generated query: " + query));
                return query;
            }
        };
    }

    public static class TrainingRecipeCreationOptions {
        public boolean redoOptimization;
        public boolean redoThresholdOptimization = true;
        public double fixedThreshold;
    }

    public static class ScoringRecipeCreationOptions {
        public String savedModelSmartName;
        public String inputDatasetSmartName;
        public String managedFolderSmartId;
        public boolean createOutput;
        public String outputDatasetSmartName;
        public ManagedDatasetsCreationService.ManagedDatasetCreationSettings outputDatasetCreationSettings;
        public String sparkInheritConf;
        public boolean sparkUseGlobalMetastore;
        public String zone;
    }

    public static class EvaluationRecipeCreationOptions {
        public String savedModelSmartName;
        public String modelVersionId = "";
        public String inputDatasetSmartName;
        public String managedFolderSmartId;
        public String scoredDatasetSmartName;
        public String metricsDatasetSmartName;
        public String evaluationStoreSmartName;
        public String sparkInheritConf;
        public boolean sparkUseGlobalMetastore;
        public String zone;
        public String evaluatedDeploymentId;
    }

    public static class StandaloneEvaluationRecipeCreationOptions {
        public String inputDatasetSmartName;
        public String referenceDatasetSmartName;
        public String evaluationStoreSmartName;
        public String sparkInheritConf;
        public boolean sparkUseGlobalMetastore;
        public String zone;
    }

    public static class TrainingRecipeCreability {
        List<InfoMessage> trainSchemaIncompatibilities = new ArrayList<InfoMessage>();
        List<InfoMessage> testSchemaIncompatibilities = new ArrayList<InfoMessage>();
        List<InfoMessage> otherIssues = new ArrayList<InfoMessage>();
    }
}

