/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.spark;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.logging.SparkLoggingConfigurator;
import com.dataiku.dip.recipes.code.spark.SparkBasedActivityHelper;
import com.dataiku.dip.recipes.code.spark.SparkConfigEnricher;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkJobBuilder;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkBasedDoctorJob {
    @Autowired
    private InsecureProcessesLaunchService insecureLaunchService;
    private final AuthCtx authCtx;
    private final File preprocessingFolder;
    private final String projectKey;
    private final APITicketService.ExpirableTicket ticket;
    private final MLTask task;
    private static final Logger logger = Logger.getLogger((String)"dku.analysis.spark");

    public SparkBasedDoctorJob(AuthCtx authCtx, String projectKey, File preprocessingFolder, MLTask task, APITicketService.ExpirableTicket ticket) {
        this.authCtx = authCtx;
        this.preprocessingFolder = preprocessingFolder;
        this.projectKey = projectKey;
        this.task = task;
        this.ticket = ticket;
        SpringUtils.getInstance().autowire((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSpark(SparkDoctorJobBuilder jobBuilder, SparkJobHelper.SparkJobPostProcessor postProcessor) throws Exception {
        ClusterSettings clusterSettings = new ClusterSelector().selectForProject(this.authCtx, this.projectKey);
        SparkSettings sparkSettings = clusterSettings.getSparkSettings();
        HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
        List<SimpleKeyValue> conf = SparkJobHelper.composeConf(this.authCtx, this.projectKey, sparkSettings, this.task.sparkParams.sparkConf, jobBuilder.getContextOverrideConf());
        try (SparkBasedActivityHelper helper = new SparkBasedActivityHelper(this.projectKey, this.authCtx, (File)FlowJobUtils.getTmpFolder("sparkbased-doctor", "out"), null);){
            HashSet<String> relevantProjectKeys = new HashSet<String>();
            relevantProjectKeys.add(this.projectKey);
            relevantProjectKeys.addAll(jobBuilder.getExtraRelevantProjectkeys());
            helper.configure(relevantProjectKeys, conf, clusterSettings);
            new SparkConfigEnricher().setMetastoreConfKeysInKeys(conf);
            EnvironmentStash stash = new EnvironmentStash();
            stash.fillDefault();
            stash.apiTicket = this.ticket.getSecret();
            stash.env.putAll(helper.getProcessExtraEnv());
            switch (this.task.sparkParams.sparkExecutionEngine) {
                case SPARK_SUBMIT: {
                    SparkSubmitHelper sparkSubmitHelper = SparkSubmitHelper.build(this.projectKey, this.authCtx, sparkSettings, hadoopSettings, null, sparkSettings.getByName(this.task.sparkParams.sparkConf.inheritConf));
                    SparkSubmitJob job = jobBuilder.buildSparkJob(sparkSubmitHelper, helper.getProcessRunDir(), sparkSettings, conf);
                    for (File file : SparkLoggingConfigurator.copyConfigurationFilesToRunDir(helper.getProcessRunDir())) {
                        job.nonSecretGlobalFiles.add(file.getAbsolutePath());
                    }
                    SparkJobHelper.SparkJobContext context = sparkSubmitHelper.runsInClusterMode(job) ? sparkSubmitHelper.setupRunUsingCluster(SparkJobHelper.RunMode.SPARK, jobBuilder, helper.getProcessRunDir(), job, stash, helper.getJobExecEnv(), null) : sparkSubmitHelper.setupRunUsingClient(SparkJobHelper.RunMode.SPARK, jobBuilder, helper.getProcessRunDir(), job, stash, helper.getJobExecEnv(), null);
                    List<String> cmd = sparkSubmitHelper.toCommand(job);
                    try {
                        RegularProcess process;
                        File ppLogFile = new File(this.preprocessingFolder, "train.log");
                        logger.info((Object)("Also writing to " + ppLogFile.getAbsolutePath()));
                        ProcessBuilder builder = new ProcessBuilder(new String[0]);
                        builder.command(cmd);
                        builder.directory(helper.getProcessRunDir());
                        builder.environment().putAll(stash.getAsEnvVariables(true, false, false));
                        logger.debug((Object)("Executing " + StringUtils.join(builder.command(), (String)" \\\n\t")));
                        if (context.impersonatesRemotely()) {
                            process = new RegularProcess(builder, helper.getProcessRunDir());
                            process.start();
                        } else {
                            process = this.insecureLaunchService.launch(this.authCtx, this.projectKey, null, helper.getProcessRunDir(), builder);
                        }
                        this.runAndHandleError((IsolableProcess)process, ppLogFile, context);
                        if (postProcessor != null) {
                            postProcessor.postProcess(context);
                        }
                        break;
                    }
                    finally {
                        context.close();
                    }
                }
                default: {
                    throw new Error("Unsupported execution engine: " + String.valueOf((Object)this.task.sparkParams.sparkExecutionEngine));
                }
            }
        }
    }

    private void runAndHandleError(IsolableProcess process, File log, SparkJobHelper.SparkJobContext context) throws Exception {
        int ret;
        DKUtils.ExecOutputConsumer outputConsumer = new DKUtils.ExecOutputConsumer();
        try (FileOutputStream logOutputStream = new FileOutputStream(log, true);){
            outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
            outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription((OutputStream)logOutputStream, false));
            outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
            outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription((OutputStream)logOutputStream, false));
            outputConsumer.start(process.getInputStream(), process.getErrorStream(), process.getOutputStream());
            ret = process.waitFor();
            outputConsumer.finish();
        }
        if (ret == 0 && context != null) {
            ret = context.doubleCheckRunStarted();
        }
        if (ret != 0) {
            SerializedError err;
            try {
                File errorFile = new File(context.getLocalRunDir(), "error.json");
                err = (SerializedError)JSON.parseFile((File)errorFile, SerializedError.class);
            }
            catch (Exception e) {
                logger.error((Object)"Could not retrieve Spark training error details", (Throwable)e);
                throw new Exception("Spark training failed (return code " + ret + ")");
            }
            throw new APIError.SerializedErrorException(err);
        }
    }

    public static abstract class SparkDoctorJobBuilder
    extends SparkJobBuilder {
        public List<String> getExtraRelevantProjectkeys() {
            return Lists.newArrayList();
        }
    }
}

